/*
 * Decompiled with CFR 0.152.
 */
package org.wellquite.kenya.stackMachine.types;

import org.wellquite.kenya.stackMachine.types.IntType;
import org.wellquite.kenya.stackMachine.types.interfaces.ICharType;
import org.wellquite.kenya.stackMachine.types.interfaces.INumericType;

public class CharType
implements ICharType {
    private char value = '\u0000';
    private boolean assigned = false;

    public CharType() {
    }

    public CharType(char value) {
        this.value = value;
        this.assigned = true;
    }

    public synchronized Character getValue() {
        return new Character(this.value);
    }

    public synchronized void setValue(Character value) {
        if (this.assigned) {
            CharType.modificationError(this);
        } else {
            this.value = value.charValue();
            this.assigned = true;
        }
    }

    public synchronized String toString() {
        return "CharType: " + this.value;
    }

    public synchronized boolean valueSet() {
        return this.assigned;
    }

    private static void modificationError(CharType variable) {
        throw new RuntimeException("Attempt made to modify String variable: " + variable);
    }

    public String valueToString() {
        return "" + this.value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ICharType) {
            return ((ICharType)obj).getValue().charValue() == this.getValue().charValue();
        }
        if (obj instanceof INumericType) {
            if (obj instanceof IntType) {
                return ((INumericType)obj).getValue().intValue() == this.getValue().charValue();
            }
            return ((INumericType)obj).getValue().doubleValue() == (double)this.getValue().charValue();
        }
        return false;
    }

    public int hashCode() {
        return this.getValue().hashCode();
    }
}

