/*
 * Decompiled with CFR 0.152.
 */
package org.wellquite.kenya.stackMachine.types;

import org.wellquite.kenya.stackMachine.types.interfaces.IEnumType;
import org.wellquite.kenya.stackMachine.types.interfaces.IInterpretedEnumeration;

public class EnumType
implements IEnumType {
    private IInterpretedEnumeration enumeration = null;
    private Object value = null;
    private boolean assigned = false;

    public EnumType() {
    }

    public EnumType(Object value, IInterpretedEnumeration enumeration) {
        if (!enumeration.isValidValue(value) && value != null) {
            throw new IllegalArgumentException("Attempt made to create an enumType with a value which is not a member of the enumeration.");
        }
        this.value = value;
        this.enumeration = enumeration;
        this.assigned = true;
    }

    public synchronized Object getValue() {
        return this.value;
    }

    public synchronized void setValue(Object value, IInterpretedEnumeration enumeration) {
        if (this.assigned && this.value != null) {
            EnumType.modificationError(this);
        } else if (enumeration.isValidValue(value)) {
            this.value = value;
            this.enumeration = enumeration;
            this.assigned = true;
        } else {
            throw new IllegalArgumentException("Attempt made to create an enumType with a value which is not a member of the enumeration.");
        }
    }

    public synchronized String toString() {
        return "EnumType: " + this.value;
    }

    private static void modificationError(EnumType variable) {
        throw new RuntimeException("Attempt made to modify EnumType variable: " + variable);
    }

    public synchronized boolean valueSet() {
        return this.assigned && this.value != null;
    }

    public String getValueClassName() {
        return "EnumeratedType";
    }

    public String valueToString() {
        return this.value.toString();
    }

    public synchronized IInterpretedEnumeration getEnumeration() {
        return this.enumeration;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IEnumType) {
            return ((IEnumType)obj).getValue().equals(this.getValue()) && ((IEnumType)obj).getEnumeration().equals(this.getEnumeration());
        }
        return false;
    }

    public int hashCode() {
        if (this.getValue() == null) {
            return this.getEnumeration().hashCode();
        }
        return this.getValue().hashCode() ^ this.getEnumeration().hashCode();
    }
}

