/*
 * Decompiled with CFR 0.152.
 */
package org.wellquite.kenya.stackMachine.types;

import org.wellquite.kenya.stackMachine.types.interfaces.ICharType;
import org.wellquite.kenya.stackMachine.types.interfaces.INumericType;

public class IntType
implements INumericType {
    private int value = 0;
    private boolean assigned = false;

    public IntType() {
    }

    public IntType(int value) {
        this.value = value;
        this.assigned = true;
    }

    public synchronized Number getValue() {
        return new Integer(this.value);
    }

    public synchronized void setValue(Number value) {
        if (this.assigned) {
            IntType.modificationError(this);
        } else {
            this.value = value.intValue();
            this.assigned = true;
        }
    }

    public synchronized String toString() {
        return "IntType: " + this.value;
    }

    public synchronized boolean valueSet() {
        return this.assigned;
    }

    private static void modificationError(IntType variable) {
        throw new RuntimeException("Attempt made to modify String variable: " + variable);
    }

    public String valueToString() {
        return "" + this.value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof INumericType) {
            if (obj instanceof IntType) {
                return ((INumericType)obj).getValue().intValue() == this.getValue().intValue();
            }
            return ((INumericType)obj).getValue().doubleValue() == (double)this.getValue().intValue();
        }
        if (obj instanceof ICharType) {
            return ((ICharType)obj).getValue().charValue() == this.getValue().intValue();
        }
        return false;
    }

    public int hashCode() {
        return this.getValue().hashCode();
    }
}

