/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Button
extends Control {
    int boxHandle;
    int labelHandle;
    int imageHandle;
    int arrowHandle;
    int groupHandle;
    boolean selected;
    Image image;
    String text;

    public Button(Composite parent, int style) {
        super(parent, Button.checkStyle(style));
    }

    static int checkStyle(int style) {
        if (((style = Widget.checkBits(style, 8, 4, 32, 16, 2, 0)) & 0xA) != 0) {
            return Widget.checkBits(style, 0x1000000, 16384, 131072, 0, 0, 0);
        }
        if ((style & 0x30) != 0) {
            return Widget.checkBits(style, 16384, 131072, 0x1000000, 0, 0, 0);
        }
        if ((style & 4) != 0) {
            return Widget.checkBits(style |= 0x80000, 128, 1024, 16384, 131072, 0, 0);
        }
        return style;
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        if (wHint != -1 && wHint < 0) {
            wHint = 0;
        }
        if (hHint != -1 && hHint < 0) {
            hHint = 0;
        }
        int width = OS.GTK_WIDGET_WIDTH((int)this.fixedHandle);
        int height = OS.GTK_WIDGET_HEIGHT((int)this.fixedHandle);
        OS.gtk_widget_set_size_request((int)this.handle, (int)wHint, (int)hHint);
        GtkRequisition requisition = new GtkRequisition();
        OS.gtk_widget_size_request((int)this.handle, (GtkRequisition)requisition);
        OS.gtk_widget_set_size_request((int)this.handle, (int)width, (int)height);
        width = wHint == -1 ? requisition.width : wHint;
        height = hHint == -1 ? requisition.height : hHint;
        return new Point(width, height);
    }

    void createHandle(int index) {
        this.state |= 8;
        int bits = 62;
        this.fixedHandle = OS.g_object_new((int)this.display.gtk_fixed_get_type(), (int)0);
        if (this.fixedHandle == 0) {
            this.error(2);
        }
        OS.gtk_fixed_set_has_window((int)this.fixedHandle, (boolean)true);
        switch (this.style & bits) {
            case 4: {
                int arrow_type = 0;
                if ((this.style & 0x80) != 0) {
                    arrow_type = 0;
                }
                if ((this.style & 0x400) != 0) {
                    arrow_type = 1;
                }
                if ((this.style & 0x4000) != 0) {
                    arrow_type = 2;
                }
                if ((this.style & 0x20000) != 0) {
                    arrow_type = 3;
                }
                this.handle = OS.gtk_button_new();
                if (this.handle == 0) {
                    this.error(2);
                }
                this.arrowHandle = OS.gtk_arrow_new((int)arrow_type, (int)2);
                if (this.arrowHandle != 0) break;
                this.error(2);
                break;
            }
            case 2: {
                this.handle = OS.gtk_toggle_button_new();
                if (this.handle != 0) break;
                this.error(2);
                break;
            }
            case 32: {
                this.handle = OS.gtk_check_button_new();
                if (this.handle != 0) break;
                this.error(2);
                break;
            }
            case 16: {
                this.groupHandle = OS.gtk_radio_button_new((int)0);
                if (this.groupHandle == 0) {
                    this.error(2);
                }
                OS.g_object_ref((int)this.groupHandle);
                OS.gtk_object_sink((int)this.groupHandle);
                this.handle = OS.gtk_radio_button_new((int)OS.gtk_radio_button_get_group((int)this.groupHandle));
                if (this.handle != 0) break;
                this.error(2);
                break;
            }
            default: {
                this.handle = OS.gtk_button_new();
                if (this.handle == 0) {
                    this.error(2);
                }
                OS.GTK_WIDGET_SET_FLAGS((int)this.handle, (int)8192);
            }
        }
        if ((this.style & 4) != 0) {
            OS.gtk_container_add((int)this.handle, (int)this.arrowHandle);
        } else {
            this.boxHandle = OS.gtk_hbox_new((boolean)false, (int)0);
            if (this.boxHandle == 0) {
                this.error(2);
            }
            this.labelHandle = OS.gtk_label_new_with_mnemonic(null);
            if (this.labelHandle == 0) {
                this.error(2);
            }
            this.imageHandle = OS.gtk_image_new();
            if (this.imageHandle == 0) {
                this.error(2);
            }
            OS.gtk_container_add((int)this.handle, (int)this.boxHandle);
            OS.gtk_container_add((int)this.boxHandle, (int)this.labelHandle);
            OS.gtk_container_add((int)this.boxHandle, (int)this.imageHandle);
        }
        OS.gtk_container_add((int)this.fixedHandle, (int)this.handle);
        if ((this.style & 4) != 0) {
            return;
        }
        if ((this.style & 0x4000) != 0) {
            OS.gtk_misc_set_alignment((int)this.labelHandle, (float)0.0f, (float)0.5f);
            OS.gtk_label_set_justify((int)this.labelHandle, (int)0);
            OS.gtk_misc_set_alignment((int)this.imageHandle, (float)0.0f, (float)0.5f);
            return;
        }
        if ((this.style & 0x1000000) != 0) {
            OS.gtk_misc_set_alignment((int)this.labelHandle, (float)0.5f, (float)0.5f);
            OS.gtk_label_set_justify((int)this.labelHandle, (int)2);
            OS.gtk_misc_set_alignment((int)this.imageHandle, (float)0.5f, (float)0.5f);
            return;
        }
        if ((this.style & 0x20000) != 0) {
            OS.gtk_misc_set_alignment((int)this.labelHandle, (float)1.0f, (float)0.5f);
            OS.gtk_label_set_justify((int)this.labelHandle, (int)1);
            OS.gtk_misc_set_alignment((int)this.imageHandle, (float)1.0f, (float)0.5f);
            return;
        }
    }

    void createWidget(int index) {
        super.createWidget(index);
        this.text = "";
    }

    void deregister() {
        super.deregister();
        if (this.boxHandle != 0) {
            this.display.removeWidget(this.boxHandle);
        }
        if (this.labelHandle != 0) {
            this.display.removeWidget(this.labelHandle);
        }
        if (this.imageHandle != 0) {
            this.display.removeWidget(this.imageHandle);
        }
        if (this.arrowHandle != 0) {
            this.display.removeWidget(this.arrowHandle);
        }
    }

    int fontHandle() {
        if (this.labelHandle != 0) {
            return this.labelHandle;
        }
        return super.fontHandle();
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            if ((this.style & 0x80) != 0) {
                return 128;
            }
            if ((this.style & 0x400) != 0) {
                return 1024;
            }
            if ((this.style & 0x4000) != 0) {
                return 16384;
            }
            if ((this.style & 0x20000) != 0) {
                return 131072;
            }
            return 128;
        }
        if ((this.style & 0x4000) != 0) {
            return 16384;
        }
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    String getNameText() {
        return this.getText();
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x32) == 0) {
            return false;
        }
        return OS.gtk_toggle_button_get_active((int)this.handle);
    }

    public String getText() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return "";
        }
        return this.text;
    }

    int gtk_button_press_event(int widget, int event) {
        int result = super.gtk_button_press_event(widget, event);
        if (result != 0) {
            return result;
        }
        if ((this.style & 0x10) != 0) {
            this.selected = this.getSelection();
        }
        return result;
    }

    int gtk_clicked(int widget) {
        if ((this.style & 0x10) != 0) {
            if ((this.parent.getStyle() & 0x400000) != 0) {
                this.setSelection(!this.selected);
            } else {
                this.selectRadio();
            }
        }
        this.postEvent(13);
        return 0;
    }

    int gtk_focus_in_event(int widget, int event) {
        int result = super.gtk_focus_in_event(widget, event);
        if (this.handle == 0) {
            return 0;
        }
        if ((this.style & 8) != 0 && OS.GTK_WIDGET_HAS_DEFAULT((int)this.handle)) {
            Decorations menuShell = this.menuShell();
            menuShell.defaultButton = this;
        }
        return result;
    }

    int gtk_focus_out_event(int widget, int event) {
        int result = super.gtk_focus_out_event(widget, event);
        if (this.handle == 0) {
            return 0;
        }
        if ((this.style & 8) != 0 && !OS.GTK_WIDGET_HAS_DEFAULT((int)this.handle)) {
            Decorations menuShell = this.menuShell();
            if (menuShell.defaultButton == this) {
                menuShell.defaultButton = null;
            }
        }
        return result;
    }

    int gtk_key_press_event(int widget, int event) {
        int result = super.gtk_key_press_event(widget, event);
        if (result != 0) {
            return result;
        }
        if ((this.style & 0x10) != 0) {
            this.selected = this.getSelection();
        }
        return result;
    }

    void hookEvents() {
        super.hookEvents();
        OS.g_signal_connect((int)this.handle, (byte[])OS.clicked, (int)this.display.windowProc2, (int)5);
        if (this.labelHandle != 0) {
            OS.g_signal_connect((int)this.labelHandle, (byte[])OS.mnemonic_activate, (int)this.display.windowProc3, (int)25);
        }
    }

    boolean mnemonicHit(char key) {
        if (this.labelHandle == 0) {
            return false;
        }
        boolean result = super.mnemonicHit(this.labelHandle, key);
        if (result) {
            this.setFocus();
        }
        return result;
    }

    boolean mnemonicMatch(char key) {
        if (this.labelHandle == 0) {
            return false;
        }
        return this.mnemonicMatch(this.labelHandle, key);
    }

    void register() {
        super.register();
        if (this.boxHandle != 0) {
            this.display.addWidget(this.boxHandle, this);
        }
        if (this.labelHandle != 0) {
            this.display.addWidget(this.labelHandle, this);
        }
        if (this.imageHandle != 0) {
            this.display.addWidget(this.imageHandle, this);
        }
        if (this.arrowHandle != 0) {
            this.display.addWidget(this.arrowHandle, this);
        }
    }

    void releaseHandle() {
        super.releaseHandle();
        this.arrowHandle = 0;
        this.labelHandle = 0;
        this.imageHandle = 0;
        this.boxHandle = 0;
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.groupHandle != 0) {
            OS.g_object_unref((int)this.groupHandle);
        }
        this.groupHandle = 0;
        this.image = null;
        this.text = null;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    void selectRadio() {
        Control[] children = this.parent._getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            if (this != child) {
                child.setRadioSelection(false);
            }
            ++i;
        }
        this.setSelection(true);
    }

    public void setAlignment(int alignment) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            if ((this.style & 0x24480) == 0) {
                return;
            }
            this.style &= 0xFFFDBB7F;
            this.style |= alignment & 0x24480;
            int arrow_type = 0;
            boolean isRTL = (this.style & 0x4000000) != 0;
            switch (alignment) {
                case 128: {
                    arrow_type = 0;
                    break;
                }
                case 1024: {
                    arrow_type = 1;
                    break;
                }
                case 16384: {
                    arrow_type = isRTL ? 3 : 2;
                    break;
                }
                case 131072: {
                    arrow_type = isRTL ? 2 : 3;
                }
            }
            OS.gtk_arrow_set((int)this.arrowHandle, (int)arrow_type, (int)2);
            return;
        }
        if ((alignment & 0x1024000) == 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= alignment & 0x1024000;
        if ((this.style & 0x4000) != 0) {
            OS.gtk_misc_set_alignment((int)this.labelHandle, (float)0.0f, (float)0.5f);
            OS.gtk_label_set_justify((int)this.labelHandle, (int)0);
            OS.gtk_misc_set_alignment((int)this.imageHandle, (float)0.0f, (float)0.5f);
            return;
        }
        if ((this.style & 0x1000000) != 0) {
            OS.gtk_misc_set_alignment((int)this.labelHandle, (float)0.5f, (float)0.5f);
            OS.gtk_label_set_justify((int)this.labelHandle, (int)2);
            OS.gtk_misc_set_alignment((int)this.imageHandle, (float)0.5f, (float)0.5f);
            return;
        }
        if ((this.style & 0x20000) != 0) {
            OS.gtk_misc_set_alignment((int)this.labelHandle, (float)1.0f, (float)0.5f);
            OS.gtk_label_set_justify((int)this.labelHandle, (int)1);
            OS.gtk_misc_set_alignment((int)this.imageHandle, (float)1.0f, (float)0.5f);
            return;
        }
    }

    void setBackgroundColor(GdkColor color) {
        super.setBackgroundColor(color);
        this.setBackgroundColor(this.fixedHandle, color);
        if (this.labelHandle != 0) {
            this.setBackgroundColor(this.labelHandle, color);
        }
        if (this.imageHandle != 0) {
            this.setBackgroundColor(this.imageHandle, color);
        }
    }

    boolean setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        boolean result = super.setBounds(x, y, width, height, move, resize);
        if (result && (this.style & 0x30) != 0) {
            int childHeight = 0;
            int buttonWidth = 0;
            int buttonHeight = 0;
            GtkRequisition requisition = new GtkRequisition();
            OS.gtk_widget_size_request((int)this.handle, (GtkRequisition)requisition);
            buttonWidth = requisition.width;
            buttonHeight = requisition.height;
            OS.gtk_widget_size_request((int)this.boxHandle, (GtkRequisition)requisition);
            childHeight = requisition.height;
            OS.gtk_widget_set_size_request((int)this.handle, (int)-1, (int)-1);
            OS.gtk_widget_set_size_request((int)this.boxHandle, (int)-1, (int)-1);
            OS.gtk_widget_size_request((int)this.handle, (GtkRequisition)requisition);
            int trim = requisition.width;
            OS.gtk_widget_size_request((int)this.boxHandle, (GtkRequisition)requisition);
            OS.gtk_widget_set_size_request((int)this.handle, (int)buttonWidth, (int)buttonHeight);
            OS.gtk_widget_set_size_request((int)this.boxHandle, (int)Math.max(1, width - (trim -= requisition.width)), (int)childHeight);
        }
        return result;
    }

    void setFontDescription(int font) {
        super.setFontDescription(font);
        if (this.labelHandle != 0) {
            OS.gtk_widget_modify_font((int)this.labelHandle, (int)font);
        }
        if (this.imageHandle != 0) {
            OS.gtk_widget_modify_font((int)this.imageHandle, (int)font);
        }
    }

    boolean setRadioSelection(boolean value) {
        if ((this.style & 0x10) == 0) {
            return false;
        }
        if (this.getSelection() != value) {
            this.setSelection(value);
            this.postEvent(13);
        }
        return true;
    }

    void setForegroundColor(GdkColor color) {
        super.setForegroundColor(color);
        OS.gtk_widget_modify_fg((int)this.fixedHandle, (int)0, (GdkColor)color);
        if (this.labelHandle != 0) {
            OS.gtk_widget_modify_fg((int)this.labelHandle, (int)0, (GdkColor)color);
        }
        if (this.imageHandle != 0) {
            OS.gtk_widget_modify_fg((int)this.imageHandle, (int)0, (GdkColor)color);
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        if (image != null) {
            if (image.isDisposed()) {
                this.error(5);
            }
            OS.gtk_image_set_from_pixmap((int)this.imageHandle, (int)image.pixmap, (int)image.mask);
            OS.gtk_widget_hide((int)this.labelHandle);
            OS.gtk_widget_show((int)this.imageHandle);
        } else {
            OS.gtk_image_set_from_pixmap((int)this.imageHandle, (int)0, (int)0);
            OS.gtk_widget_show((int)this.labelHandle);
            OS.gtk_widget_hide((int)this.imageHandle);
        }
        this.image = image;
        GtkRequisition requisition = new GtkRequisition();
        OS.gtk_widget_size_request((int)this.handle, (GtkRequisition)requisition);
    }

    void setOrientation() {
        if ((this.style & 0x4000000) != 0) {
            OS.gtk_widget_set_direction((int)this.handle, (int)2);
            if (this.labelHandle != 0) {
                OS.gtk_widget_set_direction((int)this.labelHandle, (int)2);
            }
            if (this.imageHandle != 0) {
                OS.gtk_widget_set_direction((int)this.imageHandle, (int)2);
            }
            if (this.arrowHandle != 0) {
                switch (this.style & 0x24000) {
                    case 16384: {
                        OS.gtk_arrow_set((int)this.arrowHandle, (int)3, (int)2);
                        break;
                    }
                    case 131072: {
                        OS.gtk_arrow_set((int)this.arrowHandle, (int)2, (int)2);
                    }
                }
            }
        }
    }

    public void setSelection(boolean selected) {
        this.checkWidget();
        if ((this.style & 0x32) == 0) {
            return;
        }
        OS.g_signal_handlers_block_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)5);
        OS.gtk_toggle_button_set_active((int)this.handle, (boolean)selected);
        if ((this.style & 0x10) != 0) {
            OS.gtk_toggle_button_set_active((int)this.groupHandle, (!selected ? 1 : 0) != 0);
        }
        OS.g_signal_handlers_unblock_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)5);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 4) != 0) {
            return;
        }
        this.text = string;
        char[] chars = this.fixMnemonic(string);
        byte[] buffer = Converter.wcsToMbcs(null, chars, true);
        OS.gtk_label_set_text_with_mnemonic((int)this.labelHandle, (byte[])buffer);
        OS.gtk_widget_hide((int)this.imageHandle);
        OS.gtk_widget_show((int)this.labelHandle);
        GtkRequisition requisition = new GtkRequisition();
        OS.gtk_widget_size_request((int)this.handle, (GtkRequisition)requisition);
    }

    void showWidget() {
        super.showWidget();
        if (this.boxHandle != 0) {
            OS.gtk_widget_show((int)this.boxHandle);
        }
        if (this.labelHandle != 0) {
            OS.gtk_widget_show((int)this.labelHandle);
        }
        if (this.arrowHandle != 0) {
            OS.gtk_widget_show((int)this.arrowHandle);
        }
    }

    int traversalCode(int key, GdkEventKey event) {
        int code = super.traversalCode(key, event);
        if ((this.style & 0x10) != 0) {
            code |= 0x60;
        }
        return code;
    }
}

