/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.GtkCombo;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Combo
extends Composite {
    int arrowHandle;
    int entryHandle;
    int listHandle;
    int lastEventTime;
    int visibleCount = 5;
    String[] items = new String[0];
    boolean ignoreSelect;
    static final int INNER_BORDER = 2;
    public static final int LIMIT = 65535;

    public Combo(Composite parent, int style) {
        super(parent, Combo.checkStyle(style));
    }

    public void add(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        String[] newItems = new String[this.items.length + 1];
        System.arraycopy(this.items, 0, newItems, 0, this.items.length);
        newItems[this.items.length] = string;
        this.setItems(newItems, true, true);
    }

    public void add(String string, int index) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (index < 0 || index > this.items.length) {
            this.error(6);
        }
        String[] newItems = new String[this.items.length + 1];
        System.arraycopy(this.items, 0, newItems, 0, index);
        newItems[index] = string;
        System.arraycopy(this.items, index, newItems, index + 1, this.items.length - index);
        this.setItems(newItems, true, true);
    }

    public void addModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(24, typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        style &= 0xFFFFF7FF;
        style &= 0xFFFFFCFF;
        if (((style = Widget.checkBits(style, 4, 64, 0, 0, 0, 0)) & 0x40) != 0) {
            return style & 0xFFFFFFF7;
        }
        return style;
    }

    public void clearSelection() {
        this.checkWidget();
        int position = OS.gtk_editable_get_position((int)this.entryHandle);
        OS.gtk_editable_select_region((int)this.entryHandle, (int)position, (int)position);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        if (wHint != -1 && wHint < 0) {
            wHint = 0;
        }
        if (hHint != -1 && hHint < 0) {
            hHint = 0;
        }
        int[] w = new int[1];
        int[] h = new int[1];
        int layout = OS.gtk_entry_get_layout((int)this.entryHandle);
        OS.pango_layout_get_size((int)layout, (int[])w, (int[])h);
        int xborder = 2;
        int yborder = 2;
        int style = OS.gtk_widget_get_style((int)this.entryHandle);
        xborder += OS.gtk_style_get_xthickness((int)style);
        yborder += OS.gtk_style_get_ythickness((int)style);
        int[] property = new int[1];
        OS.gtk_widget_style_get((int)this.entryHandle, (byte[])OS.interior_focus, (int[])property, (int)0);
        if (property[0] != 0) {
            OS.gtk_widget_style_get((int)this.entryHandle, (byte[])OS.focus_line_width, (int[])property, (int)0);
            xborder += property[0];
            yborder += property[0];
        }
        int width = OS.PANGO_PIXELS((int)w[0]) + xborder * 2;
        int height = OS.PANGO_PIXELS((int)h[0]) + yborder * 2;
        GtkRequisition arrowRequesition = new GtkRequisition();
        OS.gtk_widget_size_request((int)this.arrowHandle, (GtkRequisition)arrowRequesition);
        GtkRequisition listRequesition = new GtkRequisition();
        int listParent = OS.gtk_widget_get_parent((int)this.listHandle);
        OS.gtk_widget_size_request((int)(listParent != 0 ? listParent : this.listHandle), (GtkRequisition)listRequesition);
        width = Math.max(listRequesition.width, width) + arrowRequesition.width + 4;
        width = wHint == -1 ? width : wHint;
        height = hHint == -1 ? height : hHint;
        return new Point(width, height);
    }

    public void copy() {
        this.checkWidget();
        OS.gtk_editable_copy_clipboard((int)this.entryHandle);
    }

    void createHandle(int index) {
        this.state |= 0x28;
        this.fixedHandle = OS.g_object_new((int)this.display.gtk_fixed_get_type(), (int)0);
        if (this.fixedHandle == 0) {
            this.error(2);
        }
        OS.gtk_fixed_set_has_window((int)this.fixedHandle, (boolean)true);
        this.handle = OS.gtk_combo_new();
        if (this.handle == 0) {
            this.error(2);
        }
        OS.gtk_container_add((int)this.fixedHandle, (int)this.handle);
        GtkCombo combo = new GtkCombo();
        OS.memmove((GtkCombo)combo, (int)this.handle);
        this.entryHandle = combo.entry;
        this.listHandle = combo.list;
        int list = OS.gtk_container_get_children((int)this.handle);
        if (list != 0) {
            int i = 0;
            int count = OS.g_list_length((int)list);
            while (i < count) {
                int childHandle = OS.g_list_nth_data((int)list, (int)i);
                if (childHandle != this.entryHandle && childHandle != this.listHandle) {
                    this.arrowHandle = childHandle;
                    break;
                }
                ++i;
            }
            OS.g_list_free((int)list);
        }
        boolean editable = (this.style & 8) == 0;
        OS.gtk_editable_set_editable((int)this.entryHandle, (boolean)editable);
        OS.gtk_entry_set_activates_default((int)this.entryHandle, (boolean)true);
        OS.gtk_combo_disable_activate((int)this.handle);
        OS.gtk_combo_set_case_sensitive((int)this.handle, (boolean)true);
    }

    public void cut() {
        this.checkWidget();
        OS.gtk_editable_cut_clipboard((int)this.entryHandle);
    }

    void deregister() {
        super.deregister();
        if (this.arrowHandle != 0) {
            this.display.removeWidget(this.arrowHandle);
        }
        this.display.removeWidget(this.entryHandle);
        this.display.removeWidget(this.listHandle);
        int imContext = this.imContext();
        if (imContext != 0) {
            this.display.removeWidget(imContext);
        }
    }

    int fontHandle() {
        if (this.entryHandle != 0) {
            return this.entryHandle;
        }
        return super.fontHandle();
    }

    int focusHandle() {
        if (this.entryHandle != 0) {
            return this.entryHandle;
        }
        return super.focusHandle();
    }

    boolean hasFocus() {
        if (super.hasFocus()) {
            return true;
        }
        if (OS.GTK_WIDGET_HAS_FOCUS((int)this.entryHandle)) {
            return true;
        }
        return OS.GTK_WIDGET_HAS_FOCUS((int)this.listHandle);
    }

    void hookEvents() {
        super.hookEvents();
        int windowProc2 = this.display.windowProc2;
        int windowProc3 = this.display.windowProc3;
        OS.g_signal_connect_after((int)this.entryHandle, (byte[])OS.changed, (int)windowProc2, (int)4);
        OS.g_signal_connect((int)this.entryHandle, (byte[])OS.activate, (int)windowProc2, (int)1);
        int eventMask = 13060;
        int[] handles = new int[]{this.arrowHandle, this.entryHandle, this.listHandle};
        int i = 0;
        while (i < handles.length) {
            int eventHandle = handles[i];
            if (eventHandle != 0) {
                OS.gtk_widget_add_events((int)eventHandle, (int)eventMask);
                OS.g_signal_connect((int)eventHandle, (byte[])OS.button_press_event, (int)windowProc3, (int)2);
                OS.g_signal_connect((int)eventHandle, (byte[])OS.button_release_event, (int)windowProc3, (int)3);
                OS.g_signal_connect((int)eventHandle, (byte[])OS.motion_notify_event, (int)windowProc3, (int)26);
                OS.g_signal_connect((int)eventHandle, (byte[])OS.enter_notify_event, (int)windowProc3, (int)11);
                OS.g_signal_connect((int)eventHandle, (byte[])OS.leave_notify_event, (int)windowProc3, (int)22);
                OS.g_signal_connect_after((int)eventHandle, (byte[])OS.button_press_event, (int)windowProc3, (int)-2);
                OS.g_signal_connect_after((int)eventHandle, (byte[])OS.button_release_event, (int)windowProc3, (int)-3);
                OS.g_signal_connect_after((int)eventHandle, (byte[])OS.motion_notify_event, (int)windowProc3, (int)-26);
                if (eventHandle != this.entryHandle) {
                    OS.g_signal_connect((int)eventHandle, (byte[])OS.event_after, (int)windowProc3, (int)13);
                }
            }
            ++i;
        }
        int imContext = this.imContext();
        if (imContext != 0) {
            OS.g_signal_connect((int)imContext, (byte[])OS.commit, (int)windowProc3, (int)6);
            int id = OS.g_signal_lookup((byte[])OS.commit, (int)OS.gtk_im_context_get_type());
            int blockMask = 17;
            OS.g_signal_handlers_block_matched((int)imContext, (int)blockMask, (int)id, (int)0, (int)0, (int)0, (int)this.entryHandle);
        }
    }

    int imContext() {
        return OS.GTK_ENTRY_IM_CONTEXT((int)this.entryHandle);
    }

    public void deselect(int index) {
        this.checkWidget();
        boolean isSelected = this.getSelectionIndex() == index;
        this.setItems(this.items, !isSelected, !isSelected);
    }

    public void deselectAll() {
        this.checkWidget();
        this.setItems(this.items, false, false);
    }

    GdkColor getBackgroundColor() {
        return this.getBaseColor();
    }

    GdkColor getForegroundColor() {
        return this.getTextColor();
    }

    public String getItem(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.items.length) {
            this.error(6);
        }
        return this.items[index];
    }

    public int getItemCount() {
        this.checkWidget();
        return this.items.length;
    }

    public int getItemHeight() {
        this.checkWidget();
        return this.fontHeight(this.getFontDescription(), this.listHandle != 0 ? this.listHandle : this.handle);
    }

    public String[] getItems() {
        this.checkWidget();
        String[] result = new String[this.items.length];
        System.arraycopy(this.items, 0, result, 0, this.items.length);
        return result;
    }

    public int getOrientation() {
        this.checkWidget();
        return this.style & 0x6000000;
    }

    public Point getSelection() {
        this.checkWidget();
        int[] start = new int[1];
        int[] end = new int[1];
        OS.gtk_editable_get_selection_bounds((int)this.entryHandle, (int[])start, (int[])end);
        return new Point(start[0], end[0]);
    }

    public int getSelectionIndex() {
        this.checkWidget();
        return this.indexOf(this.getText());
    }

    public String getText() {
        this.checkWidget();
        int address = OS.gtk_entry_get_text((int)this.entryHandle);
        int length = OS.strlen((int)address);
        byte[] buffer = new byte[length];
        OS.memmove((byte[])buffer, (int)address, (int)length);
        return new String(Converter.mbcsToWcs(null, buffer));
    }

    String getText(int start, int stop) {
        return this.getText().substring(start, stop - 1);
    }

    public int getTextHeight() {
        this.checkWidget();
        return this.fontHeight(this.getFontDescription(), this.entryHandle != 0 ? this.entryHandle : this.handle) + 8;
    }

    public int getTextLimit() {
        this.checkWidget();
        int limit = OS.gtk_entry_get_max_length((int)this.entryHandle);
        return limit == 0 ? LIMIT : limit;
    }

    public int getVisibleItemCount() {
        this.checkWidget();
        return this.visibleCount;
    }

    int gtk_activate(int widget) {
        this.postEvent(14);
        return 0;
    }

    int gtk_changed(int widget) {
        if (!this.ignoreSelect) {
            int ptr = OS.gtk_entry_get_text((int)this.entryHandle);
            int length = OS.strlen((int)ptr);
            byte[] buffer = new byte[length];
            OS.memmove((byte[])buffer, (int)ptr, (int)length);
            String text = new String(Converter.mbcsToWcs(null, buffer));
            int i = 0;
            while (i < this.items.length) {
                if (this.items[i].equals(text)) {
                    this.postEvent(13);
                    break;
                }
                ++i;
            }
        }
        this.sendEvent(24);
        return 0;
    }

    int gtk_commit(int imContext, int text) {
        if (text == 0) {
            return 0;
        }
        if (!OS.gtk_editable_get_editable((int)this.entryHandle)) {
            return 0;
        }
        int length = OS.strlen((int)text);
        if (length == 0) {
            return 0;
        }
        byte[] buffer = new byte[length];
        OS.memmove((byte[])buffer, (int)text, (int)length);
        char[] chars = Converter.mbcsToWcs(null, buffer);
        char[] newChars = this.sendIMKeyEvent(1, null, chars);
        if (newChars == null) {
            return 0;
        }
        OS.g_signal_handlers_block_matched((int)imContext, (int)16, (int)0, (int)0, (int)0, (int)0, (int)6);
        int id = OS.g_signal_lookup((byte[])OS.commit, (int)OS.gtk_im_context_get_type());
        int mask = 17;
        OS.g_signal_handlers_unblock_matched((int)imContext, (int)mask, (int)id, (int)0, (int)0, (int)0, (int)this.entryHandle);
        if (newChars == chars) {
            OS.g_signal_emit_by_name((int)imContext, (byte[])OS.commit, (int)text);
        } else {
            buffer = Converter.wcsToMbcs(null, newChars, true);
            OS.g_signal_emit_by_name((int)imContext, (byte[])OS.commit, (byte[])buffer);
        }
        OS.g_signal_handlers_unblock_matched((int)imContext, (int)16, (int)0, (int)0, (int)0, (int)0, (int)6);
        OS.g_signal_handlers_block_matched((int)imContext, (int)mask, (int)id, (int)0, (int)0, (int)0, (int)this.entryHandle);
        return 0;
    }

    int gtk_key_press_event(int widget, int event) {
        boolean isTab;
        if (widget != this.entryHandle) {
            return super.gtk_key_press_event(widget, event);
        }
        if (!this.hasFocus()) {
            return 0;
        }
        GdkEventKey gdkEvent = new GdkEventKey();
        OS.memmove((GdkEventKey)gdkEvent, (int)event, (int)GdkEventKey.sizeof);
        boolean bl = isTab = gdkEvent.keyval == 65289 || gdkEvent.keyval == 65056;
        if (gdkEvent.time != this.lastEventTime || isTab) {
            this.lastEventTime = gdkEvent.time;
            int imContext = this.imContext();
            if (imContext != 0 && OS.gtk_im_context_filter_keypress((int)imContext, (int)event)) {
                return 1;
            }
        }
        return super.gtk_key_press_event(widget, event);
    }

    int gtk_popup_menu(int widget) {
        int[] x = new int[1];
        int[] y = new int[1];
        OS.gdk_window_get_pointer((int)0, (int[])x, (int[])y, null);
        return this.showMenu(x[0], y[0]) ? 1 : 0;
    }

    public int indexOf(String string) {
        this.checkWidget();
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int start) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (start < 0 || start >= this.items.length) {
            return -1;
        }
        int i = start;
        while (i < this.items.length) {
            if (string.equals(this.items[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void paste() {
        this.checkWidget();
        OS.gtk_editable_paste_clipboard((int)this.entryHandle);
    }

    int parentingHandle() {
        return this.fixedHandle;
    }

    void register() {
        super.register();
        if (this.arrowHandle != 0) {
            this.display.addWidget(this.arrowHandle, this);
        }
        this.display.addWidget(this.entryHandle, this);
        this.display.addWidget(this.listHandle, this);
        int imContext = this.imContext();
        if (imContext != 0) {
            this.display.addWidget(imContext, this);
        }
    }

    void releaseHandle() {
        super.releaseHandle();
        this.listHandle = 0;
        this.entryHandle = 0;
    }

    public void remove(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.items.length) {
            this.error(6);
        }
        String[] oldItems = this.items;
        String[] newItems = new String[oldItems.length - 1];
        System.arraycopy(oldItems, 0, newItems, 0, index);
        System.arraycopy(oldItems, index + 1, newItems, index, oldItems.length - index - 1);
        this.setItems(newItems, true, true);
    }

    public void remove(int start, int end) {
        this.checkWidget();
        if (start > end) {
            return;
        }
        if (start < 0 || start > end || end >= this.items.length) {
            this.error(6);
        }
        String[] oldItems = this.items;
        String[] newItems = new String[oldItems.length - (end - start + 1)];
        System.arraycopy(oldItems, 0, newItems, 0, start);
        System.arraycopy(oldItems, end + 1, newItems, start, oldItems.length - end - 1);
        this.setItems(newItems, true, true);
    }

    public void remove(String string) {
        this.checkWidget();
        int index = this.indexOf(string, 0);
        if (index == -1) {
            this.error(5);
        }
        this.remove(index);
    }

    public void removeAll() {
        this.checkWidget();
        this.setItems(new String[0], false, false);
    }

    public void removeModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void select(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.items.length) {
            return;
        }
        this.setText(this.items[index]);
    }

    void setBackgroundColor(GdkColor color) {
        super.setBackgroundColor(color);
        if (this.entryHandle != 0) {
            OS.gtk_widget_modify_base((int)this.entryHandle, (int)0, (GdkColor)color);
        }
        if (this.listHandle != 0) {
            OS.gtk_widget_modify_base((int)this.listHandle, (int)0, (GdkColor)color);
        }
    }

    boolean setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        int newHeight = resize && (this.style & 4) != 0 ? this.getTextHeight() : height;
        return super.setBounds(x, y, width, newHeight, move, resize);
    }

    void setFontDescription(int font) {
        super.setFontDescription(font);
        if (this.entryHandle != 0) {
            OS.gtk_widget_modify_font((int)this.entryHandle, (int)font);
        }
        if (this.listHandle != 0) {
            OS.gtk_widget_modify_font((int)this.listHandle, (int)font);
            int itemsList = OS.gtk_container_get_children((int)this.listHandle);
            if (itemsList != 0) {
                int count = OS.g_list_length((int)itemsList);
                int i = count - 1;
                while (i >= 0) {
                    int widget = OS.gtk_bin_get_child((int)OS.g_list_nth_data((int)itemsList, (int)i));
                    OS.gtk_widget_modify_font((int)widget, (int)font);
                    --i;
                }
                OS.g_list_free((int)itemsList);
            }
        }
    }

    void setForegroundColor(GdkColor color) {
        super.setForegroundColor(color);
        if (this.entryHandle != 0) {
            OS.gtk_widget_modify_text((int)this.entryHandle, (int)0, (GdkColor)color);
        }
        if (this.listHandle != 0) {
            OS.gtk_widget_modify_text((int)this.listHandle, (int)0, (GdkColor)color);
            int itemsList = OS.gtk_container_get_children((int)this.listHandle);
            if (itemsList != 0) {
                int count = OS.g_list_length((int)itemsList);
                int i = count - 1;
                while (i >= 0) {
                    int widget = OS.gtk_bin_get_child((int)OS.g_list_nth_data((int)itemsList, (int)i));
                    OS.gtk_widget_modify_fg((int)widget, (int)0, (GdkColor)color);
                    --i;
                }
                OS.g_list_free((int)itemsList);
            }
        }
    }

    public void setItem(int index, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (index < 0 || index >= this.items.length) {
            this.error(5);
        }
        this.items[index] = string;
        this.setItems(this.items, true, true);
    }

    public void setItems(String[] items) {
        this.checkWidget();
        if (items == null) {
            this.error(4);
        }
        this.setItems(items, false, false);
    }

    void setItems(String[] items, boolean keepText, boolean keepSelection) {
        this.items = items;
        String text = keepText ? this.getText() : "";
        int selectedIndex = keepSelection ? this.getSelectionIndex() : -1;
        this.ignoreSelect = true;
        if (items.length == 0) {
            int itemsList = OS.gtk_container_get_children((int)this.listHandle);
            if (itemsList != 0) {
                int count = OS.g_list_length((int)itemsList);
                int i = count - 1;
                while (i >= 0) {
                    int widget = OS.g_list_nth_data((int)itemsList, (int)i);
                    OS.gtk_container_remove((int)this.listHandle, (int)widget);
                    --i;
                }
                OS.g_list_free((int)itemsList);
            }
        } else {
            int itemsList;
            int glist = 0;
            int i = 0;
            while (i < items.length) {
                String string = items[i];
                if (string == null) break;
                byte[] buffer = Converter.wcsToMbcs(null, string, true);
                int data = OS.g_malloc((int)buffer.length);
                OS.memmove((int)data, (byte[])buffer, (int)buffer.length);
                glist = OS.g_list_append((int)glist, (int)data);
                ++i;
            }
            OS.gtk_combo_set_popdown_strings((int)this.handle, (int)glist);
            if (glist != 0) {
                int count = OS.g_list_length((int)glist);
                int i2 = 0;
                while (i2 < count) {
                    int data = OS.g_list_nth_data((int)glist, (int)i2);
                    if (data != 0) {
                        OS.g_free((int)data);
                    }
                    ++i2;
                }
                OS.g_list_free((int)glist);
            }
            if ((itemsList = OS.gtk_container_get_children((int)this.listHandle)) != 0) {
                int font = this.getFontDescription();
                GdkColor color = this.getForegroundColor();
                int count = OS.g_list_length((int)itemsList);
                int i3 = count - 1;
                while (i3 >= 0) {
                    int widget = OS.gtk_bin_get_child((int)OS.g_list_nth_data((int)itemsList, (int)i3));
                    OS.gtk_widget_modify_fg((int)widget, (int)0, (GdkColor)color);
                    OS.gtk_widget_modify_font((int)widget, (int)font);
                    --i3;
                }
                OS.g_list_free((int)itemsList);
            }
        }
        OS.gtk_entry_set_text((int)this.entryHandle, (byte[])Converter.wcsToMbcs(null, selectedIndex != -1 ? items[selectedIndex] : text, true));
        this.ignoreSelect = false;
    }

    public void setOrientation(int orientation) {
        this.checkWidget();
    }

    public void setSelection(Point selection) {
        this.checkWidget();
        if (selection == null) {
            this.error(4);
        }
        OS.gtk_editable_set_position((int)this.entryHandle, (int)selection.x);
        OS.gtk_editable_select_region((int)this.entryHandle, (int)selection.x, (int)selection.y);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        byte[] buffer = Converter.wcsToMbcs(null, string, true);
        OS.g_signal_handlers_block_matched((int)this.entryHandle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)4);
        OS.gtk_entry_set_text((int)this.entryHandle, (byte[])buffer);
        OS.g_signal_handlers_unblock_matched((int)this.entryHandle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)4);
        this.sendEvent(24);
    }

    public void setTextLimit(int limit) {
        this.checkWidget();
        if (limit == 0) {
            this.error(7);
        }
        OS.gtk_entry_set_max_length((int)this.entryHandle, (int)limit);
    }

    public void setVisibleItemCount(int count) {
        this.checkWidget();
        if (count < 0) {
            return;
        }
        this.visibleCount = count;
    }

    boolean translateTraversal(GdkEventKey keyEvent) {
        int key = keyEvent.keyval;
        switch (key) {
            case 65293: 
            case 65421: {
                int imContext = this.imContext();
                if (imContext == 0) break;
                int[] preeditString = new int[1];
                OS.gtk_im_context_get_preedit_string((int)imContext, (int[])preeditString, null, null);
                if (preeditString[0] == 0) break;
                int lenght = OS.strlen((int)preeditString[0]);
                OS.g_free((int)preeditString[0]);
                if (lenght == 0) break;
                return false;
            }
        }
        return super.translateTraversal(keyEvent);
    }
}

