/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class ToolBar
extends Composite {
    ToolItem lastFocus;

    public ToolBar(Composite parent, int style) {
        super(parent, ToolBar.checkStyle(style));
        this.style = (style & 0x200) != 0 ? (this.style |= 0x200) : (this.style |= 0x100);
        int orientation = (style & 0x200) != 0 ? 1 : 0;
        OS.gtk_toolbar_set_orientation((int)this.handle, (int)orientation);
    }

    static int checkStyle(int style) {
        if ((style & 0x40) != 0) {
            style &= 0xFFFFFFBF;
        }
        return style & 0xFFFFFCFF;
    }

    void createHandle(int index) {
        this.state |= 8;
        this.fixedHandle = OS.g_object_new((int)this.display.gtk_fixed_get_type(), (int)0);
        if (this.fixedHandle == 0) {
            this.error(2);
        }
        OS.gtk_fixed_set_has_window((int)this.fixedHandle, (boolean)true);
        this.handle = OS.gtk_toolbar_new();
        if (this.handle == 0) {
            this.error(2);
        }
        OS.gtk_container_add((int)this.fixedHandle, (int)this.handle);
        if ((this.style & 0x800000) != 0) {
            byte[] swt_toolbar_flat = Converter.wcsToMbcs(null, "swt-toolbar-flat", true);
            OS.gtk_widget_set_name((int)this.handle, (byte[])swt_toolbar_flat);
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        if (wHint != -1 && wHint < 0) {
            wHint = 0;
        }
        if (hHint != -1 && hHint < 0) {
            hHint = 0;
        }
        if (this.layout != null) {
            super.computeSize(wHint, hHint, changed);
        }
        return this.computeNativeSize(this.handle, wHint, hHint, changed);
    }

    int eventHandle() {
        return this.fixedHandle;
    }

    boolean forceFocus(int focusHandle) {
        if (this.lastFocus != null && this.lastFocus.setFocus()) {
            return true;
        }
        ToolItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            ToolItem item = items[i];
            if (item.setFocus()) {
                return true;
            }
            ++i;
        }
        return super.forceFocus(focusHandle);
    }

    public ToolItem getItem(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.getItemCount()) {
            this.error(6);
        }
        return this.getItems()[index];
    }

    public ToolItem getItem(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        ToolItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getBounds().contains(point)) {
                return items[i];
            }
            ++i;
        }
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        int list = OS.gtk_container_get_children((int)this.handle);
        if (list == 0) {
            return 0;
        }
        int itemCount = OS.g_list_length((int)list);
        OS.g_list_free((int)list);
        return itemCount;
    }

    public ToolItem[] getItems() {
        this.checkWidget();
        int list = OS.gtk_container_get_children((int)this.handle);
        if (list == 0) {
            return new ToolItem[0];
        }
        int count = OS.g_list_length((int)list);
        ToolItem[] result = new ToolItem[count];
        int i = 0;
        while (i < count) {
            int data = OS.g_list_nth_data((int)list, (int)i);
            Widget widget = this.display.getWidget(data);
            result[i] = (ToolItem)widget;
            ++i;
        }
        OS.g_list_free((int)list);
        return result;
    }

    public int getRowCount() {
        this.checkWidget();
        return 1;
    }

    int gtk_key_press_event(int widget, int eventPtr) {
        if (!this.hasFocus()) {
            return 0;
        }
        int result = super.gtk_key_press_event(widget, eventPtr);
        if (result != 0) {
            return result;
        }
        ToolItem[] items = this.getItems();
        int length = items.length;
        int index = 0;
        while (index < length) {
            if (items[index].hasFocus()) break;
            ++index;
        }
        GdkEventKey gdkEvent = new GdkEventKey();
        OS.memmove((GdkEventKey)gdkEvent, (int)eventPtr, (int)GdkEventKey.sizeof);
        boolean next = false;
        switch (gdkEvent.keyval) {
            case 65361: 
            case 65362: {
                next = false;
                break;
            }
            case 65364: {
                if (index >= 0 && index < length) {
                    ToolItem item = items[index];
                    if ((item.style & 4) != 0) {
                        Event event = new Event();
                        event.detail = 4;
                        int topHandle = item.topHandle();
                        event.x = OS.GTK_WIDGET_X((int)topHandle);
                        event.y = OS.GTK_WIDGET_Y((int)topHandle) + OS.GTK_WIDGET_HEIGHT((int)topHandle);
                        item.postEvent(13, event);
                        return result;
                    }
                }
            }
            case 65363: {
                next = true;
                break;
            }
            default: {
                return result;
            }
        }
        int start = index;
        int offset = next ? 1 : -1;
        while ((index = (index + offset + length) % length) != start) {
            ToolItem item = items[index];
            if (!item.setFocus()) continue;
            return result;
        }
        return result;
    }

    boolean hasFocus() {
        ToolItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            ToolItem item = items[i];
            if (item.hasFocus()) {
                return true;
            }
            ++i;
        }
        return super.hasFocus();
    }

    public int indexOf(ToolItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        ToolItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            if (item == items[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    void layoutItems() {
        int parentHandle = this.parentingHandle();
        OS.gtk_container_resize_children((int)parentHandle);
        ToolItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            ToolItem item = items[i];
            if (item != null) {
                item.resizeControl();
            }
            ++i;
        }
    }

    boolean mnemonicHit(char key) {
        ToolItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            int labelHandle = items[i].labelHandle;
            if (labelHandle != 0 && this.mnemonicHit(labelHandle, key)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    boolean mnemonicMatch(char key) {
        ToolItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            int labelHandle = items[i].labelHandle;
            if (labelHandle != 0 && this.mnemonicMatch(labelHandle, key)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    void releaseWidget() {
        ToolItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            ToolItem item = items[i];
            if (!item.isDisposed()) {
                item.releaseResources();
            }
            ++i;
        }
        items = null;
        super.releaseWidget();
    }

    void removeControl(Control control) {
        super.removeControl(control);
        ToolItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            ToolItem item = items[i];
            if (item != null && item.control == control) {
                item.setControl(null);
            }
            ++i;
        }
    }

    boolean setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        boolean changed = super.setBounds(x, y, width, height, move, resize);
        if (changed && resize) {
            this.layoutItems();
        }
        return changed;
    }

    void setFontDescription(int font) {
        super.setFontDescription(font);
        ToolItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i] != null) {
                items[i].setFontDescription(font);
            }
            ++i;
        }
        this.layoutItems();
    }

    void setForegroundColor(GdkColor color) {
        super.setForegroundColor(color);
        ToolItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i] != null) {
                items[i].setForegroundColor(color);
            }
            ++i;
        }
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        super.setToolTipText(string);
        Shell shell = this._getShell();
        ToolItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            shell.setToolTipText(items[i].handle, string != null ? null : items[i].toolTipText);
            ++i;
        }
    }
}

