/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.SubMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.ObjectActionContributorManager;
import org.eclipse.ui.internal.ViewerActionBuilder;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class PopupMenuExtender
implements IMenuListener {
    private static final PopupMenuExtenderManager manager = new PopupMenuExtenderManager();
    private final Set menuIds = new HashSet();
    private final MenuManager menu;
    private SubMenuManager menuWrapper;
    private final ISelectionProvider selProvider;
    private final IWorkbenchPart part;
    private ViewerActionBuilder staticActionBuilder;

    public static final PopupMenuExtenderManager getManager() {
        return manager;
    }

    public PopupMenuExtender(String id, MenuManager menu, ISelectionProvider prov, IWorkbenchPart part) {
        this.menu = menu;
        this.selProvider = prov;
        this.part = part;
        this.menuIds.add(id);
        menu.addMenuListener((IMenuListener)this);
        if (!menu.getRemoveAllWhenShown()) {
            this.menuWrapper = new SubMenuManager((IMenuManager)menu);
            this.menuWrapper.setVisible(true);
        }
        PopupMenuExtender.getManager().addExtender(this);
        this.readStaticActions();
    }

    public Set getMenuIds() {
        return this.menuIds;
    }

    public final void addMenuId(String menuId) {
        this.menuIds.add(menuId);
    }

    public final boolean matches(MenuManager menuManager, ISelectionProvider selectionProvider, IWorkbenchPart part) {
        return this.menu == menuManager && this.selProvider == selectionProvider && this.part == part;
    }

    private void addEditorActions(IMenuManager mgr) {
        ISelectionProvider activeEditor = new ISelectionProvider(){

            public void addSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public ISelection getSelection() {
                if (PopupMenuExtender.this.part instanceof IEditorPart) {
                    IEditorPart editorPart = (IEditorPart)PopupMenuExtender.this.part;
                    return new StructuredSelection(new Object[]{editorPart.getEditorInput()});
                }
                return new StructuredSelection(new Object[0]);
            }

            public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public void setSelection(ISelection selection) {
            }
        };
        if (ObjectActionContributorManager.getManager().contributeObjectActions(this.part, mgr, activeEditor)) {
            mgr.add((IContributionItem)new Separator());
        }
    }

    private void addObjectActions(IMenuManager mgr) {
        if (this.selProvider != null && ObjectActionContributorManager.getManager().contributeObjectActions(this.part, mgr, this.selProvider)) {
            mgr.add((IContributionItem)new Separator());
        }
    }

    private void addStaticActions(IMenuManager mgr) {
        if (this.staticActionBuilder != null) {
            this.staticActionBuilder.contribute(mgr, null, true);
        }
    }

    public void menuAboutToShow(IMenuManager mgr) {
        this.testForAdditions();
        if (this.menuWrapper != null) {
            mgr = this.menuWrapper;
            this.menuWrapper.removeAll();
        }
        this.addEditorActions(mgr);
        this.addObjectActions(mgr);
        this.addStaticActions(mgr);
    }

    private void readStaticActions() {
        if (this.menuIds.isEmpty()) {
            return;
        }
        Iterator menuIdItr = this.menuIds.iterator();
        while (menuIdItr.hasNext()) {
            String menuId = (String)menuIdItr.next();
            if (menuId == null || menuId.length() < 1) continue;
            this.staticActionBuilder = new ViewerActionBuilder();
            if (this.staticActionBuilder.readViewerContributions(menuId, this.selProvider, this.part)) continue;
            this.staticActionBuilder = null;
        }
    }

    private void testForAdditions() {
        IContributionItem item = this.menu.find("additions");
        if (item == null) {
            WorkbenchPlugin.log("Context menu missing standard group 'org.eclipse.ui.IWorkbenchActionConstants.MB_ADDITIONS'. (menu ids = " + this.menuIds.toString() + ")  part id = " + (this.part == null ? "???" : this.part.getSite().getId()) + ")");
        }
    }

    public void dispose() {
        if (this.staticActionBuilder != null) {
            this.staticActionBuilder.dispose();
        }
        PopupMenuExtender.getManager().removeExtender(this);
        this.menu.removeMenuListener((IMenuListener)this);
    }

    public static final class PopupMenuExtenderManager {
        private Set extenders = new HashSet();

        public void clearCaches() {
            Iterator i = this.extenders.iterator();
            while (i.hasNext()) {
                PopupMenuExtender extender = (PopupMenuExtender)i.next();
                extender.readStaticActions();
            }
        }

        private void addExtender(PopupMenuExtender extender) {
            this.extenders.add(extender);
        }

        private void removeExtender(PopupMenuExtender extender) {
            this.extenders.remove(extender);
        }
    }
}

