/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.activities.ws;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.activities.IActivity;
import org.eclipse.ui.activities.ICategory;
import org.eclipse.ui.activities.ICategoryActivityBinding;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.eclipse.ui.activities.NotDefinedException;
import org.eclipse.ui.internal.activities.ws.ActivityCategoryContentProvider;
import org.eclipse.ui.internal.activities.ws.ActivityCategoryLabelProvider;
import org.eclipse.ui.internal.activities.ws.ActivityMessages;
import org.eclipse.ui.internal.activities.ws.CategorizedActivity;

public class ActivityEnabler {
    private static final int ALL = 2;
    private static final int NONE = 0;
    private static final int SOME = 1;
    protected IWorkbenchActivitySupport activitySupport;
    private ISelectionChangedListener selectionListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            Object element = ((IStructuredSelection)event.getSelection()).getFirstElement();
            try {
                if (element instanceof ICategory) {
                    ActivityEnabler.this.descriptionText.setText(((ICategory)element).getDescription());
                } else if (element instanceof IActivity) {
                    ActivityEnabler.this.descriptionText.setText(((IActivity)element).getDescription());
                }
            }
            catch (NotDefinedException notDefinedException) {
                ActivityEnabler.this.descriptionText.setText("");
            }
        }
    };
    private ICheckStateListener checkListener = new ICheckStateListener(){

        public void checkStateChanged(CheckStateChangedEvent event) {
            HashSet<Object> checked = new HashSet<Object>(Arrays.asList(ActivityEnabler.this.dualViewer.getCheckedElements()));
            Object element = event.getElement();
            if (element instanceof ICategory) {
                ActivityEnabler.this.dualViewer.setSubtreeChecked(element, event.getChecked());
                ActivityEnabler.this.dualViewer.setGrayed(element, false);
            } else {
                CategorizedActivity proxy = (CategorizedActivity)element;
                Object[] children = ActivityEnabler.this.provider.getChildren(proxy.getCategory());
                int state = 0;
                int count = 0;
                int i = 0;
                while (i < children.length) {
                    if (checked.contains(children[i])) {
                        ++count;
                    }
                    ++i;
                }
                if (count == children.length) {
                    state = 2;
                } else if (count != 0) {
                    state = 1;
                }
                if (state == 0) {
                    checked.remove(proxy.getCategory());
                } else {
                    checked.add(proxy.getCategory());
                }
                ActivityEnabler.this.dualViewer.setGrayed((Object)proxy.getCategory(), state == 1);
                ActivityEnabler.this.dualViewer.setCheckedElements(checked.toArray());
            }
        }
    };
    protected CheckboxTreeViewer dualViewer;
    private Set managedActivities = new HashSet(7);
    protected ActivityCategoryContentProvider provider = new ActivityCategoryContentProvider();
    protected Text descriptionText;

    public ActivityEnabler(IWorkbenchActivitySupport activitySupport) {
        this.activitySupport = activitySupport;
    }

    public Control createControl(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        mainComposite.setLayout((Layout)gridLayout);
        Composite c = new Composite(mainComposite, 0);
        c.setLayoutData((Object)new GridData(768));
        GridLayout gridLayout2 = new GridLayout(1, true);
        gridLayout2.marginHeight = 0;
        gridLayout2.marginWidth = 0;
        c.setLayout((Layout)gridLayout2);
        Label label = new Label(c, 0);
        label.setText(ActivityMessages.getString("ActivityEnabler.activities"));
        label.setLayoutData((Object)new GridData(768));
        label.setFont(parent.getFont());
        this.dualViewer = new CheckboxTreeViewer(c);
        this.dualViewer.setSorter(new ViewerSorter());
        this.dualViewer.setAutoExpandLevel(-1);
        this.dualViewer.setLabelProvider((IBaseLabelProvider)new ActivityCategoryLabelProvider());
        this.dualViewer.setContentProvider((IContentProvider)this.provider);
        this.dualViewer.setInput((Object)this.activitySupport.getActivityManager());
        GridData data = new GridData(768);
        GC gc = new GC((Drawable)this.dualViewer.getControl());
        gc.setFont(parent.getFont());
        data.heightHint = Math.min(Dialog.convertHeightInCharsToPixels((FontMetrics)gc.getFontMetrics(), (int)18), 200);
        gc.dispose();
        this.dualViewer.getControl().setLayoutData((Object)data);
        this.dualViewer.getControl().setFont(parent.getFont());
        Composite buttonComposite = new Composite(c, 0);
        buttonComposite.setLayoutData((Object)new GridData(128));
        GridLayout gridLayout3 = new GridLayout(2, true);
        gridLayout3.marginHeight = 0;
        gridLayout3.marginWidth = 0;
        buttonComposite.setLayout((Layout)gridLayout3);
        Button selectAllButton = new Button(buttonComposite, 8);
        selectAllButton.setFont(parent.getFont());
        selectAllButton.setText(ActivityMessages.getString("ActivityEnabler.selectAll"));
        selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActivityEnabler.this.toggleTreeEnablement(true);
            }
        });
        selectAllButton.setLayoutData((Object)new GridData(1808));
        Button deselectAllButton = new Button(buttonComposite, 8);
        deselectAllButton.setFont(parent.getFont());
        deselectAllButton.setText(ActivityMessages.getString("ActivityEnabler.deselectAll"));
        deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActivityEnabler.this.toggleTreeEnablement(false);
            }
        });
        deselectAllButton.setLayoutData((Object)new GridData(1808));
        c = new Composite(mainComposite, 0);
        c.setLayoutData((Object)new GridData(1808));
        GridLayout gridLayout4 = new GridLayout(1, true);
        gridLayout4.marginHeight = 0;
        gridLayout4.marginWidth = 0;
        c.setLayout((Layout)gridLayout4);
        label = new Label(c, 0);
        label.setText(ActivityMessages.getString("ActivityEnabler.description"));
        label.setLayoutData((Object)new GridData(768));
        label.setFont(parent.getFont());
        this.descriptionText = new Text(c, 2632);
        this.descriptionText.setFont(parent.getFont());
        this.descriptionText.setLayoutData((Object)new GridData(1810));
        this.setInitialStates();
        this.dualViewer.addCheckStateListener(this.checkListener);
        this.dualViewer.addSelectionChangedListener(this.selectionListener);
        this.dualViewer.setSelection((ISelection)new StructuredSelection());
        return mainComposite;
    }

    private Collection getCategoryActivityIds(String categoryId) {
        ICategory category = this.activitySupport.getActivityManager().getCategory(categoryId);
        Set activityBindings = category.getCategoryActivityBindings();
        ArrayList<String> categoryActivities = new ArrayList<String>(activityBindings.size());
        Iterator i = activityBindings.iterator();
        while (i.hasNext()) {
            ICategoryActivityBinding binding = (ICategoryActivityBinding)i.next();
            String activityId = binding.getActivityId();
            categoryActivities.add(activityId);
        }
        return categoryActivities;
    }

    private void setInitialStates() {
        Set enabledActivities = this.activitySupport.getActivityManager().getEnabledActivityIds();
        this.setEnabledStates(enabledActivities);
    }

    private void setEnabledStates(Set enabledActivities) {
        Set categories = this.activitySupport.getActivityManager().getDefinedCategoryIds();
        ArrayList<Comparable> checked = new ArrayList<Comparable>(10);
        ArrayList<ICategory> grayed = new ArrayList<ICategory>(10);
        Iterator i = categories.iterator();
        while (i.hasNext()) {
            String categoryId = (String)i.next();
            ICategory category = this.activitySupport.getActivityManager().getCategory(categoryId);
            int state = 0;
            Collection activities = this.getCategoryActivityIds(categoryId);
            int foundCount = 0;
            Iterator j = activities.iterator();
            while (j.hasNext()) {
                String activityId = (String)j.next();
                this.managedActivities.add(activityId);
                if (!enabledActivities.contains(activityId)) continue;
                IActivity activity = this.activitySupport.getActivityManager().getActivity(activityId);
                checked.add(new CategorizedActivity(category, activity));
                ++foundCount;
            }
            if (foundCount == activities.size()) {
                state = 2;
            } else if (foundCount > 0) {
                state = 1;
            }
            if (state == 0) continue;
            checked.add(category);
            if (state != 1) continue;
            grayed.add(category);
        }
        this.dualViewer.setCheckedElements(checked.toArray());
        this.dualViewer.setGrayedElements(grayed.toArray());
    }

    public void updateActivityStates() {
        HashSet<String> enabledActivities = new HashSet<String>(this.activitySupport.getActivityManager().getEnabledActivityIds());
        enabledActivities.removeAll(this.managedActivities);
        Object[] checked = this.dualViewer.getCheckedElements();
        int i = 0;
        while (i < checked.length) {
            Object element = checked[i];
            if (!(element instanceof ICategory) && !this.dualViewer.getGrayed(element)) {
                enabledActivities.add(((IActivity)element).getId());
            }
            ++i;
        }
        this.activitySupport.setEnabledActivityIds(enabledActivities);
    }

    public void restoreDefaults() {
        HashSet<String> defaultEnabled = new HashSet<String>();
        IConfigurationElement[] configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.ui.activities");
        int i = 0;
        while (i < configurationElements.length) {
            String id;
            if (configurationElements[i].getName().equals("defaultEnablement") && (id = configurationElements[i].getAttribute("id")) != null) {
                defaultEnabled.add(id);
            }
            ++i;
        }
        this.setEnabledStates(defaultEnabled);
    }

    protected void toggleTreeEnablement(boolean enabled) {
        Object[] elements = this.provider.getElements(this.activitySupport.getActivityManager());
        int i = 0;
        while (i < elements.length) {
            this.dualViewer.expandToLevel(elements[i], -1);
            this.dualViewer.setSubtreeChecked(elements[i], enabled);
            ++i;
        }
    }
}

