/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.presentations.newapi;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.internal.presentations.newapi.AbstractTabFolderListener;
import org.eclipse.ui.internal.presentations.newapi.AbstractTabItem;

public abstract class AbstractTabFolder {
    private List listeners = new ArrayList(1);
    private Control toolbar;

    public abstract Point computeMinimumSize();

    public abstract AbstractTabItem add(int var1);

    public abstract Rectangle getClientArea();

    public abstract Control getControl();

    public abstract AbstractTabItem getItem(Point var1);

    public abstract AbstractTabItem[] getItems();

    public abstract void layout(boolean var1);

    public abstract void setSelection(AbstractTabItem var1);

    public abstract void setTabPosition(int var1);

    public abstract void setActive(int var1);

    public abstract int getTabPosition();

    public abstract Point getPaneMenuLocation();

    public AbstractTabItem getItem(int idx) {
        return this.getItems()[idx];
    }

    public int indexOf(AbstractTabItem item) {
        AbstractTabItem[] items = this.getItems();
        int idx = 0;
        while (idx < items.length) {
            AbstractTabItem next = items[idx];
            if (next == item) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    public int getItemCount() {
        return this.getItems().length;
    }

    public void allowMaximizeButton(boolean isVisible) {
    }

    public Control[] getTabList() {
        if (this.toolbar != null) {
            return new Control[]{this.getControl(), this.toolbar};
        }
        return new Control[]{this.getControl()};
    }

    public void setToolbar(Control toolbarControl) {
        this.toolbar = toolbarControl;
    }

    public final Control getToolbar() {
        return this.toolbar;
    }

    public void allowMinimizeButton(boolean isVisible) {
    }

    public void setState(int state) {
    }

    public abstract Rectangle getTabArea();

    public void disposed() {
    }

    public void shellActive(boolean isActive) {
    }

    public final void addListener(AbstractTabFolderListener newListener) {
        this.listeners.add(newListener);
    }

    public final void removeListener(AbstractTabFolderListener toRemove) {
        this.listeners.remove(toRemove);
    }

    protected final void fireStateButtonPressed(int buttonId) {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            AbstractTabFolderListener next = (AbstractTabFolderListener)iter.next();
            next.stateButtonPressed(buttonId);
        }
    }

    protected final void fireDragStart(AbstractTabItem tab, Point displayLoc) {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            AbstractTabFolderListener next = (AbstractTabFolderListener)iter.next();
            next.dragStart(tab, displayLoc);
        }
    }

    protected final void fireCloseButtonPressed(AbstractTabItem item) {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            AbstractTabFolderListener next = (AbstractTabFolderListener)iter.next();
            next.closeButtonPressed(item);
        }
    }

    protected final void showList() {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            AbstractTabFolderListener next = (AbstractTabFolderListener)iter.next();
            next.showList();
        }
    }
}

