/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on 01-Jul-2004
 */
package kenya.builtIns;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

import kenya.types.KBasicType;
import kenya.types.KType;

import org.wellquite.kenya.stackMachine.types.interfaces.IInterpretedMethod;

/**
 * Takes the IBuiltInMethod interface and adds setters for every getter. Thus
 * aiding the way in which built in method classes construct the methods they
 * support.
 * 
 * @author Matthew Sackman (ms02)
 * @edited by Tristan Allwood (toa02)
 * @version 1
 */
public class BuiltInMethod implements IBuiltInMethod {

    protected static final String[] emptyString = { "" };

    public synchronized boolean equals(Object obj) {
        if (obj instanceof BuiltInMethod) {
            BuiltInMethod abimobj = (BuiltInMethod) obj;

            return getName().equals(abimobj.getName())
                    && getMethodParameters().equals(
                            abimobj.getMethodParameters());
        } else {
            return false;
        }
    }

    private String name = "";

    public synchronized String getName() {
        return name;
    }

    public synchronized void setName(String n) {
        name = n;
    }

    private KType returnType = KBasicType.getVoid();

    public synchronized KType getReturnType() {
        return returnType;
    }

    public synchronized void hasReturnType(KType rt) {
        returnType = rt;
    }

    private List parameters = new LinkedList();

    public synchronized List getMethodParameters() {
        return Collections.unmodifiableList(parameters);
    }

    public synchronized void setMethodParameters(List params) {
        parameters.clear();
        parameters.addAll(params);
    }

    private IGetMethodCode methodCode = null;

    public synchronized String[] getCode(List parameters) {
        if (methodCode == null) {
            return emptyString;
        } else {
            return methodCode.getCode(parameters, getMethodParameters());
        }
    }

    public synchronized void setCodeHook(IGetMethodCode mC) {
        methodCode = mC;
    }

    private Set reservedClasses = new HashSet();

    public synchronized Set getReservedClasses() {
        return Collections.unmodifiableSet(reservedClasses);
    }

    public synchronized void setReservedClasses(Set i) {
        reservedClasses.clear();
        reservedClasses.addAll(i);
    }

    private Set imports = new HashSet();

    public synchronized Set getImports() {
        return Collections.unmodifiableSet(imports);
    }

    public synchronized void setImports(Set i) {
        imports.clear();
        imports.addAll(i);
    }

    public String toString() {
        return getName();
    }

    private static final Map emptyMap = Collections
            .unmodifiableMap(new HashMap());

    private Map templateParameters = emptyMap;

    public synchronized Map getTemplateParameters() {
        return templateParameters;
    }

    public synchronized void setTemplateParameters(Map tp) {
        if (templateParameters == emptyMap) {
            templateParameters = new HashMap();
        } else {
            templateParameters.clear();
        }
        templateParameters.putAll(tp);
    }

    private IInterpretedMethod smMethod = null;

    public synchronized IInterpretedMethod getInterpretedMethod() {
        return smMethod;
    }

    public synchronized void setInterpretedMethod(IInterpretedMethod method) {
        smMethod = method;
    }

    public static String[] concatenate(String[] lhs, String[] middle,
            String[] rhs) {
        String[] res = new String[lhs.length + middle.length + rhs.length];
        System.arraycopy(lhs, 0, res, 0, lhs.length);
        System.arraycopy(middle, 0, res, lhs.length, middle.length);
        System.arraycopy(rhs, 0, res, lhs.length + middle.length, rhs.length);
        return res;
    }

}