/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on 01-Jul-2004
 *
 */
package kenya.builtIns;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;

/**
 * @author ms02
 *  
 */
public class BuiltInMethodsLoader {

    private static Set builtInMethods = null;

    private static final String builtInMethodsPackage = BuiltInMethodsLoader.class
            .getPackage().getName()
            + ".builtInMethods";

    private static String builtInMethodsLocation;

    private static final String methodListFileName = "builtInMethodList";

    public static Set getBuiltInMethods() {
        if (builtInMethods == null) builtInMethods = loadBuiltInMethods();
        return builtInMethods;
    }

    private static synchronized Set loadBuiltInMethods() {
        findMethodsLocation();
        String listLocation = builtInMethodsLocation + methodListFileName;

        URL listUrl = BuiltInMethodsLoader.class.getClassLoader().getResource(
                listLocation);

        Set builtInMethods = new HashSet();
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(
                    listUrl.openStream()));
            while (in.ready()) {
                String line = in.readLine();
                if (!isComment(line)) {
                    IBuiltInMethodFactory bim = loadBuiltInMethod(line);
                    if (bim != null) {
                        builtInMethods.addAll(bim.buildMethods());
                    }
                }
            }
        } catch (FileNotFoundException e) {
            System.err.println("File not found :" + listUrl.getFile() + ": "
                    + e.getMessage());
            e.printStackTrace();
            return builtInMethods;
        } catch (IOException e) {
            System.err.println("IOException when reading " + listUrl.getFile()
                    + ": " + e.getMessage());
            e.printStackTrace();
            return builtInMethods;
        }
        return builtInMethods;
    }

    private static IBuiltInMethodFactory loadBuiltInMethod(String name) {
        try {
            Class loadedClass = Class.forName(builtInMethodsPackage + "."
                    + name, true, BuiltInMethodsLoader.class.getClassLoader());
            Class[] interfaces = loadedClass.getInterfaces();

            boolean found = false;

            for (int idx = 0; idx < interfaces.length && !found; idx++)
                if (interfaces[idx].getName().equals(
                        IBuiltInMethodFactory.LOCATION)) found = true;

            if (!found) return null;

            IBuiltInMethodFactory m = (IBuiltInMethodFactory) loadedClass
                    .newInstance();

            return m;

        } catch (Exception e) {
            System.err.println("Unable to load class '" + name + "': "
                    + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    private static void findMethodsLocation() {
        String packageName = BuiltInMethodsLoader.class.getPackage().getName();
        packageName = packageName.replace('.', '/');

        if (!packageName.endsWith("/")) packageName += "/";

        builtInMethodsLocation = packageName + "builtInMethods/";
    }

    private static boolean isComment(String line) {
        return line.startsWith("#") || line.length() == 0;
    }

    public static void main(String[] args) {
        Set methods = getBuiltInMethods();
        System.out.println("I got " + methods.size() + " methods.");
    }
}