/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on 01-Jul-2004
 *
 */
package kenya.builtIns;

import java.util.List;
import java.util.Map;
import java.util.Set;

import org.wellquite.kenya.stackMachine.types.interfaces.IInterpretedMethod;

import kenya.types.KType;


/**
 * This interface is implemented by every single built in method.
 * 
 * @author Matthew Sackman (ms02)
 * @version 1-and-a-bit
 */
public interface IBuiltInMethod {

    /**
     * The name of the method.
     * 
     * @return The name of the method.
     */
    String getName();

    /**
     * A KType indicating the return type of the method.
     * 
     * @return The return type of the method.
     */
    KType getReturnType();

    /**
     * Gets a List of KType instances, each one of which is a parameter for the
     * method.
     * 
     * @return A List of KTypes representing the types of the Method.
     */
    List getMethodParameters();

    /**
     * Gets a Map of String to KParamType. The Strings are the names of the
     * template types.
     * 
     * @return A Mapping of String to KParamType for this method.
     */
    Map getTemplateParameters();

    /**
     * Gets a Set of String objects each one being a package that must be
     * imported in the translated Kenya-to-Java code for this method.
     * 
     * @return The Set of imports required by this method.
     */
    Set getImports();

    /**
     * Gets a Set of String objects each one being the class names that
     * this method uses as "reserved" classes that can't be overriden in
     * the code
     * @return
     */
    Set getReservedClasses();
    
    /**
     * Gets the Java code representing the semantics of this method.
     * 
     * @param parameterNames
     *            A List of String objects, each object being the name of a
     *            parameter to the method.
     * @return A String[] containing the Java code required to achieve the
     *          semantics of the method, each memeber of the array is a token that
     * 			cannot be broken across lines, and the code is not allowed to include
     * 			newlines in it.
     */
    String[] getCode(List parameterNames);
    
    IInterpretedMethod getInterpretedMethod();
}