/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on 01-Jul-2004
 *
 */
package kenya.builtIns.builtInMethods;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

import kenya.builtIns.BuiltInMethod;
import kenya.builtIns.IBuiltInMethodFactory;
import kenya.builtIns.IGetMethodCode;
import kenya.builtIns.SMLibraryContainer;
import kenya.types.KBasicType;
import kenya.types.KParamType;
import kenya.types.KType;

import org.wellquite.kenya.stackMachine.InterpretedMethod;
import org.wellquite.kenya.stackMachine.StackMachine;
import org.wellquite.kenya.stackMachine.types.AbstractAtomicClosure;
import org.wellquite.kenya.stackMachine.types.interfaces.IInterpretedMethod;

/**
 * @author ms02
 *  
 */
public class Print implements IBuiltInMethodFactory {

    private static final Set emptySet = Collections
            .unmodifiableSet(new HashSet());

    private static final String name = "print";

    private static final KType returnType = KBasicType.getVoid();

    private static List availableParamTypes = new LinkedList();
    
    public static final Set reservedClasses = new HashSet();

    static {
        
        reservedClasses.add("System");
        
        /*
        List pt0 = new LinkedList();
        availableParamTypes.add(pt0);
        Print must take argumetns!
        */

        List pt1 = new LinkedList();
        pt1.add(KBasicType.getString());
        availableParamTypes.add(pt1);

        List pt2 = new LinkedList();
        pt2.add(KBasicType.getBoolean());
        availableParamTypes.add(pt2);

        List pt3 = new LinkedList();
        pt3.add(KBasicType.getChar());
        availableParamTypes.add(pt3);

        List pt4 = new LinkedList();
        pt4.add(KBasicType.getDouble());
        availableParamTypes.add(pt4);

        List pt5 = new LinkedList();
        pt5.add(KBasicType.getInt());
        availableParamTypes.add(pt5);
        
        //>>>toa02 println can take anything
        List pt6 = new LinkedList();
        pt6.add(new KParamType("T"));
        availableParamTypes.add(pt6);
        //<<<toa02

    }

    public String getName() {
        return name;
    }

    private static final AbstractAtomicClosure execute = new AbstractAtomicClosure() {

        public void execute(StackMachine sm) {
            String value = sm.pop().valueToString();
            sm.print(value);
        }
        
        public String toString() {
            return name;
        }
    };

    private static final IGetMethodCode javaCode = new IGetMethodCode() {

        public String[] getCode(List parameterValues, List parameterTypes) {
            if (parameterValues.size() != parameterTypes.size())
                    throw new RuntimeException("I was expecting "
                            + parameterTypes.size()
                            + " parameters and received "
                            + parameterValues.size() + " parameters");

            /* Print must take arguments
            if( parameterValues.size() == 0 ){
                return new String[] { "System.", "out.", "print()" };
            }
            */
            
            // >>> toa02: as with println, because of types we don't need to
            String[] param = (String[]) parameterValues.get(0);
            if( param == null ){ 
                throw new NullPointerException("param can't be null"); 
            }
            // <<<
            
            String[] lhs = new String[] { "System.","out.", "print(", " " };
            String[] middle = (String[]) parameterValues.get(0);
            String[] rhs = new String[] { " ", ")" };

            return BuiltInMethod.concatenate(lhs, middle, rhs);
            
            //return "System.out.print(" + param + ")";

       }
    };

    public Set buildMethods() {
        Set methods = new HashSet();

        SMLibraryContainer smLibrary = SMLibraryContainer.getLibrary();
        IInterpretedMethod method = new InterpretedMethod(getName(), smLibrary
                .getLibraryClass(), true, false);
        method.setMethodBody(execute);
        smLibrary.addStaticMethod(method);

        for (int idx = 0; idx < availableParamTypes.size(); idx++) {
            BuiltInMethod bim = new BuiltInMethod();
            bim.setName(name);
            bim.hasReturnType(returnType);
            bim.setMethodParameters((List) availableParamTypes.get(idx));
            bim.setImports(emptySet);
            bim.setCodeHook(javaCode);
            bim.setReservedClasses(reservedClasses);
            bim.setInterpretedMethod(method);
            methods.add(bim);
        }
        return methods;
    }

    public String toString() {
        return name;
    }
}