/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on 16-Jul-2004 by toa02
 *
 */
package kenya.builtIns.builtInMethods;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

import kenya.builtIns.BuiltInMethod;
import kenya.builtIns.IBuiltInMethodFactory;
import kenya.builtIns.IGetMethodCode;
import kenya.builtIns.SMIOContainer;
import kenya.builtIns.SMLibraryContainer;
import kenya.nio.IKenyaNIO;
import kenya.types.KBasicType;

import org.wellquite.kenya.stackMachine.InterpretedMethod;
import org.wellquite.kenya.stackMachine.StackMachine;
import org.wellquite.kenya.stackMachine.types.AbstractAtomicClosure;
import org.wellquite.kenya.stackMachine.types.PrimitiveTypeFactory;
import org.wellquite.kenya.stackMachine.types.StringTypeFactory;
import org.wellquite.kenya.stackMachine.types.interfaces.IInterpretedMethod;

/**
 * @author toa02
 *  
 */
public class Readers implements IBuiltInMethodFactory {

    private static final Set importSet = new HashSet();

    private static final List emptyList = Collections
            .unmodifiableList(new LinkedList());

    private static final Set reservedClasses = new HashSet();

    private static final AbstractAtomicClosure readIntC = new AbstractAtomicClosure() {

        public void execute(StackMachine sm) {
            IKenyaNIO io = SMIOContainer.getIKenyaNIO(sm);
            io.setPrintStream(sm.getOut());
            sm.push(PrimitiveTypeFactory.createPrimitiveType(io.readInt()));
        }
    };

    private static final AbstractAtomicClosure readDoubleC = new AbstractAtomicClosure() {

        public void execute(StackMachine sm) {
            IKenyaNIO io = SMIOContainer.getIKenyaNIO(sm);
            io.setPrintStream(sm.getOut());
            sm.push(PrimitiveTypeFactory.createPrimitiveType(io.readDouble()));
        }
    };

    private static final AbstractAtomicClosure failedLastReadC = new AbstractAtomicClosure() {

        public void execute(StackMachine sm) {
            IKenyaNIO io = SMIOContainer.getIKenyaNIO(sm);
            io.setPrintStream(sm.getOut());
            sm.push(PrimitiveTypeFactory.createPrimitiveType(io
                    .failedLastRead()));
        }
    };

    private static final AbstractAtomicClosure readCharC = new AbstractAtomicClosure() {

        public void execute(StackMachine sm) {
            IKenyaNIO io = SMIOContainer.getIKenyaNIO(sm);
            io.setPrintStream(sm.getOut());
            sm.push(PrimitiveTypeFactory.createPrimitiveType(io.readChar()));
        }
    };

    private static final AbstractAtomicClosure readC = new AbstractAtomicClosure() {

        public void execute(StackMachine sm) {
            IKenyaNIO io = SMIOContainer.getIKenyaNIO(sm);
            io.setPrintStream(sm.getOut());
            sm.push(PrimitiveTypeFactory.createPrimitiveType(io.read()));
        }
    };

    private static final AbstractAtomicClosure readStringC = new AbstractAtomicClosure() {

        public void execute(StackMachine sm) {
            IKenyaNIO io = SMIOContainer.getIKenyaNIO(sm);
            io.setPrintStream(sm.getOut());
            sm.push(StringTypeFactory.createStringType(io.readString()));
        }
    };

    private static final AbstractAtomicClosure isEOFC = new AbstractAtomicClosure() {

        public void execute(StackMachine sm) {
            IKenyaNIO io = SMIOContainer.getIKenyaNIO(sm);
            io.setPrintStream(sm.getOut());
            sm.push(PrimitiveTypeFactory.createPrimitiveType(io.isEOF()));
        }
    };

    static {
        reservedClasses.add("KenyaNIO");
        importSet.add("kenya.nio.KenyaNIO");
    }

    /**
     * @see kenya.builtIns.IBuiltInMethodFactory#getName()
     */
    public String getName() {
        return "Readers";
    }

    /**
     * @see kenya.builtIns.IBuiltInMethodFactory#buildMethods()
     */
    public Set buildMethods() {
        HashSet hs = new HashSet();

        SMLibraryContainer smLibrary = SMLibraryContainer.getLibrary();

        IInterpretedMethod methodReadInt = new InterpretedMethod("readInt",
                smLibrary.getLibraryClass(), true, true);
        methodReadInt.setMethodBody(readIntC);
        smLibrary.addStaticMethod(methodReadInt);

        BuiltInMethod readInt = new BuiltInMethod();
        readInt.setImports(importSet);
        readInt.setName("readInt");
        readInt.setMethodParameters(emptyList);
        readInt.hasReturnType(KBasicType.getInt());
        readInt.setCodeHook(new QuickCodeHook("readInt"));
        readInt.setReservedClasses(reservedClasses);
        readInt.setInterpretedMethod(methodReadInt);
        hs.add(readInt);

        IInterpretedMethod methodFailedLastRead = new InterpretedMethod(
                "failedLastRead", smLibrary.getLibraryClass(), true, true);
        methodFailedLastRead.setMethodBody(failedLastReadC);
        smLibrary.addStaticMethod(methodFailedLastRead);

        BuiltInMethod failedLastRead = new BuiltInMethod();
        failedLastRead.setImports(importSet);
        failedLastRead.setName("failedLastRead");
        failedLastRead.setMethodParameters(emptyList);
        failedLastRead.hasReturnType(KBasicType.getBoolean());
        failedLastRead.setCodeHook(new QuickCodeHook("failedLastRead"));
        failedLastRead.setReservedClasses(reservedClasses);
        failedLastRead.setInterpretedMethod(methodFailedLastRead);
        hs.add(failedLastRead);

        IInterpretedMethod methodReadDouble = new InterpretedMethod(
                "readDouble", smLibrary.getLibraryClass(), true, true);
        methodReadDouble.setMethodBody(readDoubleC);
        smLibrary.addStaticMethod(methodReadDouble);

        BuiltInMethod readDouble = new BuiltInMethod();
        readDouble.setImports(importSet);
        readDouble.setName("readDouble");
        readDouble.setMethodParameters(emptyList);
        readDouble.hasReturnType(KBasicType.getDouble());
        readDouble.setCodeHook(new QuickCodeHook("readDouble"));
        readDouble.setReservedClasses(reservedClasses);
        readDouble.setInterpretedMethod(methodReadDouble);
        hs.add(readDouble);

        IInterpretedMethod methodReadChar = new InterpretedMethod("readChar",
                smLibrary.getLibraryClass(), true, true);
        methodReadChar.setMethodBody(readCharC);
        smLibrary.addStaticMethod(methodReadChar);

        BuiltInMethod readChar = new BuiltInMethod();
        readChar.setImports(importSet);
        readChar.setName("readChar");
        readChar.setMethodParameters(emptyList);
        readChar.hasReturnType(KBasicType.getChar());
        readChar.setCodeHook(new QuickCodeHook("readChar"));
        readChar.setReservedClasses(reservedClasses);
        readChar.setInterpretedMethod(methodReadChar);
        hs.add(readChar);

        IInterpretedMethod methodReadString = new InterpretedMethod(
                "readString", smLibrary.getLibraryClass(), true, true);
        methodReadString.setMethodBody(readStringC);
        smLibrary.addStaticMethod(methodReadString);

        BuiltInMethod readString = new BuiltInMethod();
        readString.setImports(importSet);
        readString.setName("readString");
        readString.setMethodParameters(emptyList);
        readString.hasReturnType(KBasicType.getString());
        readString.setCodeHook(new QuickCodeHook("readString"));
        readString.setReservedClasses(reservedClasses);
        readString.setInterpretedMethod(methodReadString);
        hs.add(readString);

        IInterpretedMethod methodRead = new InterpretedMethod("read", smLibrary
                .getLibraryClass(), true, true);
        methodRead.setMethodBody(readC);
        smLibrary.addStaticMethod(methodRead);

        BuiltInMethod read = new BuiltInMethod();
        read.setImports(importSet);
        read.setName("read");
        read.setMethodParameters(emptyList);
        read.hasReturnType(KBasicType.getChar());
        read.setCodeHook(new QuickCodeHook("read"));
        read.setReservedClasses(reservedClasses);
        read.setInterpretedMethod(methodRead);
        hs.add(read);

        IInterpretedMethod methodIsEOF = new InterpretedMethod("isEOF",
                smLibrary.getLibraryClass(), true, true);
        methodIsEOF.setMethodBody(isEOFC);
        smLibrary.addStaticMethod(methodIsEOF);

        BuiltInMethod isEOF = new BuiltInMethod();
        isEOF.setImports(importSet);
        isEOF.setName("isEOF");
        isEOF.setMethodParameters(emptyList);
        isEOF.hasReturnType(KBasicType.getBoolean());
        isEOF.setCodeHook(new QuickCodeHook("isEOF"));
        isEOF.setReservedClasses(reservedClasses);
        isEOF.setInterpretedMethod(methodIsEOF);
        hs.add(isEOF);

        return hs;
    }

}

class QuickCodeHook implements IGetMethodCode {

    private final String _name;

    public QuickCodeHook(String methodName) {
        _name = methodName;
    }

    /**
     * @see kenya.builtIns.IGetMethodCode#getCode(java.util.List,
     *      java.util.List)
     */
    public String[] getCode(List parameterNames, List parameterTypes) {
        return new String[] { "KenyaNIO.", "get().", _name, "()" };
    }

}