/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on 02-Jul-2004
 */
package kenya.builtIns.builtInMethods;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

import kenya.builtIns.BuiltInMethod;
import kenya.builtIns.IBuiltInMethodFactory;
import kenya.builtIns.IGetMethodCode;
import kenya.builtIns.SMLibraryContainer;
import kenya.types.KBasicType;
import kenya.types.KType;

import org.wellquite.kenya.stackMachine.InterpretedMethod;
import org.wellquite.kenya.stackMachine.StackMachine;
import org.wellquite.kenya.stackMachine.types.AbstractAtomicClosure;
import org.wellquite.kenya.stackMachine.types.PrimitiveTypeFactory;
import org.wellquite.kenya.stackMachine.types.interfaces.IInterpretedMethod;
import org.wellquite.kenya.stackMachine.types.interfaces.INumericType;

/**
 * @author Matthew Sackman (ms02)
 * @version 1
 */
public class Sin implements IBuiltInMethodFactory {

    private static final Set emptySet = Collections
            .unmodifiableSet(new HashSet());

    private static final String name = "sin";

    private static final List parameters = new LinkedList();

    private static final KType returnType = KBasicType.getDouble();

    public static final Set reservedClasses = new HashSet();

    static {
        parameters.add(KBasicType.getDouble());
        reservedClasses.add("Math");
    }

    public String getName() {
        return name;
    }

    private static final IGetMethodCode javaCode = new IGetMethodCode() {
        public String[] getCode(List parameterValues, List parameterTypes) {
            if (parameterValues.size() != parameterTypes.size())
                throw new RuntimeException("I was expecting "
                        + parameterTypes.size() + " parameters and received "
                        + parameterValues.size() + " parameters");

            String[] lhs = new String[] { "Math.", "sin(", " " };
            String[] middle = (String[]) parameterValues.get(0);
            String[] rhs = new String[] { " ", ")" };

            return BuiltInMethod.concatenate(lhs, middle, rhs);

            //return "Math.sin(" + parameterValues.get(0) + ")";
        }
    };

    private static final AbstractAtomicClosure execute = new AbstractAtomicClosure() {
        public void execute(StackMachine sm) {
            double arg = ((INumericType) sm.pop()).getValue().doubleValue();
            sm.push(PrimitiveTypeFactory.createPrimitiveType(Math.sin(arg)));
        }

        public String toString() {
            return name;
        }
    };

    public Set buildMethods() {
        Set methods = new HashSet();

        SMLibraryContainer smLibrary = SMLibraryContainer.getLibrary();
        IInterpretedMethod method = new InterpretedMethod(getName(), smLibrary
                .getLibraryClass(), true, true);
        method.setMethodBody(execute);
        smLibrary.addStaticMethod(method);

        BuiltInMethod bim = new BuiltInMethod();
        bim.setCodeHook(javaCode);
        bim.setImports(emptySet);
        bim.setName(getName());
        bim.setMethodParameters(parameters);
        bim.hasReturnType(returnType);
        bim.setReservedClasses(reservedClasses);
        bim.setInterpretedMethod(method);

        methods.add(bim);

        return methods;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    public String toString() {
        return getName();
    }
}