/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on Sep 7, 2004
 *
 */
package kenya.interpreter.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.wellquite.kenya.stackMachine.StackMachine;
import org.wellquite.kenya.stackMachine.scope.IMethodScope;
import org.wellquite.kenya.stackMachine.types.interfaces.IArrayType;
import org.wellquite.kenya.stackMachine.types.interfaces.IClassInstanceType;
import org.wellquite.kenya.stackMachine.types.interfaces.IClassStaticType;
import org.wellquite.kenya.stackMachine.types.interfaces.IEnumType;
import org.wellquite.kenya.stackMachine.types.interfaces.IGenericType;
import org.wellquite.kenya.stackMachine.types.interfaces.IInterpretedClass;
import org.wellquite.kenya.stackMachine.types.interfaces.IInterpretedClassInstance;
import org.wellquite.kenya.stackMachine.types.interfaces.INonPrimitiveType;
import org.wellquite.kenya.stackMachine.types.interfaces.INullType;
import org.wellquite.kenya.stackMachine.types.interfaces.IPrimitiveType;
import org.wellquite.kenya.stackMachine.types.interfaces.IStringType;
import org.wellquite.kenya.stackMachine.types.interfaces.IType;

/**
 * @author matthew
 *  
 */
public class InterpreterInspectorContentProvider implements
        ITreeContentProvider {

    private static final Object[] EMPTY_ARRAY = new Object[] {};

    private final Map parentMap = new HashMap();

    public synchronized Object[] getChildren(Object parentElement) {
        if (parentElement == null)
            return null;
        List children = new ArrayList();
        if (parentElement instanceof IMethodScope) {
            IMethodScope currentMethod = (IMethodScope) parentElement;

            IInterpretedClass classStatic = currentMethod.getCurrentClass();
            if (classStatic != null) {
                children.addAll(classStatic.getImmutableStaticVariables()
                        .entrySet());
                children.addAll(classStatic.getMutableStaticVariables()
                        .entrySet());
            }

            if (!currentMethod.isStatic()) {
                IInterpretedClassInstance classInstance = currentMethod
                        .getCurrentClassInstance();
                if (classInstance != null) {
                    children.addAll(classInstance
                            .getImmutableInstanceVariables().entrySet());
                    children.addAll(classInstance.getMutableInstanceVariables()
                            .entrySet());
                }
            }

            children.addAll(currentMethod.getLocalImmutableVariables()
                    .entrySet());
            children
                    .addAll(currentMethod.getLocalMutableVariables().entrySet());

        } else if (parentElement instanceof Map.Entry) {
            IType value = (IType) ((Map.Entry) parentElement).getValue();
            if (value instanceof IArrayType) {
                IType[] array = ((IArrayType) value).getValue();
                Map indexMap = new HashMap();
                Map valueMap = new HashMap();
                for (int idx = 0; idx < array.length; idx++) {
                    String index = "[" + idx + "]";
                    indexMap.put(index, new Integer(idx));
                    valueMap.put(index, array[idx]);
                    children.add(idx, array[idx]); // ensure children's size
                }
                Iterator keyIt = valueMap.entrySet().iterator();
                while (keyIt.hasNext()) {
                    Map.Entry entry = (Map.Entry) keyIt.next();
                    int position = ((Integer) indexMap.get(entry.getKey()))
                            .intValue();
                    children.set(position, entry);
                }
                indexMap.clear();
                valueMap.clear();

            } else if (value instanceof IClassInstanceType) {
                IInterpretedClassInstance classInstance = ((IClassInstanceType) value)
                        .getValue();
                children.addAll(classInstance.getInterpretedClass()
                        .getImmutableStaticVariables().entrySet());
                children.addAll(classInstance.getInterpretedClass()
                        .getMutableStaticVariables().entrySet());

                children.addAll(classInstance.getImmutableInstanceVariables()
                        .entrySet());
                children.addAll(classInstance.getMutableInstanceVariables()
                        .entrySet());

            } else if (value instanceof IClassStaticType) {
                IInterpretedClass classStatic = ((IClassStaticType) value)
                        .getValue();
                children.addAll(classStatic.getImmutableStaticVariables()
                        .entrySet());
                children.addAll(classStatic.getMutableStaticVariables()
                        .entrySet());

            } else {
                System.err.println("Unknown Map.Entry type for getChildren: "
                        + parentElement);
            }
        } else {
            System.err
                    .println("Unknown type for getChildren: " + parentElement);
        }
        Object[] childrenArray = children.toArray();
        for (int idx = 0; idx < childrenArray.length; idx++) {
            parentMap.put(childrenArray[idx], parentElement);
        }
        return childrenArray;
    }

    public synchronized Object getParent(Object element) {
        if (element == null)
            return null;
        return parentMap.get(element);
    }

    public boolean hasChildren(Object element) {
        if (element == null)
            return false;
        if (element instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry) element;
            if (entry.getValue() instanceof IPrimitiveType) {
                if (entry.getValue() instanceof IArrayType)
                    if (((IArrayType) entry.getValue()).getLength() != 0) {
                        return true;
                    } else {
                        return false;
                    }
                else
                    return false;
            } else if (entry.getValue() instanceof INullType) {
                return false;
            } else if (entry.getValue() instanceof IGenericType) {
                return false;
            } else if (entry.getValue() instanceof INonPrimitiveType) {
                if (entry.getValue() instanceof IEnumType)
                    return false;
                else if (entry.getValue() instanceof IStringType)
                    return false;
                else
                    return true;
            } else {
                System.err.println("Unknown entry type: " + element.toString());
                return false;
            }
        } else if (element instanceof IMethodScope) {
            return true;
        } else {
            System.err.println("Unknown type: " + element.toString());
            return false;
        }
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof StackMachine) {
            return getChildren(((StackMachine) inputElement).getMethodScope());
        } else if (inputElement instanceof IMethodScope) {
            return getChildren(inputElement);
        } else {
            return EMPTY_ARRAY;
        }
    }

    public synchronized void dispose() {
        parentMap.clear();
    }

    public synchronized void inputChanged(Viewer viewer, Object oldInput,
            Object newInput) {
        parentMap.clear();
    }

}