/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on Sep 12, 2004
 *
 */
package kenya.interpreter.util;

import org.wellquite.kenya.stackMachine.IPointListener;
import org.wellquite.kenya.stackMachine.StackMachine;
import org.wellquite.kenya.stackMachine.types.interfaces.IAtomicClosure;


/**
 * @author matthew
 *
 */
public class InterpreterLastPointReachedCatcher implements IPointListener {

    private final StackMachine sm;
    
    private volatile Object lastPointData;
    
    private volatile IAtomicClosure lastClosure;
    
    public InterpreterLastPointReachedCatcher(StackMachine s) {
        sm = s;
    }
    
    public synchronized void pointReached(Object data) {
        lastPointData = data;
        lastClosure = sm.getClosureScope().getClosure();
    }
    
    public synchronized Object getLastPointData() {
        return lastPointData;
    }
    
    public synchronized IAtomicClosure getLastClosure() {
        return lastClosure;
    }

}
