/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on 06-Aug-2004 by toa02
 *
 */
package kenya.nio;

import java.io.PrintStream;

/**
 * @author toa02
 */
public interface IKenyaNIO {

    /**
     * @return the next non-whitespace / line terminated character from the input stream
     * and returns it, will not consume anything after the character. On an error it will
     * return '\0', and an immediate call to failedLastRead will return true;
     * whitespace / line terminated == any of \n \r \f ' ' \t
     */
    public char readChar();

    /**
     * @return the next parsable integer found on the input stream .
     * May consume white space / line terminators to get up to the integer, 
     * but will not consume any after it.
     * If it cannot find an integer / the next non-whitespace is not a parsable integer, it will return -1. 
     * To distinguish between a genuine -1 and an error, immediately after calling this, 
     * the first call to failedLastRead will be true. 
     * The non-whitespace characters will not be lost in the even of a failed read.
     * This will block unless System.in has been closed, in which case it will return -1 and 
     * failedLastRead will return true
     */
    public int readInt();

    /**
     * @return the next parsable double found on the input stream .
     * May consume white space / line terminators to get up to the double, 
     * but will not consume any after it.
     * If it cannot find an double / the next non-whitespace is not a parsable double, it will return -1. 
     * To distinguish between a genuine -1 and an error, immediately after calling this, 
     * the first call to failedLastRead will be true. 
     * The non-whitespace characters will not be lost in the even of a failed read.
     * This will block unless System.in has been closed, in which case it will return -1 and 
     * failedLastRead will return true 
     */
    public double readDouble();
    
    /**
     * @return consumes all input on the input stream between now and the next line terminator and returns it
     * In the event of a failure (i.e. input stream has been closed ), this will return null and the next call to
     * failedLastRead() will be true)
     */
    public String readString();
    
    /**
     * @return consumes and returns the next literal character onthe input stream.
     * Returns '\0' in the even of failure (i.e. the stream has been closed) and failedLastRead will
     * be return true if it is the next call).
     */
    public char read();
    
    /**
     * @return true iff the input stream has been closed, and consiquently any and all read calls on it
     * will return failure status and set failedLastRead to true.
     */
    public boolean isEOF();

    /**
     * @return true iff the last read* method call in this class returned failure status.
     */
    public boolean failedLastRead();
    
    public void setPrintStream(PrintStream out);
}
