/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on 02-Aug-2004 by toa02
 *
 */
package kenya.passes;

import kenya.errors.KenyaBadLocationError;
import minijava.analysis.DepthFirstAdapter;
import minijava.node.AAndBoolTerm;
import minijava.node.AArrayAllocate;
import minijava.node.ADivTerm;
import minijava.node.AEqEquality;
import minijava.node.AGtRelational;
import minijava.node.AGteqRelational;
import minijava.node.ALtRelational;
import minijava.node.ALteqRelational;
import minijava.node.AMinusMathExpression;
import minijava.node.AMinusUnaryExp;
import minijava.node.AModTerm;
import minijava.node.AMultTerm;
import minijava.node.ANegateUnaryExp;
import minijava.node.ANeqEquality;
import minijava.node.AOrBoolExpression;
import minijava.node.APlusMathExpression;
import minijava.node.APlusUnaryExp;
import minijava.node.AXorBoolExpression;
import minijava.node.Node;

/**
 * Used to check if this is a SingleVariableExpression
 * @author toa02
 *
 */
class SingleVariableExpressionChecker extends DepthFirstAdapter {

    static boolean isSingleVariableExpression(Node node){
        
        SingleVariableExpressionChecker svec = new SingleVariableExpressionChecker();
        
        node.apply(svec);
        return svec._sve;
        
    }

    private boolean _sve;
    private SingleVariableExpressionChecker(){
        _sve = true;
    }
    
    /**
     * @see minijava.analysis.DepthFirstAdapter#caseAOrBoolExpression(minijava.node.AOrBoolExpression)
     */
    public void caseAOrBoolExpression(AOrBoolExpression node) {
        _sve = false;
        return;
    }
    
    /**
     * @see minijava.analysis.DepthFirstAdapter#caseAXorBoolExpression(minijava.node.AXorBoolExpression)
     */
    public void caseAXorBoolExpression(AXorBoolExpression node) {
        _sve = false;
        return;
    }

    /**
     * @see minijava.analysis.DepthFirstAdapter#caseAAndBoolTerm(minijava.node.AAndBoolTerm)
     */
    public void caseAAndBoolTerm(AAndBoolTerm node) {
        _sve = false;
        return;
    }
    
    /**
     * @see minijava.analysis.DepthFirstAdapter#caseAEqEquality(minijava.node.AEqEquality)
     */
    public void caseAEqEquality(AEqEquality node) {
        _sve = false;
        return;
    }
    
    
    /**
     * @see minijava.analysis.DepthFirstAdapter#caseANeqEquality(minijava.node.ANeqEquality)
     */
    public void caseANeqEquality(ANeqEquality node) {
        _sve = false;
        return;
    }
    
    
    /**
     * @see minijava.analysis.DepthFirstAdapter#caseALtRelational(minijava.node.ALtRelational)
     */
    public void caseALtRelational(ALtRelational node) {
        _sve = false;
        return;
    }
    
    /**
     * @see minijava.analysis.DepthFirstAdapter#caseAGtRelational(minijava.node.AGtRelational)
     */
    public void caseAGtRelational(AGtRelational node) {
        _sve = false;
        return;
    }
    
    /**
     * @see minijava.analysis.DepthFirstAdapter#caseALteqRelational(minijava.node.ALteqRelational)
     */
    public void caseALteqRelational(ALteqRelational node) {
        _sve = false;
        return;
    }
    
    /**
     * @see minijava.analysis.DepthFirstAdapter#caseAGteqRelational(minijava.node.AGteqRelational)
     */
    public void caseAGteqRelational(AGteqRelational node) {
        _sve = false;
        return;
    }

    /**
     * @see minijava.analysis.DepthFirstAdapter#caseAPlusMathExpression(minijava.node.APlusMathExpression)
     */
    public void caseAPlusMathExpression(APlusMathExpression node) {
        _sve = false;
        return;
    }
    
    
    /**
     * @see minijava.analysis.DepthFirstAdapter#caseAMinusMathExpression(minijava.node.AMinusMathExpression)
     */
    public void caseAMinusMathExpression(AMinusMathExpression node) {
        _sve = false;
        return;
    }
    
    /**
     * @see minijava.analysis.DepthFirstAdapter#caseAMultTerm(minijava.node.AMultTerm)
     */
    public void caseAMultTerm(AMultTerm node) {
        _sve = false;
        return;
    }
    
    /**
     * @see minijava.analysis.DepthFirstAdapter#caseAModTerm(minijava.node.AModTerm)
     */
    public void caseAModTerm(AModTerm node) {
        _sve = false;
        return;
    }
    
    /**
     * @see minijava.analysis.DepthFirstAdapter#caseADivTerm(minijava.node.ADivTerm)
     */
    public void caseADivTerm(ADivTerm node) {
        _sve = false;
        return;
    }
    
    /**
     * @see minijava.analysis.DepthFirstAdapter#caseAMinusUnaryExp(minijava.node.AMinusUnaryExp)
     */
    public void caseAMinusUnaryExp(AMinusUnaryExp node) {
        _sve = false;
        return;
    }
    
    /**
     * @see minijava.analysis.DepthFirstAdapter#caseAPlusUnaryExp(minijava.node.APlusUnaryExp)
     */
    public void caseAPlusUnaryExp(APlusUnaryExp node) {
        _sve = false;
        return;
    }
    
    /**
     * @see minijava.analysis.DepthFirstAdapter#caseANegateUnaryExp(minijava.node.ANegateUnaryExp)
     */
    public void caseANegateUnaryExp(ANegateUnaryExp node) {
        _sve = false;
        return;
    }

    
    /**
     * @see minijava.analysis.DepthFirstAdapter#caseAArrayAllocate(minijava.node.AArrayAllocate)
     */
    public void caseAArrayAllocate(AArrayAllocate node) {
        throw KenyaBadLocationError.get();
    }
}
