/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on 23-Aug-2004 by toa02
 *
 */
package kenya.passes;

import org.wellquite.kenya.stackMachine.ops.ControlFlowOpsFactory;
import org.wellquite.kenya.stackMachine.types.interfaces.IAtomicClosure;
import org.wellquite.kenya.stackMachine.types.interfaces.IHaltableClosure;

/**
 * @author toa02
 *  
 */
class SwitchHelper {

    private IAtomicClosure _cond;

    private int cPos = -1;

    private IAtomicClosure[] _cases;

    private IAtomicClosure[] _stats;

    private int _defaultPos;

    void setCond(IAtomicClosure cond) {
        if (_cond != null) {
            throw new IllegalStateException(
                    "Attepting to set a condition that has already been set.");
        }
        _cond = cond;
    }

    void initArrays(int size) {
        if (_cases != null) {
            throw new IllegalStateException(
                    "Attempting to initialise arrays that are already initialised");
        }
        _defaultPos = -1;
        cPos = 0;
        _cases = new IAtomicClosure[size];
        _stats = new IAtomicClosure[size];
    }

    void setNextCase(IAtomicClosure cases, IAtomicClosure stats) {
        if( cases==null ){
            _defaultPos = cPos;
        }
        _cases[cPos] = cases;
        _stats[cPos] = stats;
        cPos++;
    }

    IHaltableClosure getSwitchClosure() {
        if (_stats == null || cPos != _stats.length) {
            throw new IllegalStateException("Attempting to get Switch Closure "
                    + "from improperly set up SwitchHelper");
        }

        return ControlFlowOpsFactory.switchClosure(_cond, _cases, _stats,
                _defaultPos);
    }

}