/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on 15-Jul-2004 by toa02
 * With a bit of help from Vim and regular expressions
 * (and eclipse & import management)
 */
package kenya.passes;

import kenya.errors.KenyaInternalError;
import minijava.analysis.DepthFirstAdapter;
import minijava.node.Node;
import minijava.node.TAnd;
import minijava.node.TAssert;
import minijava.node.TAssign;
import minijava.node.TBlank;
import minijava.node.TBoolean;
import minijava.node.TBracketPair;
import minijava.node.TBreak;
import minijava.node.TCase;
import minijava.node.TChar;
import minijava.node.TCharliteral;
import minijava.node.TColon;
import minijava.node.TComma;
import minijava.node.TComment;
import minijava.node.TConst;
import minijava.node.TDefault;
import minijava.node.TDivide;
import minijava.node.TDot;
import minijava.node.TDouble;
import minijava.node.TDpnumber;
import minijava.node.TElse;
import minijava.node.TEnum;
import minijava.node.TEqual;
import minijava.node.TFalse;
import minijava.node.TFor;
import minijava.node.TGreater;
import minijava.node.TGreaterequal;
import minijava.node.TIdentifier;
import minijava.node.TIf;
import minijava.node.TInt;
import minijava.node.TIntnumber;
import minijava.node.TKlass;
import minijava.node.TLBrace;
import minijava.node.TLBracket;
import minijava.node.TLParenthese;
import minijava.node.TLess;
import minijava.node.TLessequal;
import minijava.node.TMinus;
import minijava.node.TMinusminus;
import minijava.node.TMod;
import minijava.node.TNew;
import minijava.node.TNewLine;
import minijava.node.TNot;
import minijava.node.TNotequal;
import minijava.node.TNull;
import minijava.node.TOr;
import minijava.node.TPlus;
import minijava.node.TPlusplus;
import minijava.node.TRBrace;
import minijava.node.TRBracket;
import minijava.node.TRParenthese;
import minijava.node.TReturn;
import minijava.node.TSemicolon;
import minijava.node.TString;
import minijava.node.TStringliteral;
import minijava.node.TSwitch;
import minijava.node.TTimes;
import minijava.node.TTraditionalComment;
import minijava.node.TTrue;
import minijava.node.TVoid;
import minijava.node.TWhile;
import minijava.node.TXor;

/**
 * Depth first navigator that find the first token it can and then gives back
 * its line Number and Character Position in a 2D array.
 * @author toa02
 *
 */
class TokenPositionFinder extends DepthFirstAdapter {

   private static TokenPositionFinder _single; 

   static int[] find(Node node){
      if( _single == null ){
	 _single = new TokenPositionFinder();
      }

      try{
	 node.apply(_single);
      }catch(FoundPos fp){
	 return fp.getPos();
      }

      throw new KenyaInternalError("Could not find co-ordinates for a token. Mmmm.");
   }

   private TokenPositionFinder(){ /* not construcatable */ }


   public void caseTNewLine(TNewLine node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTBlank(TBlank node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTComment(TComment node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTTraditionalComment(TTraditionalComment node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTBoolean(TBoolean node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTChar(TChar node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTInt(TInt node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTDouble(TDouble node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTString(TString node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTVoid(TVoid node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTKlass(TKlass node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTConst(TConst node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTIf(TIf node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTElse(TElse node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTWhile(TWhile node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTReturn(TReturn node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTSwitch(TSwitch node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTCase(TCase node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTBreak(TBreak node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTDefault(TDefault node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTFor(TFor node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTAssert(TAssert node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTNew(TNew node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTEnum(TEnum node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTTrue(TTrue node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTFalse(TFalse node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTNull(TNull node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTAnd(TAnd node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTOr(TOr node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTXor(TXor node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTNot(TNot node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTIdentifier(TIdentifier node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTStringliteral(TStringliteral node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTCharliteral(TCharliteral node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTLParenthese(TLParenthese node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTRParenthese(TRParenthese node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTLBrace(TLBrace node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTRBrace(TRBrace node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTLBracket(TLBracket node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTRBracket(TRBracket node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTBracketPair(TBracketPair node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTSemicolon(TSemicolon node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTColon(TColon node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTComma(TComma node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTDot(TDot node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTPlus(TPlus node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTPlusplus(TPlusplus node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTMinus(TMinus node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTMinusminus(TMinusminus node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTTimes(TTimes node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTDivide(TDivide node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTMod(TMod node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTLess(TLess node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTLessequal(TLessequal node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTGreater(TGreater node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTGreaterequal(TGreaterequal node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTEqual(TEqual node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTNotequal(TNotequal node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTAssign(TAssign node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTIntnumber(TIntnumber node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTDpnumber(TDpnumber node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }





}

class FoundPos extends RuntimeException{

   private static final long serialVersionUID = 0x49763092; 
   
   private int[] _pos;

   FoundPos(int ln, int pos, int len ){
      _pos = new int[] { ln, pos, len };
   }

   int[] getPos(){
      return _pos;
   }
}
