/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on 27-Jul-2004 by toa02
 *
 */
package kenya.sourceCodeInformation.util;

import java.io.StringReader;

import kenya.sourceCodeInformation.interfaces.ISourceCodeLocation;
import kenya.sourceCodeInformation.interfaces.ISourceCodeWarning;

/**
 * @author toa02
 *
 */
class SourceCodeWarning implements ISourceCodeWarning {

    private String _message;
    private int _num;
    private ISourceCodeLocation _pos;
    private ISourceCodeLocation[] _lnkPos;
    
    public SourceCodeWarning(String message, int num, ISourceCodeLocation pos, 
            ISourceCodeLocation[] lnkPos){
        _message = message;
        _num = num;
        _pos = pos;
        _lnkPos = lnkPos;
    }
    
    /**
     * @see kenya.sourceCodeInformation.interfaces.ISourceCodeInformation#getHumanStyleMessage()
     */
    public StringReader getHumanStyleMessage() {
        return new StringReader(_message);
    }
    
    
    /**
     * @see kenya.sourceCodeInformation.interfaces.ISourceCodeInformation#getInformationNumber()
     */
    public int getInformationNumber() {
        return _num;
    }
    /**
     * @see kenya.sourceCodeInformation.interfaces.ISourceCodeInformation#getLinkedInformation()
     */
    public ISourceCodeLocation[] getLinkedInformation() {
        return _lnkPos;
    }
    /**
     * @see kenya.sourceCodeInformation.interfaces.ISourceCodeInformation#getLocation()
     */
    public ISourceCodeLocation getLocation() {
        return _pos;
    }
    
}
