/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on 12-Jul-2004 by toa02
 *
 */
package kenya.types;

import java.util.Map;

import kenya.types.tables.TypeTable;

/**
 * Placeholder for a magic class "KNullType".
 * Most things are Unsupported since they should,
 * in theory,
 * never get called. Tho you can't be sure - hence the
 * runtime exception throwing
 * @author toa02
 *
 */
public class KNullType extends KType {

    private static KNullType _single;
    
    private KNullType(){ /* not construcatable */ }
    
    public synchronized static KNullType get(){
        if( _single == null ){
            _single = new KNullType();
        }
            
        return _single;
    }
    /**
     * @see kenya.types.KType#getName()
     */
    public String getName() {
        return "<nulltype>";
    }

    public String toString(){
        return getName();
    }
    
    /**
     * @see kenya.types.KType#bind(kenya.types.tables.TypeTable)
     */
    public KType bind(TypeTable tt) {
        return this;
    }
    
    
    /**
     * @see kenya.types.KType#compareAndBind(kenya.types.KType, kenya.types.tables.TypeTable)
     */
    public int compareAndBind(KType target, TypeTable tt) {
    	throw new UnsupportedOperationException();
    }
    
    /**
     * @see kenya.types.KType#isBound(java.util.Map)
     */
    public boolean isBound(Map paramMap) {
        throw new UnsupportedOperationException();
    }
    
    /**
     * @see kenya.types.KType#populateParamMap(java.util.Map)
     */
    public void populateParamMap(Map paramMap) {
        throw new UnsupportedOperationException();
    }

}
