/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on 30-Jun-2004 by toa02
 *
 */
package kenya.types;

import java.util.Map;

import kenya.errors.KenyaInternalError;
import kenya.passes.Util;
import kenya.types.tables.TypeTable;
import minijava.node.Node;

/**
 * @author toa02
 *
 */
public class KParamType extends KType {

	private final String _name;
	private Node _node;
	
	public KParamType(String name, Node declNode){
		_name = KParamTypeMapper.get().mapName(name);
		_node = declNode;
	}
	
	public KParamType(String name){
		_name = KParamTypeMapper.get().mapName(name);
		_node = null;
	}
	
	public KParamType(String name, boolean flag){
	    _name = name;
	    _node = null;
	}
	
	public Node getNode(){
	    if( _node == null ){
	        throw new KenyaInternalError("Getting a null node.");
	    }
	    return _node;
	}
		
	/* A parameterized type is exactly equal to only itself 
	 * @see kenya.types.KType#exactlyMatches(kenya.types.KType)
	 */
	public boolean exactlyMatches(KType kt) {
		if( kt instanceof  KParamType ){
			KParamType kpt = (KParamType) kt;
			return ( kpt._name.equals(_name));
		}
		
		return false;
	}
	
	public KType bind( TypeTable tt){
	    if( tt.containsKey(this)){
	    	return tt.lookup(this);
	    }
	    
	    return this;
	}

	/**
	 * @see kenya.types.KType#getName()
	 */
	public String getName() {
		return _name;
	}
	
	
	public boolean isTypeMatch( KType kt ) {
		return true;
	}
	
	
	/**
	 * @see kenya.types.KType#compareAndBind(kenya.types.KType, kenya.types.tables.TypeTable)
	 * Quite a few random subtlties her to do with the behaviour of paraterised functions
	 * that call parameterised functions. All very messy.
	 */
	public int compareAndBind(KType target, TypeTable tt) {

	    if( tt.containsKey(this)){
	        KType kt = tt.lookup(this);

	        /*
	        if( Util.isAssignmentCompatible(target, kt) ){
                tt.force(this, target);
            }else if( Util.isAssignmentCompatible(kt,target)){
                tt.force(this,kt);
            }
	        */

	        //* * Int double char conversions 
	        if( target == KBasicType.getDouble() && Util.isAssignmentCompatible(target, kt)){
	                tt.force(this,KBasicType.getDouble());
	        }else if( target == KBasicType.getInt() && Util.isAssignmentCompatible(target, kt)){
	                tt.force(this,KBasicType.getInt());
	        }
	        
	        // In both directions
	        if( kt == KBasicType.getDouble() && Util.isAssignmentCompatible(kt,target)){
	                tt.force(this,KBasicType.getDouble());
	        }else if( kt == KBasicType.getInt() && Util.isAssignmentCompatible(kt, target)){
	                tt.force(this,KBasicType.getInt());
	        }

	        
	        if( kt instanceof KBoundClassType ){
	            KBoundClassType kbct = (KBoundClassType) kt;
	            if( kbct.getBase() == KClassType.getDouble() && Util.isAssignmentCompatible(KBasicType.getDouble(), target) ){
	                tt.force( this, kbct );
	            }else if( kbct.getBase() == KClassType.getInteger() && Util.isAssignmentCompatible(KBasicType.getInt(), target) ){
	                tt.force( this, kbct );
	            }
	        }
	        
	        if( target instanceof KBoundClassType ){
	            KBoundClassType kbct = (KBoundClassType) target;
	            if( kbct.getBase() == KClassType.getDouble() && Util.isAssignmentCompatible(KBasicType.getDouble(),kt) ){
	                tt.force( this, kbct );
	            }else if( kbct.getBase() == KClassType.getInteger() && Util.isAssignmentCompatible(KBasicType.getInt(),kt) ){
	                tt.force( this, kbct );
	            }
	        }
	        
	        if( kt instanceof KParamType){
	            if(((KParamType) kt).exactlyMatches(target)){
	                return 0;
	            }else{
	                return -1;
	            }
	        }
	        
	        int res = kt.compareAndBind(target, tt);
	        if( res == - 1 ){ return -1; }
	        
	        if( kt instanceof KArrayType){
	            KArrayType klt = (KArrayType) kt;
	            return 1 + klt.getDepth() + res;
	        }else{
	            return 1+res;    
	        }

	    } else if( target == KNullType.get() ){
	    	return 1; /* 1 point bind? */
	    }else{
	        tt.put(this, target);
	        return 1;
	    }
	}
	
	public String toString(){
		return KParamTypeMapper.get().lookupName(_name);
	}

	
	/**
     * @see kenya.types.KType#isBound(java.util.Map)
     */
    public boolean isBound(Map paramMap) {
        return( paramMap.containsKey(KParamTypeMapper.get().lookupName(getName())));
    }
	
    /**
     * @see kenya.types.KType#populateParamMap(java.util.Map)
     */
    public void populateParamMap(Map paramMap) {
        paramMap.put(KParamTypeMapper.get().lookupName(_name),this);
    }
}
