/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/


package kenya.types;

import java.util.HashMap;
import java.util.Map;



/**
 * @author tora
 */
public class KParamTypeMapper {

    public static final String PRE = "@#";
    
    static final KParamTypeMapper instance = new KParamTypeMapper();
    
    public static synchronized KParamTypeMapper get(){
        return instance;
    }
    
    
    private final Map mappings  = new HashMap();
    private volatile long remappings = 0;
    
    synchronized String mapName( String name ){
        String newName = PRE + remappings++;
        mappings.put( newName, name);
        return newName;
    }
    
    public synchronized String lookupName( String name ){
        return (String) mappings.get( name );
    }
    
}
