/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on 01-Jul-2004 by toa02
 *
 */
package kenya.types;

import minijava.node.Node;

/**
 * @author toa02
 *
 */
public class KVariable{

	private String _name;
	private KType _type;
	private boolean _constant;
	private Node _node;
	
	/**
	 * KVariable Constructor.
	 * @param name The name of this varaiable
	 * @param type The KType of this varaiable
	 * @param isValid Whether this variable is "valid" (assigned to) or not.
	 * @param node The node on the sablecc ast where this variable is declared
	 * @param isConstant Whether this variable is a constant.
	 */
	public KVariable( String name, KType type, boolean isConstant, Node node){
		_name = name;
		_type = type;
		_constant = isConstant;
		_node = node;
	}

	public int hashCode(){
		return ( _name.hashCode() + _type.hashCode() );
	}
	
	/**
	 * Provides access to the Sablecc AST Tree node that was used to create this variable.
	 * @return Node on the SableCC AST tree where this was created
	 */
	public Node getNode(){
	    return _node;
	}
	
	/**
	 * @return true if this variable has been specified as a constant.
	 */
	public boolean isConstant(){
	    return _constant;
	}
	
	/**
	 * Get the backing KType of this variable.
	 * @return A KType representing the underlying type
	 * of this KVariable.
	 */
	public KType getType(){
	    return _type;
	}

	/**
	 * Return the name of this variable
	 * @return
	 */
	public String getName(){
	    return _name;
	}
	
	public boolean equals(Object o){
		if( o == this ){ return true; }
		if( o instanceof KVariable){
			KVariable it = (KVariable) o;
			return (
					_name.equals(it._name) &&
					_type.equals(it._type)
					);
		}
		
		return false;
	}
	
	public String toString(){
	    return ( _constant ? "const " : "" ) + _type.getName() + " " + _name; 
	}
}
