/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on 23-Aug-2004 by toa02
 *
 */
package kenya.types.tables;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;

import kenya.errors.KenyaPreconditionError;
import kenya.sourceCodeInformation.interfaces.IVariable;

/**
 * 
 * Essentially a symbol table for the StackMachineBuilder Pass
 * but works on IVariables.
 * @author toa02
 *
 */
public class VariableLookupTable implements Cloneable {

    private LinkedList _tableQueue;
    
    private VariableLookupTable(){ 
        /* not visible from the outside */
        _tableQueue = new LinkedList();
    }
    
    public VariableLookupTable(IVariable[] theseVars){
        _tableQueue = new LinkedList();

        Map hm = new HashMap();
        
        for(int i = 0 ; i < theseVars.length ; i++ ){
            if(hm.put( theseVars[i].getName(),theseVars[i]) != null){
                throw KenyaPreconditionError.get();
            }
        }
        
        _tableQueue.addFirst(hm);
    }
    
    public void push(){
        _tableQueue.addFirst(new HashMap());
    }
    
    public void pop(){
        _tableQueue.removeFirst();
    }
    
    public void add(IVariable variable){
        Map hm = (Map) _tableQueue.getFirst();
        if( hm.put(variable.getName(), variable) != null ){
            throw KenyaPreconditionError.get();
        }
    }
    
    public IVariable lookupByName(String name){
        Iterator it = _tableQueue.iterator();
        
        while(it.hasNext()){
            Map m = (Map) it.next();
            if( m.containsKey(name)){
                return (IVariable) m.get(name);
            }
        }
        
        throw new NoSuchElementException("Cannot find " + name);
    }
    
    
    public boolean hasVariable(String name){
        Iterator it = _tableQueue.iterator();
        
        while( it.hasNext()) {
            Map m = (Map) it.next();
            
            if( m.containsKey(name)){
                return true;
            }
        }
        
        return false;
    }
    
    public Object clone(){
        VariableLookupTable copy = new VariableLookupTable();
    
        Iterator it = _tableQueue.iterator();
        while(it.hasNext()){
            Map m = (Map) it.next();
            						/* 
            						  bad style / dependency here...
            						  v      						*/
            Map cloneMap = (Map) ((HashMap) m).clone();
            copy._tableQueue.addLast(cloneMap);
        }
        
        return copy;
        
    }
    
}
