package kenya.ui;

import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class UIUtils {

    public UIUtils() { }
    
    /**
     * returns the default display that the UI is running on
     * @return Display.getCurrent() if it exists and
     *         Display.getDefault() otherwise
     */
    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if(display == null)
            display = Display.getDefault();
        return display;
    }
    
    /**
     * obrtains the fontmetrics from a given control
     * @param control the control from which to obtain fontmetrics
     * @return fontmetrics of the control
     */
    public static FontMetrics getFontMetrics(Control control) {
        FontMetrics fontMetrics = null;
        GC gc = new GC(control);
        try {
            gc.setFont(control.getFont());
            fontMetrics = gc.getFontMetrics();
        } finally {
            gc.dispose();
        }
        return fontMetrics;
    }
    
    
}