/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on Jul 29, 2004
 *
 */
package kenya.ui.errors;

import java.io.BufferedReader;
import java.io.IOException;

import kenya.sourceCodeInformation.interfaces.ISourceCodeError;
import kenya.sourceCodeInformation.interfaces.ISourceCodeInformation;
import kenya.ui.IButtonManager;

import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;

/**
 * @author Matthew Sackman
 * @version 1
 */
public class HumanErrorLabelProvider implements ITableLabelProvider {

    private final IButtonManager ibm;
    
    private final String delimiter;

    public HumanErrorLabelProvider(IButtonManager ibm, String delimiter) {
        this.ibm = ibm;
        this.delimiter = delimiter;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (element instanceof ISourceCodeError)
            return ibm.getImage(IButtonManager.REDBUTTON);
        else
            return ibm.getImage(IButtonManager.YELLOWBUTTON);
    }

    public String getColumnText(Object element, int columnIndex) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Line ");
        buffer.append(((ISourceCodeInformation) element).getLocation()
                .getLineNumber());
        buffer.append(": ");
        BufferedReader reader = new BufferedReader(
                ((ISourceCodeInformation) element).getHumanStyleMessage());
        try {
            String line = reader.readLine();
            while (line != null) {
                buffer.append(line);
                buffer.append(delimiter);
                line = reader.readLine();
            }
        } catch (IOException e) {
            // nowt to do.
        }
        buffer.delete(buffer.length() - delimiter.length(), buffer.length());
        return buffer.toString();
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.jface.viewers.IBaseLabelProvider#addListener(org.eclipse.jface.viewers.ILabelProviderListener)
     */
    public void addListener(ILabelProviderListener listener) {
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.jface.viewers.IBaseLabelProvider#dispose()
     */
    public void dispose() {
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.jface.viewers.IBaseLabelProvider#isLabelProperty(java.lang.Object,
     *      java.lang.String)
     */
    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.jface.viewers.IBaseLabelProvider#removeListener(org.eclipse.jface.viewers.ILabelProviderListener)
     */
    public void removeListener(ILabelProviderListener listener) {
    }

}