/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on Jul 29, 2004
 *
 */
package kenya.ui.errors;

import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;

import kenya.sourceCodeInformation.interfaces.ISourceCodeError;
import kenya.sourceCodeInformation.interfaces.ISourceCodeInformation;
import kenya.sourceCodeInformation.interfaces.ISourceCodeLocation;
import mediator.ICheckedCode;

import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;

/**
 * @author Matthew Sackman
 * @version 1
 */
public class KenyaErrorContentProvider implements IStructuredContentProvider {
	
	private static final Comparator itemComparator = new Comparator() {
		
		public int compare(ISourceCodeError arg0, ISourceCodeError arg1) {
			ISourceCodeLocation loc0 = arg0.getLocation();
			ISourceCodeLocation loc1 = arg1.getLocation();
			return compare(loc0, loc1);
		}
		
		public int compare(ISourceCodeInformation arg0, ISourceCodeInformation arg1) {
			ISourceCodeLocation loc0 = arg0.getLocation();
			ISourceCodeLocation loc1 = arg1.getLocation();
			return compare(loc0, loc1);
		}
		
		public int compare(ISourceCodeError arg0, Object arg1) {
			return -1;
		}
		
		public int compare(ISourceCodeInformation arg0, Object arg1) {
			return 1;
		}
		
		public int compare(ISourceCodeLocation loc0, ISourceCodeLocation loc1) {
			if(loc0.getLineNumber() == loc1.getLineNumber()) {
				if(loc0.getColumnNumber() == loc1.getColumnNumber()) {
					if(loc0.getTokenLength() == loc1.getTokenLength()) {
						return 0;
					} else {
						return loc1.getTokenLength() - loc0.getTokenLength();
					}
				} else {
					return loc0.getColumnNumber() - loc1.getColumnNumber();
				}
			} else {
				return loc0.getLineNumber() - loc1.getLineNumber();
			}
			
//			if (loc0.getLineNumber() < loc1.getLineNumber()) {
//				return -1;
//			} else if (loc0.getLineNumber() > loc1.getLineNumber()) {
//				return 1;
//			} else {
//				if (loc0.getColumnNumber() < loc1.getColumnNumber()) {
//					return -1;
//				} else if (loc0.getColumnNumber() > loc1.getColumnNumber()) {
//					return 1;
//				} else {
//					if (loc0.getTokenLength() > loc1.getTokenLength()) {
//						return -1;
//					} else if (loc0.getTokenLength() < loc1.getTokenLength()) {
//						return 1;
//					} else {
//						return 0;
//					}
//				}
//			}
		}
		
		public int compare(Object arg0, Object arg1) {
			return 0;
		}
		
	};
	
	private final SortedSet errors = new TreeSet(itemComparator);
	
	public synchronized Object[] getElements(Object inputElement) {
		errors.clear();
		ICheckedCode checker = (ICheckedCode)inputElement;
		if (checker.isErroredCode()) {
			errors.addAll(checker.getErrors());
		}
		errors.addAll(checker.getInfos());
		return errors.toArray();
	}
	
	public void dispose() {
	}
	
	public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
	}
	
	public synchronized int getIndex(ISourceCodeInformation error) {
		if (errors.contains(error)) {
			int count = 0;
			Iterator it = errors.iterator();
			while(it.hasNext()) {
				Object item = it.next();
				if (error.equals(item))
					return count;
				count++;
			}
			return -1;
		} else {
			return -1;
		}
	}
}