/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on Aug 4, 2004
 *
 */
package kenya.ui.indentation;

import java.util.regex.Pattern;

/**
 * @author Matthew Sackman
 * @version 1
 */
public interface ILineIndentation {
		
		/**
		 * indented code (at least one leading whitespace character)
		 */
    static final Pattern INDENT = Pattern.compile("^(\\s+).*?$");
    
    /**
     * closing brace at end of uncommented area
     */
    static final Pattern DECREASINGEND = Pattern
            .compile("^.*\\}\\s*((\\/\\/|\\/\\*).*)?$");
    
    /**
     * closing brace (linestart only)
     */
    static final Pattern DECREASINGSTART = Pattern.compile("^\\s*\\}.*$");
    
    /**
     * opening brace at end of uncommented area
     */
    static final Pattern INCREASINGEND = Pattern
            .compile("^.*\\{\\s*((\\/\\/|\\/\\*).*)?$");
    
    /**
     * line containing an opening brace (linestart only)
     */
    static final Pattern INCREASINGSTART = Pattern.compile("^\\s*\\{.*$");
    
    /**
     * line containing a closing brace
     */
    static final Pattern DECREASEREMOVE = Pattern.compile("^(.*)\\}(.*)$");
    
    /**
     * line containing an opening brace
     */
    static final Pattern INCREASEREMOVE = Pattern.compile("^(.*)\\{(.*)$");
    
    /**
     * semicolon at end of uncommented part
     */
    static final Pattern SEMICOLONEND = Pattern
            .compile("^.*?;\\s*((\\/\\/|\\/\\*).*)?$");
    
    /**
     * uncommented part is whitespace
     */
    static final Pattern SPACELINE = Pattern
            .compile("^\\s*((\\/\\/|\\/\\*).*)?$");
    
    /**
     * a line with trailing spaces
     * (but with non-whitespace characters somewhere on the line)
     */
    static final Pattern TRAILINGSPACE = Pattern.compile("^.*?\\S+(\\s+)$");
    
    /**
     * beginning of a block comment
     */
    static final Pattern BLOCKSTART = Pattern.compile("^(.*?)\\/\\*(.*)$");
    
    /**
     * end of a block comment
     */
    static final Pattern BLOCKEND = Pattern
            .compile("^(.*?)\\*\\/(.*)$");
    
    /**
     * one indentation unit (4 spaces)
     */
    static final String UNIT = "    ";

    int getLineNumber();

    void setLineNumber(int lineNumber);

    void setNextLine(ILineIndentation nextLine);

    void setPreviousLine(ILineIndentation previousLine);

    ILineIndentation getNextLine();

    ILineIndentation getPreviousLine();

    boolean isComplete();

    String getNextLineIndentation();

    int getDepth();

    void parseLineText(String thisLineText, String nextLineText);

    ILineIndentation getLine(int lineNumber);

    boolean isBlockStart();

    boolean isBlockEnd();

    boolean isInBlock();

    void recount();
    
}