/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on 20-Jul-2004 by toa02
 *
 */
package kenya.values;

/**
 * @author toa02
 *
 */
public final class KDoubleValue implements IKNumericValue{
    
    private double _val;
    
    public KDoubleValue(double val){
        _val = val;
    }
    
    
    public double getValue(){
        return _val;
    }
    
    /**
     * @see kenya.values.IKValue#getString()
     */
    public String getString() {
       return Double.toString(_val); 
    }
    
    /**
     * @see kenya.values.IKNumericValue#equalsZero()
     */
    public boolean equalsZero() {
        return (_val == 0);
    }
    
    /**
     * @see kenya.values.IKNumericValue#inCharRange()
     */
    public boolean inCharRange() {
        return false;
    }
    
    /**
     * @see kenya.values.IKNumericValue#getDoubleValue()
     */
    public double getDoubleValue() {
        return _val;
    }

    
    public boolean equals(Object o){
        if( o instanceof IKNumericValue ){ 
            IKNumericValue ikn = (IKNumericValue) o;
            return ikn.getDoubleValue() == getDoubleValue();
        }
        
        return false;
    }
    
    public int hashCode(){
        return (int) _val;
    }
}
