/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on 10-Aug-2004 by toa02
 *
 */
package mediator.stackMachine;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/**
 * Very very quick implementation of a BidirectionalMap
 * for use in StachMachineInformation.
 * 
 * There is 0 safety in here, don't think for a second its general purpose,
 * its not.
 * @author toa02
 *
 */
class BidirectionalMap {
    
    private final Map _AtoB;
    private final Map _BtoA;
    
    public BidirectionalMap(){
        _AtoB = new HashMap();
        _BtoA = new HashMap();
    }
    
    public synchronized void associate( Object lhs, Object rhs ){
        _AtoB.put(lhs,rhs);
        _BtoA.put(rhs,lhs);
    }
    
    public Object lookupRHS(Object lhs){
        return _AtoB.get(lhs);
    }
    
    public Object lookupLHS(Object rhs){
        return _BtoA.get(rhs);
    }
    
    public synchronized String toString(){
        StringBuffer sb = new StringBuffer();
        
        Iterator it = _AtoB.keySet().iterator();
        
        while(it.hasNext()){
            Object lhs = it.next();
            Object rhs = _AtoB.get(lhs);
            
            sb.append(lhs);
            sb.append("\t<==>\t");
            sb.append(rhs);
            sb.append(mediator.IJavaCode.NEWLINE);
        }
        
        return sb.toString();
    }
}
