/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on 10-Aug-2004 by toa02
 *
 */
package mediator.stackMachine;

import kenya.sourceCodeInformation.interfaces.IClass;
import kenya.sourceCodeInformation.interfaces.IFunction;
import kenya.sourceCodeInformation.interfaces.ISourceCodeLocation;
import kenya.sourceCodeInformation.interfaces.IVariable;
import mediator.util.ValidMainChecker;
import minijava.node.AFuncDecDeclaration;

import org.wellquite.kenya.stackMachine.types.interfaces.IBuildableClosure;
import org.wellquite.kenya.stackMachine.types.interfaces.IInterpretedClass;
import org.wellquite.kenya.stackMachine.types.interfaces.IInterpretedEnumeration;
import org.wellquite.kenya.stackMachine.types.interfaces.IInterpretedMethod;

/**
 * @author toa02
 * If you're wondering why this isn't documented, its cos Matt should never see it.
 */
public interface IStackMachineInformationManager {

    public static final String GLOBALCLASS = "<GLOBAL>";
    
    String addNewVariable(IVariable var );
    
    IFunction getFunctionFromNode( AFuncDecDeclaration node );
    
    String lookupVariable( IVariable var );
    
    String lookupFunction( IFunction func );
    
    String lookupClass( IClass clazz );
    
    String lookupEnum( IClass zenum );
    
    IInterpretedMethod 		getMethodBody( IFunction func );
    IInterpretedClass 		getClassBody( IClass clazz );
    IInterpretedEnumeration getEnumBody( IClass enumm );
    IInterpretedClass		getGlobalClassBody();
    IStackMachineInformationProvider build( ValidMainChecker vmc );
    IBuildableClosure		getPreInitClosure();

    void addCodePoint(ISourceCodeLocation iscl);
}
