/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on 10-Aug-2004 by toa02
 *
 */
package mediator.stackMachine;

import java.util.List;

import kenya.sourceCodeInformation.interfaces.IClass;
import kenya.sourceCodeInformation.interfaces.IFunction;
import kenya.sourceCodeInformation.interfaces.IVariable;

import org.wellquite.kenya.stackMachine.types.interfaces.IAtomicClosure;
import org.wellquite.kenya.stackMachine.types.interfaces.IInterpretedClass;

/**
 * Interface to get type information from the StackMachine to the real world.
 * @author toa02
 *
 */
public interface IStackMachineInformationProvider {

    /**
     * Gives back an IFunction representation of a function given the String name
     * of that function in the stack machine.
     * @param name String name of the function in the stack machine
     * @return IFunction information on that function
     */
    public IFunction lookupFunction(String name);
    
    /**
     * Gives back an IClass representation of a class by name
     * @param name String name of the class in the stack machine
     * @return IClass representation of that class
     */
    public IClass lookupClass(String name);
    
    /**
     * Gives back an IClass representation of an enumeration by name
     * @param name String name of the enum in the stack machine
     * @return IClass representation of that enumeration
     */
    public IClass lookupEnum(String name);

    /**
     * Gives back an IVariable representation of a variable by name in the stack machine
     * NOTE the stack machine will not have the real name of the variable: you need to
     * use this map to get back its real name and its type (assuming bound type parameters)
     * @param name
     * @return
     */
    public IVariable lookupVariable(String name);
    
    /**
     * @return String name of the method entry point to the stack-machine
     */
    public String getEntryPoint();
    
    /**
     * @return IInterpretedClass that holds the method which is the entry point as above.
     */
    public IInterpretedClass getEntryPointClass();
    
    /**
     * @return IAtomicClosure the closure to be executed to set up all variables
     * in the stack machine, MUST be called before jumping into the entry point
     * class / method
     */
    public IAtomicClosure getPreInitClosure();
    
    /**
     * @return true iff the method entry point is expecting String[] parameters,
     * false if it expecting nothing.
     */
    public boolean entryPointTakesArguments();
    
    /**
     * @return a List of ISourceCodeLocations
     */
    public List getDiscreteExecutionPointMarkersFromTheAST();
    
}
