/*
 * Created on 06-Jan-2005
 */
package mediator.subscription;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

/**
 * @author Thomas Timbul
 */
public class DefaultSubscriptionService implements ISubscriptionService {
	
	protected DefaultSubscriptionServiceThread service
	  = new DefaultSubscriptionServiceThread(this);
	
	protected static DefaultSubscriptionService inst;
	
	protected HashMap subscriptionMap = new HashMap();
	
	protected DefaultSubscriptionService() {
		//singleton, use getInstance for access
	}
	
	public static DefaultSubscriptionService getInstance() {
		if(inst==null) {
			inst = new DefaultSubscriptionService();
		}
		return inst;
	}
	
	/* (non-Javadoc)
	 * @see kenya.subscription.ISubscriptionService#newSubscription(kenya.subscription.ISubscription)
	 */
	public synchronized String addSubscription(ISubscription sub) {
		String id = generateUniqueID();
		subscriptionMap.put(id, sub);
		return id;
	}
	
	/*
	 *  (non-Javadoc)
	 * @see mediator.subscription.ISubscriptionService#getSubscription(java.lang.String)
	 */
	public synchronized ISubscription getSubscription(String id) {
		return (ISubscription)subscriptionMap.get(id);
	}
	
	/*
	 *  (non-Javadoc)
	 * @see mediator.subscription.ISubscriptionService#cancelSubscription(java.lang.String)
	 */
	public synchronized void cancelSubscription(String id) {
		subscriptionMap.remove(id);
	}
	
	/* (non-Javadoc)
	 * @see kenya.subscription.ISubscriptionService#provideSubscriptionUpdate()
	 */
	public synchronized void provideSubscriptionUpdate() {
		Set ids = subscriptionMap.keySet();
		for(Iterator it = ids.iterator(); it.hasNext(); ) {
			provideASyncSubscriptionUpdate((String)it.next());
		}
	}
	
	/*
	 *  (non-Javadoc)
	 * @see mediator.subscription.ISubscriptionService#provideASyncSubscriptionUpdate(java.lang.String)
	 */
	public synchronized void provideASyncSubscriptionUpdate(final String id) {
		new Thread() {
			public void run() {
				provideSyncSubscriptionUpdate(id);
			}
		}.start();
		
	}
	
	/*
	 *  (non-Javadoc)
	 * @see mediator.subscription.ISubscriptionService#provideSyncSubscriptionUpdate(java.lang.String)
	 */
	public synchronized void provideSyncSubscriptionUpdate(final String id) {
		ISubscription sub = getSubscription(id);
		if(sub==null) {
			return; //sub not existent
		}
		
		ISubscriptionTerms[] terms = sub.getSubscriptionTerms();
		for(int i=0; i<terms.length; i++) {
			terms[i].executeTerms();
			sub.getSubscriber().subscriptionUpdate(sub.getReturnData());
		}
	}
	
	/*
	 *  (non-Javadoc)
	 * @see mediator.subscription.ISubscriptionService#start()
	 */
	public void start() {
		this.stopRunning = false;
		synchronized(this) {
			service.start();
		}
	}
	
	/*
	 *  (non-Javadoc)
	 * @see mediator.subscription.ISubscriptionService#shutdown()
	 */
	public void shutdown() {
		//TODO sendSubscriberShutdownInformation();
		synchronized(this) {
			this.stopRunning();
			notifyAll();
			try {
				this.wait();
			} catch(InterruptedException e) {
			} finally {
				this.subscriptionMap.clear();
			}
		}
	}
	
	boolean stopRunning = false;
	
	private void stopRunning() {
		this.stopRunning = true;
	}
	
	/* (non-Javadoc)
	 * @see java.lang.Runnable#run()
	 */
	public void run() {
		
		while(!stopRunning) {
			synchronized(this) {
				try {
					this.wait();
				} catch(InterruptedException e) {
					e.printStackTrace();
				}
			}
		}
		
		synchronized(this) {
			notifyAll();
		}
	}
	
	protected class DefaultSubscriptionServiceThread extends Thread {
		
		DefaultSubscriptionServiceThread(Runnable run) {
			super(run);
		}
		
	}
	
	protected String generateUniqueID() {
		String id = "";
		while(id.length()<10) {
			id += (char)(int)(64+Math.random()*63);
		}
		//	if it exists already, change a random letter to make it unique
		while(subscriptionMap.containsKey(id)) {
			char[] i = id.toCharArray();
			int rand = (int)(Math.random()*10);
			i[rand] = (char)(64+((i[rand]+1)%63));
			id = new String(i);
		}
		return id;
	}
}
