/*
 * Created on 06-Jan-2005
 */
package mediator.subscription;

/**
 * @author Thomas Timbul
 */
public interface ICombinedSubscription extends ISubscription {
	
	/**
	 * appends further terms to this subscription. When the subscription
	 * receives an update, all Terms added through this method are executed.
	 * @param terms the terms to add to this subscription
	 */
	public void appendTerms(ISubscriptionTerms terms );
	
	/**
	 * removes the given terms from this subscription. They will no longer
	 * executed when this subscription receives an update.
	 * @param terms
	 */
	public void removeTerms(ISubscriptionTerms terms );
	
	
}
