/*
 * Created on 30-Oct-2004
 */
package mediator.subscription;


/**
 * @author Thomas Timbul
 */
public class MediationSubscription implements ICombinedSubscription {
	
	protected ISubscriber fSubscriber;
	protected MediationTerms[] fTerms;
	
	public MediationSubscription(ISubscriber subscriber, MediationTerms terms) {
		fSubscriber = subscriber;
		fTerms = new MediationTerms[] {terms};
	}
	
	/* (non-Javadoc)
	 * @see mediator.subscription.ISubscription#getSubscriber()
	 */
	public ISubscriber getSubscriber() {
		return fSubscriber;
	}
	
	/* (non-Javadoc)
	 * @see mediator.subscription.ISubscription#getSubscriptionTerms()
	 */
	public ISubscriptionTerms[] getSubscriptionTerms() {
		return fTerms;
	}
	
	/* (non-Javadoc)
	 * @see mediator.subscription.ICombinedSubscription#appendTerms(mediator.subscription.ISubscriptionTerms)
	 */
	public void appendTerms(ISubscriptionTerms terms) {
		//not supported
	}
	
	/* (non-Javadoc)
	 * @see mediator.subscription.ICombinedSubscription#removeTerms(mediator.subscription.ISubscriptionTerms)
	 */
	public void removeTerms(ISubscriptionTerms terms) {
		//not supported
	}
	
	/* (non-Javadoc)
	 * @see mediator.subscription.ISubscription#getReturnData()
	 */
	public ISubscriptionData getReturnData() {
		return fTerms[0].getReturnData();
	}

}
