/*
 * Created on 30-Oct-2004
 */
package mediator.subscription;

import java.io.IOException;
import java.io.Reader;

import mediator.ICheckedCode;
import mediator.IJavaCode;
import mediator.Mediator;

/**
 * @author Thomas Timbul
 */
public class MediationTerms implements ISubscriptionTerms {
	
	private final MediatorInput input;
	private final ICheckedCodeReceiver[] iccr;
	private final IJavaCodeReceiver[] ijcr;
	
	private ISubscriptionData returnData = null;
	
	/**
	 * convenience for<br>
	 * <code>new MediationTerms(input, new ICheckedCodeReceiver[]{iccr}, new IJavaCodeReceiver[]{ijcr})</code>
	 */
	public MediationTerms(MediatorInput input, ICheckedCodeReceiver iccr, IJavaCodeReceiver ijcr) {
		this(input, new ICheckedCodeReceiver[]{iccr}, new IJavaCodeReceiver[]{ijcr} );
	}
	
	/**
	 * @param input where to draw input from
	 * @param iccr list of ICheckedCodeReceivers that will receive the ICheckedCode
	 * @param ijcr list of IJavaCodeReceivers that will reveive the IJavaCode
	 */
	public MediationTerms(MediatorInput input, ICheckedCodeReceiver[] iccr, IJavaCodeReceiver[] ijcr) {
		this.input = input;
		this.iccr = iccr;
		this.ijcr = ijcr;
	}
	
	/*
	 *  (non-Javadoc)
	 * @see mediator.subscription.ISubscriptionTerms#executeTerms()
	 */
	public void executeTerms() {
		
		final Reader in = input!=null?input.getReader():null;
		
		if(in==null) {
			returnData = new ISubscriptionData() {
				public Object[] getContents() {
					return new Object[]{new RuntimeException()};
				}
			};
			return;
		}
		try {
			final ICheckedCode checkedCode = Mediator.check(in);
			if(iccr!=null) {
				for(int i = 0; i < iccr.length; i++) {
					iccr[i].setCheckedCode(checkedCode);
				}
			}
			final IJavaCode jc = checkedCode.isErroredCode()
																?null
																:checkedCode.translate();
			if(ijcr!=null) {
				for(int i = 0; i < ijcr.length; i++) {
					ijcr[i].setJavaCode(jc);
				}
			}
		  
	    returnData = new ISubscriptionData() {
					public Object[] getContents() {
						return new Object[]{checkedCode, jc};
					}
				};
	    
		} catch(final IOException e) {
			returnData = new ISubscriptionData() {
					public Object[] getContents() {
						return new Object[]{e};
					}
				};
		} finally {
			try {
				in.close();
			} catch(IOException e) {
				//do nothing
			}
		}
		
	}
	
	/* (non-Javadoc)
	 * @see mediator.subscription.ISubscriptionTerms#getReturnData()
	 */
	public ISubscriptionData getReturnData() {
		return returnData;
		
	}
	
}
