/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on 04-Aug-2004 by toa02
 *
 */
package mediator.util;

import minijava.node.AFuncDecDeclaration;
import kenya.sourceCodeInformation.interfaces.IClass;
import kenya.sourceCodeInformation.interfaces.IFunction;
import kenya.sourceCodeInformation.interfaces.ISourceCodeLocation;
import kenya.sourceCodeInformation.interfaces.IVariable;

/**
 * @author toa02
 *
 */
public class AFunctionInstance implements IFunction{

    private final IClass[] _typeParams;
    private final String _name;
    private final IClass _returnType;
    private final IVariable[] _arguments;
    private final ISourceCodeLocation _position;
    private final AFuncDecDeclaration _node;
    
    public AFunctionInstance( 
            IClass[] typeParams,
            String name,
            IClass returnType,
            IVariable[] arguments,
            ISourceCodeLocation position,
            AFuncDecDeclaration node){
        _typeParams = typeParams;
        _name = name;
        _returnType = returnType;
        _arguments = arguments;
        _position = position;
        _node = node;
    }
    
    
    /**
     * @see kenya.sourceCodeInformation.interfaces.IFunction#normalise()
     */
    public IFunction normalise() {
        IClass[] typeParams = new IClass[_typeParams.length];
        IClass returnType = _returnType.normalise();
        IVariable[] arguments = new IVariable[_arguments.length];
        
        for(int i = 0 ; i < typeParams.length ; i++ ){
            typeParams[i] = _typeParams[i].normalise();
        }
        
        for(int i = 0 ; i < arguments.length ; i++ ){
            arguments[i] = _arguments[i].normalise();
        }
        
        return new AFunctionInstance(typeParams,_name,returnType,arguments,_position,_node);
    }
    
    /**
     * @see kenya.sourceCodeInformation.interfaces.IFunction#getTypeParams()
     */
    public IClass[] getTypeParams() {
        return _typeParams;
    }
    
    /**
     * @see kenya.sourceCodeInformation.interfaces.IFunction#getName()
     */
    public String getName() {
        return _name;
    }
    
    /**
     * @see kenya.sourceCodeInformation.interfaces.IFunction#getReturnType()
     */
    public IClass getReturnType() {
        return _returnType;
    }
    
    /**
     * @see kenya.sourceCodeInformation.interfaces.IFunction#getArguments()
     */
    public IVariable[] getArguments() {
        return _arguments;
    }
    
    /**
     * @see kenya.sourceCodeInformation.interfaces.IFunction#getPosition()
     */
    public ISourceCodeLocation getPosition() {
        return _position;
    }
    
    /**
     * @see kenya.sourceCodeInformation.interfaces.IFunction#getDeclarationNode()
     */
    public AFuncDecDeclaration getDeclarationNode() {
        return _node;
    }
    
    public String toString(){
        StringBuffer sb = new StringBuffer();
        
        if( _typeParams.length > 0 ){
            sb.append("<");
            for(int i = 0 ; i < _typeParams.length ; i++ ){
                sb.append( _typeParams[i].toString());
                if( i < _typeParams.length - 1 ){
                    sb.append(",");
                }
            }
            sb.append(" ");
        }
        
        sb.append(_returnType);
        sb.append(" ");
        sb.append(_name);
        sb.append("(");
        
        for(int i = 0 ; i < _arguments.length; i++){
            sb.append(_arguments[i].toString());
            if( i < _arguments.length-1){
                sb.append(",");
            }
        }
        sb.append(")");
        
        return sb.toString();
    }
}
