/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on 18-Aug-2004 by toa02
 *
 */
package mediator.util;

import kenya.sourceCodeInformation.interfaces.IClass;
import kenya.sourceCodeInformation.interfaces.ISourceCodeLocation;
import kenya.sourceCodeInformation.interfaces.IVariable;

/**
 * @author toa02
 *
 */
public class AVariableInstance implements IVariable {

    private final String _name;
    private final ISourceCodeLocation _pos;
    private final IClass _type;
    
    public AVariableInstance(String name, ISourceCodeLocation pos, IClass type){
        _name = name;
        _pos = pos;
        _type = type;
    }
    
    
    /**
     * @see kenya.sourceCodeInformation.interfaces.IVariable#normalise()
     */
    public IVariable normalise() {
        return new AVariableInstance( _name, _pos, _type.normalise());
    }
    
    /**
     * @see kenya.sourceCodeInformation.interfaces.IVariable#getName()
     */
    public String getName() {
        return _name;
    }
    
    /**
     * @see kenya.sourceCodeInformation.interfaces.IVariable#getPosition()
     */
    public ISourceCodeLocation getPosition() {
        return _pos;
    }
    
    /**
     * @see kenya.sourceCodeInformation.interfaces.IVariable#getType()
     */
    public IClass getType() {
        return _type;
    }

    /**
     * @see java.lang.Object#toString()
     */
    public String toString(){
        return _type.toString() + " " + _name.toString();
    }
    
}
