/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on 05-Aug-2004 by toa02
 *
 */
package mediator.util;

import kenya.sourceCodeInformation.interfaces.IFunction;

/**
 * Grief, what an awful name
 * @author toa02
 *
 */
public class ValidMainChecker {

    private final boolean _mainNoArgs;
    private final boolean _mainWithStringArgs;
    
    private final IFunction _noArgsMain;
    private final IFunction _withStringArgsMain;
    
    public ValidMainChecker(InformationHolder ih ){

        boolean mainNoArgs = false;
        boolean mainWithStringArgs = false;
        IFunction noArgsMains = null;
        IFunction withStringArgsMain = null;
        
        IFunction[] funcs = ih.getFunctions();
        
        for(int i = 0 ; i < funcs.length ; i++ ){
            String name = funcs[i].getName();

            if( name.equals("main")){
                
                if( funcs[i].getTypeParams().length != 0 ){ continue; }
              
                
                if( funcs[i].getArguments().length == 0 ){
                    if( !funcs[i].getReturnType().getName().equals("void")){ continue; }
                    mainNoArgs = true;
                    noArgsMains = funcs[i];
                }
                
                if( funcs[i].getArguments().length == 1 &&
                    funcs[i].getArguments()[0].getType().getName().equals("String[]") ){
                    
                    // Ok this is slightly harsh, but if you try and do String main(String[] args) its not allowed
                    if( !funcs[i].getReturnType().getName().equals("void")){
                        _mainNoArgs = false;
                        _mainWithStringArgs = false;
                        _noArgsMain = null;
                        _withStringArgsMain = null;
                        return;
                    }
                    
                    mainWithStringArgs = true;
                    withStringArgsMain = funcs[i];
                }
                
                if( mainWithStringArgs&& mainNoArgs){ break; }
            }
        }
        
        _mainNoArgs = mainNoArgs;
        _mainWithStringArgs = mainWithStringArgs;
        _noArgsMain = noArgsMains;
        _withStringArgsMain = withStringArgsMain;
    }
    
    public boolean haveMainWithStringArgs(){
        return _mainWithStringArgs;
        
    }
    
    public boolean haveMainNoArgs(){
        return _mainNoArgs;
    }
    
    public IFunction getMainWithStringArgs(){
        return _withStringArgsMain;
    }
    
    public IFunction getMainWithNoArgs(){
        return _noArgsMain;
    }
}
