/* This file was generated by SableCC (http://www.sablecc.org/). */

package minijava.lexer;

import java.io.*;
import java.util.*;
import minijava.node.*;

public class Lexer
{
    protected Token token;
    protected State state = State.INITIAL;

    private PushbackReader in;
    private int line;
    private int pos;
    private boolean cr;
    private boolean eof;
    private final StringBuffer text = new StringBuffer();

    protected void filter() throws LexerException, IOException
    {
    }

    public Lexer(PushbackReader in)
    {
        this.in = in;

        if(gotoTable == null)
        {
            try
            {
                DataInputStream s = new DataInputStream(
                    new BufferedInputStream(
                    Lexer.class.getResourceAsStream("lexer.dat")));

                // read gotoTable
                int length = s.readInt();
                gotoTable = new int[length][][][];
                for(int i = 0; i < gotoTable.length; i++)
                {
                    length = s.readInt();
                    gotoTable[i] = new int[length][][];
                    for(int j = 0; j < gotoTable[i].length; j++)
                    {
                        length = s.readInt();
                        gotoTable[i][j] = new int[length][3];
                        for(int k = 0; k < gotoTable[i][j].length; k++)
                        {
                            for(int l = 0; l < 3; l++)
                            {
                                gotoTable[i][j][k][l] = s.readInt();
                            }
                        }
                    }
                }

                // read accept
                length = s.readInt();
                accept = new int[length][];
                for(int i = 0; i < accept.length; i++)
                {
                    length = s.readInt();
                    accept[i] = new int[length];
                    for(int j = 0; j < accept[i].length; j++)
                    {
                        accept[i][j] = s.readInt();
                    }
                }

                s.close();
            }
            catch(Exception e)
            {
                throw new RuntimeException("The file \"lexer.dat\" is either missing or corrupted.");
            }
        }
    }

    public Token peek() throws LexerException, IOException
    {
        while(token == null)
        {
            token = getToken();
            filter();
        }

        return token;
    }

    public Token next() throws LexerException, IOException
    {
        while(token == null)
        {
            token = getToken();
            filter();
        }

        Token result = token;
        token = null;
        return result;
    }

    protected Token getToken() throws IOException, LexerException
    {
        int dfa_state = 0;

        int start_pos = pos;
        int start_line = line;

        int accept_state = -1;
        int accept_token = -1;
        int accept_length = -1;
        int accept_pos = -1;
        int accept_line = -1;

        int[][][] gotoTable = this.gotoTable[state.id()];
        int[] accept = this.accept[state.id()];
        text.setLength(0);

        while(true)
        {
            int c = getChar();

            if(c != -1)
            {
                switch(c)
                {
                case 10:
                    if(cr)
                    {
                        cr = false;
                    }
                    else
                    {
                        line++;
                        pos = 0;
                    }
                    break;
                case 13:
                    line++;
                    pos = 0;
                    cr = true;
                    break;
                default:
                    pos++;
                    cr = false;
                    break;
                };

                text.append((char) c);

                do
                {
                    int oldState = (dfa_state < -1) ? (-2 -dfa_state) : dfa_state;

                    dfa_state = -1;

                    int[][] tmp1 =  gotoTable[oldState];
                    int low = 0;
                    int high = tmp1.length - 1;

                    while(low <= high)
                    {
                        int middle = (low + high) / 2;
                        int[] tmp2 = tmp1[middle];

                        if(c < tmp2[0])
                        {
                            high = middle - 1;
                        }
                        else if(c > tmp2[1])
                        {
                            low = middle + 1;
                        }
                        else
                        {
                            dfa_state = tmp2[2];
                            break;
                        }
                    }
                }while(dfa_state < -1);
            }
            else
            {
                dfa_state = -1;
            }

            if(dfa_state >= 0)
            {
                if(accept[dfa_state] != -1)
                {
                    accept_state = dfa_state;
                    accept_token = accept[dfa_state];
                    accept_length = text.length();
                    accept_pos = pos;
                    accept_line = line;
                }
            }
            else
            {
                if(accept_state != -1)
                {
                    switch(accept_token)
                    {
                    case 0:
                        {
                            Token token = new0(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 1:
                        {
                            Token token = new1(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 2:
                        {
                            Token token = new2(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 3:
                        {
                            Token token = new3(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 4:
                        {
                            Token token = new4(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 5:
                        {
                            Token token = new5(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 6:
                        {
                            Token token = new6(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 7:
                        {
                            Token token = new7(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 8:
                        {
                            Token token = new8(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 9:
                        {
                            Token token = new9(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 10:
                        {
                            Token token = new10(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 11:
                        {
                            Token token = new11(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 12:
                        {
                            Token token = new12(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 13:
                        {
                            Token token = new13(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 14:
                        {
                            Token token = new14(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 15:
                        {
                            Token token = new15(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 16:
                        {
                            Token token = new16(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 17:
                        {
                            Token token = new17(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 18:
                        {
                            Token token = new18(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 19:
                        {
                            Token token = new19(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 20:
                        {
                            Token token = new20(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 21:
                        {
                            Token token = new21(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 22:
                        {
                            Token token = new22(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 23:
                        {
                            Token token = new23(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 24:
                        {
                            Token token = new24(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 25:
                        {
                            Token token = new25(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 26:
                        {
                            Token token = new26(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 27:
                        {
                            Token token = new27(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 28:
                        {
                            Token token = new28(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 29:
                        {
                            Token token = new29(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 30:
                        {
                            Token token = new30(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 31:
                        {
                            Token token = new31(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 32:
                        {
                            Token token = new32(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 33:
                        {
                            Token token = new33(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 34:
                        {
                            Token token = new34(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 35:
                        {
                            Token token = new35(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 36:
                        {
                            Token token = new36(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 37:
                        {
                            Token token = new37(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 38:
                        {
                            Token token = new38(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 39:
                        {
                            Token token = new39(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 40:
                        {
                            Token token = new40(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 41:
                        {
                            Token token = new41(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 42:
                        {
                            Token token = new42(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 43:
                        {
                            Token token = new43(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 44:
                        {
                            Token token = new44(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 45:
                        {
                            Token token = new45(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 46:
                        {
                            Token token = new46(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 47:
                        {
                            Token token = new47(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 48:
                        {
                            Token token = new48(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 49:
                        {
                            Token token = new49(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 50:
                        {
                            Token token = new50(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 51:
                        {
                            Token token = new51(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 52:
                        {
                            Token token = new52(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 53:
                        {
                            Token token = new53(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 54:
                        {
                            Token token = new54(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 55:
                        {
                            Token token = new55(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 56:
                        {
                            Token token = new56(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 57:
                        {
                            Token token = new57(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 58:
                        {
                            Token token = new58(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 59:
                        {
                            Token token = new59(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 60:
                        {
                            Token token = new60(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 61:
                        {
                            Token token = new61(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    }
                }
                else
                {
                    if(text.length() > 0)
                    {
                        throw new LexerException(
                            "[" + (start_line + 1) + "," + (start_pos + 1) + "]" +
                            " Unknown token: " + text);
                    }
                    else
                    {
                        EOF token = new EOF(
                            start_line + 1,
                            start_pos + 1);
                        return token;
                    }
                }
            }
        }
    }

    Token new0(String text, int line, int pos) { return new TReservedWord(text, line, pos); }
    Token new1(String text, int line, int pos) { return new TNewLine(text, line, pos); }
    Token new2(String text, int line, int pos) { return new TBlank(text, line, pos); }
    Token new3(String text, int line, int pos) { return new TComment(text, line, pos); }
    Token new4(String text, int line, int pos) { return new TTraditionalComment(text, line, pos); }
    Token new5(int line, int pos) { return new TBoolean(line, pos); }
    Token new6(int line, int pos) { return new TChar(line, pos); }
    Token new7(int line, int pos) { return new TInt(line, pos); }
    Token new8(int line, int pos) { return new TDouble(line, pos); }
    Token new9(int line, int pos) { return new TString(line, pos); }
    Token new10(int line, int pos) { return new TVoid(line, pos); }
    Token new11(int line, int pos) { return new TKlass(line, pos); }
    Token new12(int line, int pos) { return new TConst(line, pos); }
    Token new13(int line, int pos) { return new TIf(line, pos); }
    Token new14(int line, int pos) { return new TElse(line, pos); }
    Token new15(int line, int pos) { return new TWhile(line, pos); }
    Token new16(int line, int pos) { return new TReturn(line, pos); }
    Token new17(int line, int pos) { return new TSwitch(line, pos); }
    Token new18(int line, int pos) { return new TCase(line, pos); }
    Token new19(int line, int pos) { return new TBreak(line, pos); }
    Token new20(int line, int pos) { return new TDefault(line, pos); }
    Token new21(int line, int pos) { return new TFor(line, pos); }
    Token new22(int line, int pos) { return new TAssert(line, pos); }
    Token new23(int line, int pos) { return new TNew(line, pos); }
    Token new24(int line, int pos) { return new TEnum(line, pos); }
    Token new25(int line, int pos) { return new TTrue(line, pos); }
    Token new26(int line, int pos) { return new TFalse(line, pos); }
    Token new27(int line, int pos) { return new TNull(line, pos); }
    Token new28(int line, int pos) { return new TAnd(line, pos); }
    Token new29(int line, int pos) { return new TOr(line, pos); }
    Token new30(int line, int pos) { return new TXor(line, pos); }
    Token new31(int line, int pos) { return new TNot(line, pos); }
    Token new32(String text, int line, int pos) { return new TIdentifier(text, line, pos); }
    Token new33(String text, int line, int pos) { return new TStringliteral(text, line, pos); }
    Token new34(String text, int line, int pos) { return new TCharliteral(text, line, pos); }
    Token new35(int line, int pos) { return new TLParenthese(line, pos); }
    Token new36(int line, int pos) { return new TRParenthese(line, pos); }
    Token new37(int line, int pos) { return new TLBrace(line, pos); }
    Token new38(int line, int pos) { return new TRBrace(line, pos); }
    Token new39(int line, int pos) { return new TLBracket(line, pos); }
    Token new40(int line, int pos) { return new TRBracket(line, pos); }
    Token new41(String text, int line, int pos) { return new TBracketPair(text, line, pos); }
    Token new42(int line, int pos) { return new TSemicolon(line, pos); }
    Token new43(int line, int pos) { return new TColon(line, pos); }
    Token new44(int line, int pos) { return new TComma(line, pos); }
    Token new45(String text, int line, int pos) { return new TDot(text, line, pos); }
    Token new46(int line, int pos) { return new TPlus(line, pos); }
    Token new47(int line, int pos) { return new TPlusplus(line, pos); }
    Token new48(int line, int pos) { return new TMinus(line, pos); }
    Token new49(int line, int pos) { return new TMinusminus(line, pos); }
    Token new50(int line, int pos) { return new TTimes(line, pos); }
    Token new51(int line, int pos) { return new TDivide(line, pos); }
    Token new52(int line, int pos) { return new TMod(line, pos); }
    Token new53(int line, int pos) { return new TLess(line, pos); }
    Token new54(int line, int pos) { return new TLessequal(line, pos); }
    Token new55(int line, int pos) { return new TGreater(line, pos); }
    Token new56(int line, int pos) { return new TGreaterequal(line, pos); }
    Token new57(int line, int pos) { return new TEqual(line, pos); }
    Token new58(int line, int pos) { return new TNotequal(line, pos); }
    Token new59(int line, int pos) { return new TAssign(line, pos); }
    Token new60(String text, int line, int pos) { return new TIntnumber(text, line, pos); }
    Token new61(String text, int line, int pos) { return new TDpnumber(text, line, pos); }

    private int getChar() throws IOException
    {
        if(eof)
        {
            return -1;
        }

        int result = in.read();

        if(result == -1)
        {
            eof = true;
        }

        return result;
    }

    private void pushBack(int acceptLength) throws IOException
    {
        int length = text.length();
        for(int i = length - 1; i >= acceptLength; i--)
        {
            eof = false;

            in.unread(text.charAt(i));
        }
    }

    protected void unread(Token token) throws IOException
    {
        String text = token.getText();
        int length = text.length();

        for(int i = length - 1; i >= 0; i--)
        {
            eof = false;

            in.unread(text.charAt(i));
        }

        pos = token.getPos() - 1;
        line = token.getLine() - 1;
    }

    private String getText(int acceptLength)
    {
        StringBuffer s = new StringBuffer(acceptLength);
        for(int i = 0; i < acceptLength; i++)
        {
            s.append(text.charAt(i));
        }

        return s.toString();
    }

    private static int[][][][] gotoTable;
/*  {
        { // INITIAL
            {{9, 9, 1}, {10, 10, 2}, {13, 13, 3}, {32, 32, 4}, {33, 33, 5}, {34, 34, 6}, {37, 37, 7}, {38, 38, 8}, {39, 39, 9}, {40, 40, 10}, {41, 41, 11}, {42, 42, 12}, {43, 43, 13}, {44, 44, 14}, {45, 45, 15}, {46, 46, 16}, {47, 47, 17}, {48, 57, 18}, {58, 58, 19}, {59, 59, 20}, {60, 60, 21}, {61, 61, 22}, {62, 62, 23}, {65, 82, 24}, {83, 83, 25}, {84, 90, 24}, {91, 91, 26}, {93, 93, 27}, {94, 94, 28}, {95, 95, 29}, {97, 97, 30}, {98, 98, 31}, {99, 99, 32}, {100, 100, 33}, {101, 101, 34}, {102, 102, 35}, {103, 103, 36}, {104, 104, 37}, {105, 105, 38}, {106, 107, 37}, {108, 108, 39}, {109, 109, 37}, {110, 110, 40}, {111, 111, 37}, {112, 112, 41}, {113, 113, 37}, {114, 114, 42}, {115, 115, 43}, {116, 116, 44}, {117, 117, 37}, {118, 118, 45}, {119, 119, 46}, {120, 122, 37}, {123, 123, 47}, {124, 124, 48}, {125, 125, 49}, },
            {{9, 9, 1}, {32, 32, 4}, },
            {},
            {{10, 10, 50}, },
            {{9, 32, -3}, },
            {{61, 61, 51}, },
            {{9, 9, 52}, {32, 33, 52}, {34, 34, 53}, {35, 91, 52}, {92, 92, 54}, {93, 127, 52}, },
            {},
            {{38, 38, 55}, },
            {{9, 9, 56}, {32, 38, 56}, {40, 91, 56}, {92, 92, 57}, {93, 127, 56}, },
            {},
            {},
            {},
            {{43, 43, 58}, },
            {},
            {{45, 45, 59}, },
            {},
            {{42, 42, 60}, {47, 47, 61}, },
            {{46, 46, 62}, {48, 57, 18}, },
            {},
            {},
            {{61, 61, 63}, },
            {{61, 61, 64}, },
            {{61, 61, 65}, },
            {{48, 57, 66}, {65, 90, 67}, {95, 95, 68}, {97, 122, 69}, },
            {{48, 95, -26}, {97, 115, 69}, {116, 116, 70}, {117, 122, 69}, },
            {{32, 32, 71}, {93, 93, 72}, },
            {},
            {},
            {{48, 122, -26}, },
            {{48, 95, -26}, {97, 97, 69}, {98, 98, 73}, {99, 114, 69}, {115, 115, 74}, {116, 122, 69}, },
            {{48, 95, -26}, {97, 110, 69}, {111, 111, 75}, {112, 113, 69}, {114, 114, 76}, {115, 120, 69}, {121, 121, 77}, {122, 122, 69}, },
            {{48, 95, -26}, {97, 97, 78}, {98, 103, 69}, {104, 104, 79}, {105, 107, 69}, {108, 108, 80}, {109, 110, 69}, {111, 111, 81}, {112, 122, 69}, },
            {{48, 95, -26}, {97, 100, 69}, {101, 101, 82}, {102, 110, 69}, {111, 111, 83}, {112, 122, 69}, },
            {{48, 95, -26}, {97, 107, 69}, {108, 108, 84}, {109, 109, 69}, {110, 110, 85}, {111, 119, 69}, {120, 120, 86}, {121, 122, 69}, },
            {{48, 95, -26}, {97, 97, 87}, {98, 104, 69}, {105, 105, 88}, {106, 107, 69}, {108, 108, 89}, {109, 110, 69}, {111, 111, 90}, {112, 122, 69}, },
            {{48, 110, -33}, {111, 111, 91}, {112, 122, 69}, },
            {{48, 122, -26}, },
            {{48, 95, -26}, {97, 101, 69}, {102, 102, 92}, {103, 108, 69}, {109, 109, 93}, {110, 110, 94}, {111, 122, 69}, },
            {{48, 110, -33}, {111, 111, 95}, {112, 122, 69}, },
            {{48, 95, -26}, {97, 97, 96}, {98, 100, 69}, {101, 101, 97}, {102, 116, 69}, {117, 117, 98}, {118, 122, 69}, },
            {{48, 95, -26}, {97, 97, 99}, {98, 113, 69}, {114, 114, 100}, {115, 116, 69}, {117, 117, 101}, {118, 122, 69}, },
            {{48, 100, -35}, {101, 101, 102}, {102, 122, 69}, },
            {{48, 95, -26}, {97, 103, 69}, {104, 104, 103}, {105, 115, 69}, {116, 116, 104}, {117, 117, 105}, {118, 118, 69}, {119, 119, 106}, {120, 120, 69}, {121, 121, 107}, {122, 122, 69}, },
            {{48, 103, -45}, {104, 104, 108}, {105, 113, 69}, {114, 114, 109}, {115, 122, 69}, },
            {{48, 110, -33}, {111, 111, 110}, {112, 122, 69}, },
            {{48, 103, -45}, {104, 104, 111}, {105, 122, 69}, },
            {},
            {{124, 124, 112}, },
            {},
            {},
            {},
            {{9, 127, -8}, },
            {},
            {{34, 34, 113}, {39, 39, 114}, {48, 48, 115}, {92, 92, 116}, {98, 98, 117}, {102, 102, 118}, {110, 110, 119}, {114, 114, 120}, {116, 116, 121}, },
            {},
            {{39, 39, 122}, },
            {{34, 34, 123}, {39, 39, 124}, {48, 48, 125}, {92, 92, 126}, {98, 98, 127}, {102, 102, 128}, {110, 110, 129}, {114, 114, 130}, {116, 116, 131}, },
            {},
            {},
            {{9, 9, 132}, {10, 10, 133}, {13, 13, 134}, {32, 41, 132}, {42, 42, 135}, {43, 127, 132}, },
            {{9, 9, 136}, {10, 10, 137}, {13, 13, 138}, {32, 127, 136}, },
            {{48, 57, 139}, },
            {},
            {},
            {},
            {{48, 122, -26}, },
            {{48, 122, -26}, },
            {{48, 122, -26}, },
            {{48, 122, -26}, },
            {{48, 95, -26}, {97, 113, 69}, {114, 114, 140}, {115, 122, 69}, },
            {{32, 93, -28}, },
            {},
            {{48, 95, -26}, {97, 114, 69}, {115, 115, 141}, {116, 122, 69}, },
            {{48, 114, -75}, {115, 115, 142}, {116, 122, 69}, },
            {{48, 110, -33}, {111, 111, 143}, {112, 122, 69}, },
            {{48, 100, -35}, {101, 101, 144}, {102, 122, 69}, },
            {{48, 115, -27}, {116, 116, 145}, {117, 122, 69}, },
            {{48, 114, -75}, {115, 115, 146}, {116, 116, 147}, {117, 122, 69}, },
            {{48, 95, -26}, {97, 97, 148}, {98, 122, 69}, },
            {{48, 95, -26}, {97, 97, 149}, {98, 122, 69}, },
            {{48, 95, -26}, {97, 109, 69}, {110, 110, 150}, {111, 122, 69}, },
            {{48, 101, -40}, {102, 102, 151}, {103, 122, 69}, },
            {{48, 95, -26}, {97, 116, 69}, {117, 117, 152}, {118, 122, 69}, },
            {{48, 114, -75}, {115, 115, 153}, {116, 122, 69}, },
            {{48, 116, -85}, {117, 117, 154}, {118, 122, 69}, },
            {{48, 115, -27}, {116, 116, 155}, {117, 122, 69}, },
            {{48, 107, -36}, {108, 108, 156}, {109, 122, 69}, },
            {{48, 109, -83}, {110, 110, 157}, {111, 122, 69}, },
            {{48, 110, -33}, {111, 111, 158}, {112, 122, 69}, },
            {{48, 113, -72}, {114, 114, 159}, {115, 122, 69}, },
            {{48, 115, -27}, {116, 116, 160}, {117, 122, 69}, },
            {{48, 122, -26}, },
            {{48, 95, -26}, {97, 111, 69}, {112, 112, 161}, {113, 122, 69}, },
            {{48, 114, -75}, {115, 115, 162}, {116, 116, 163}, {117, 122, 69}, },
            {{48, 109, -83}, {110, 110, 164}, {111, 122, 69}, },
            {{48, 115, -27}, {116, 116, 165}, {117, 122, 69}, },
            {{48, 95, -26}, {97, 118, 69}, {119, 119, 166}, {120, 122, 69}, },
            {{48, 107, -36}, {108, 108, 167}, {109, 122, 69}, },
            {{48, 95, -26}, {97, 98, 69}, {99, 99, 168}, {100, 122, 69}, },
            {{48, 95, -26}, {97, 104, 69}, {105, 105, 169}, {106, 110, 69}, {111, 111, 170}, {112, 122, 69}, },
            {{48, 97, -32}, {98, 98, 171}, {99, 122, 69}, },
            {{48, 115, -27}, {116, 116, 172}, {117, 122, 69}, },
            {{48, 110, -33}, {111, 111, 173}, {112, 122, 69}, },
            {{48, 95, -26}, {97, 97, 174}, {98, 113, 69}, {114, 114, 175}, {115, 122, 69}, },
            {{48, 111, -95}, {112, 112, 176}, {113, 122, 69}, },
            {{48, 104, -102}, {105, 105, 177}, {106, 122, 69}, },
            {{48, 109, -83}, {110, 110, 178}, {111, 122, 69}, },
            {{48, 104, -102}, {105, 105, 179}, {106, 113, 69}, {114, 114, 180}, {115, 122, 69}, },
            {{48, 95, -26}, {97, 97, 181}, {98, 116, 69}, {117, 117, 182}, {118, 120, 69}, {121, 121, 183}, {122, 122, 69}, },
            {{48, 104, -102}, {105, 105, 184}, {106, 107, 69}, {108, 108, 185}, {109, 122, 69}, },
            {{48, 104, -102}, {105, 105, 186}, {106, 122, 69}, },
            {},
            {{9, 127, -8}, },
            {{9, 127, -8}, },
            {{9, 127, -8}, },
            {{9, 127, -8}, },
            {{9, 127, -8}, },
            {{9, 127, -8}, },
            {{9, 127, -8}, },
            {{9, 127, -8}, },
            {{9, 127, -8}, },
            {},
            {{39, 39, 187}, },
            {{39, 39, 187}, },
            {{39, 39, 187}, },
            {{39, 39, 187}, },
            {{39, 39, 187}, },
            {{39, 39, 187}, },
            {{39, 39, 187}, },
            {{39, 39, 187}, },
            {{39, 39, 187}, },
            {{9, 127, -62}, },
            {{9, 127, -62}, },
            {{9, 9, 132}, {10, 10, 188}, {13, 127, -62}, },
            {{9, 9, 189}, {10, 10, 190}, {13, 13, 191}, {32, 41, 189}, {42, 42, 135}, {43, 46, 189}, {47, 47, 192}, {48, 127, 189}, },
            {{9, 127, -63}, },
            {},
            {{10, 10, 193}, },
            {{48, 57, 139}, },
            {{48, 104, -102}, {105, 105, 194}, {106, 122, 69}, },
            {{48, 115, -27}, {116, 116, 195}, {117, 122, 69}, },
            {{48, 100, -35}, {101, 101, 196}, {102, 122, 69}, },
            {{48, 107, -36}, {108, 108, 197}, {109, 122, 69}, },
            {{48, 95, -26}, {97, 97, 198}, {98, 122, 69}, },
            {{48, 100, -35}, {101, 101, 199}, {102, 122, 69}, },
            {{48, 100, -35}, {101, 101, 200}, {102, 122, 69}, },
            {{48, 98, -101}, {99, 99, 201}, {100, 122, 69}, },
            {{48, 113, -72}, {114, 114, 202}, {115, 122, 69}, },
            {{48, 114, -75}, {115, 115, 203}, {116, 122, 69}, },
            {{48, 114, -75}, {115, 115, 204}, {116, 116, 205}, {117, 122, 69}, },
            {{48, 95, -26}, {97, 97, 206}, {98, 122, 69}, },
            {{48, 97, -32}, {98, 98, 207}, {99, 122, 69}, },
            {{48, 100, -35}, {101, 101, 208}, {102, 122, 69}, },
            {{48, 95, -26}, {97, 108, 69}, {109, 109, 209}, {110, 122, 69}, },
            {{48, 100, -35}, {101, 101, 210}, {102, 122, 69}, },
            {{48, 114, -75}, {115, 115, 211}, {116, 122, 69}, },
            {{48, 95, -26}, {97, 97, 212}, {98, 122, 69}, },
            {{48, 95, -26}, {97, 97, 213}, {98, 122, 69}, },
            {{48, 122, -26}, },
            {{48, 110, -33}, {111, 111, 214}, {112, 122, 69}, },
            {{48, 107, -36}, {108, 108, 215}, {109, 110, 69}, {111, 111, 216}, {112, 122, 69}, },
            {{48, 115, -27}, {116, 116, 217}, {117, 122, 69}, },
            {{48, 100, -35}, {101, 101, 218}, {102, 122, 69}, },
            {{48, 95, -26}, {97, 102, 69}, {103, 103, 219}, {104, 122, 69}, },
            {{48, 104, -102}, {105, 105, 220}, {106, 122, 69}, },
            {{48, 122, -26}, },
            {{48, 107, -36}, {108, 108, 221}, {109, 122, 69}, },
            {{48, 95, -26}, {97, 106, 69}, {107, 107, 222}, {108, 122, 69}, },
            {{48, 95, -26}, {97, 117, 69}, {118, 118, 223}, {119, 122, 69}, },
            {{48, 115, -27}, {116, 116, 224}, {117, 122, 69}, },
            {{48, 107, -36}, {108, 108, 225}, {109, 122, 69}, },
            {{48, 116, -85}, {117, 117, 226}, {118, 122, 69}, },
            {{48, 113, -72}, {114, 114, 227}, {115, 122, 69}, },
            {{48, 115, -27}, {116, 116, 228}, {117, 122, 69}, },
            {{48, 104, -102}, {105, 105, 229}, {106, 122, 69}, },
            {{48, 100, -35}, {101, 101, 230}, {102, 122, 69}, },
            {{48, 115, -27}, {116, 116, 231}, {117, 122, 69}, },
            {{48, 98, -101}, {99, 99, 232}, {100, 122, 69}, },
            {{48, 114, -75}, {115, 115, 233}, {116, 122, 69}, },
            {{48, 110, -33}, {111, 111, 234}, {112, 122, 69}, },
            {{48, 109, -83}, {110, 110, 235}, {111, 122, 69}, },
            {{48, 100, -35}, {101, 101, 236}, {102, 122, 69}, },
            {{48, 122, -26}, },
            {{48, 95, -26}, {97, 99, 69}, {100, 100, 237}, {101, 122, 69}, },
            {{48, 95, -26}, {97, 97, 238}, {98, 122, 69}, },
            {{48, 107, -36}, {108, 108, 239}, {109, 122, 69}, },
            {},
            {{9, 127, -62}, },
            {{9, 9, 240}, {10, 10, 241}, {13, 13, 242}, {32, 41, 240}, {42, 42, 243}, {43, 127, 240}, },
            {{9, 127, -191}, },
            {{9, 9, 240}, {10, 10, 244}, {13, 127, -191}, },
            {},
            {},
            {{48, 109, -83}, {110, 110, 245}, {111, 122, 69}, },
            {{48, 113, -72}, {114, 114, 246}, {115, 122, 69}, },
            {{48, 113, -72}, {114, 114, 247}, {115, 122, 69}, },
            {{48, 100, -35}, {101, 101, 248}, {102, 122, 69}, },
            {{48, 106, -170}, {107, 107, 249}, {108, 122, 69}, },
            {{48, 122, -26}, },
            {{48, 122, -26}, },
            {{48, 103, -45}, {104, 104, 250}, {105, 122, 69}, },
            {{48, 122, -26}, },
            {{48, 114, -75}, {115, 115, 251}, {116, 122, 69}, },
            {{48, 115, -27}, {116, 116, 252}, {117, 122, 69}, },
            {{48, 104, -102}, {105, 105, 253}, {106, 122, 69}, },
            {{48, 116, -85}, {117, 117, 254}, {118, 122, 69}, },
            {{48, 107, -36}, {108, 108, 255}, {109, 122, 69}, },
            {{48, 122, -26}, },
            {{48, 122, -26}, },
            {{48, 109, -83}, {110, 110, 256}, {111, 122, 69}, },
            {{48, 100, -35}, {101, 101, 257}, {102, 122, 69}, },
            {{48, 107, -36}, {108, 108, 258}, {109, 122, 69}, },
            {{48, 115, -27}, {116, 116, 259}, {117, 122, 69}, },
            {{48, 122, -26}, },
            {{48, 100, -35}, {101, 101, 260}, {102, 122, 69}, },
            {{48, 113, -72}, {114, 114, 261}, {115, 122, 69}, },
            {{48, 95, -26}, {97, 97, 262}, {98, 122, 69}, },
            {{48, 113, -72}, {114, 114, 263}, {115, 122, 69}, },
            {{48, 122, -26}, },
            {{48, 117, -171}, {118, 118, 264}, {119, 122, 69}, },
            {{48, 122, -26}, },
            {{48, 95, -26}, {97, 97, 265}, {98, 122, 69}, },
            {{48, 95, -26}, {97, 97, 266}, {98, 122, 69}, },
            {{48, 100, -35}, {101, 101, 267}, {102, 122, 69}, },
            {{48, 104, -102}, {105, 105, 268}, {106, 122, 69}, },
            {{48, 113, -72}, {114, 114, 269}, {115, 122, 69}, },
            {{48, 115, -27}, {116, 116, 270}, {117, 122, 69}, },
            {{48, 104, -102}, {105, 105, 271}, {106, 122, 69}, },
            {{48, 98, -101}, {99, 99, 272}, {100, 122, 69}, },
            {{48, 113, -72}, {114, 114, 273}, {115, 122, 69}, },
            {{48, 98, -101}, {99, 99, 274}, {100, 122, 69}, },
            {{48, 103, -45}, {104, 104, 275}, {105, 122, 69}, },
            {{48, 122, -26}, },
            {{48, 118, -99}, {119, 119, 276}, {120, 122, 69}, },
            {{48, 114, -75}, {115, 115, 277}, {116, 122, 69}, },
            {{48, 122, -26}, },
            {{48, 122, -26}, },
            {{48, 115, -27}, {116, 116, 278}, {117, 122, 69}, },
            {{48, 100, -35}, {101, 101, 279}, {102, 122, 69}, },
            {{9, 127, -191}, },
            {{9, 127, -191}, },
            {{9, 9, 240}, {10, 10, 280}, {13, 127, -191}, },
            {{9, 41, -137}, {42, 42, 243}, {43, 127, -137}, },
            {{9, 127, -191}, },
            {{48, 102, -166}, {103, 103, 281}, {104, 122, 69}, },
            {{48, 95, -26}, {97, 97, 282}, {98, 122, 69}, },
            {{48, 115, -27}, {116, 116, 283}, {117, 122, 69}, },
            {{48, 95, -26}, {97, 97, 284}, {98, 122, 69}, },
            {{48, 122, -26}, },
            {{48, 122, -26}, },
            {{48, 122, -26}, },
            {{48, 122, -26}, },
            {{48, 109, -83}, {110, 110, 285}, {111, 122, 69}, },
            {{48, 107, -36}, {108, 108, 286}, {109, 122, 69}, },
            {{48, 100, -35}, {101, 101, 287}, {102, 122, 69}, },
            {{48, 99, -186}, {100, 100, 288}, {101, 122, 69}, },
            {{48, 122, -26}, },
            {{48, 107, -36}, {108, 108, 289}, {109, 122, 69}, },
            {{48, 122, -26}, },
            {{48, 108, -156}, {109, 109, 290}, {110, 122, 69}, },
            {{48, 115, -27}, {116, 116, 291}, {117, 122, 69}, },
            {{48, 109, -83}, {110, 110, 292}, {111, 122, 69}, },
            {{48, 101, -40}, {102, 102, 293}, {103, 122, 69}, },
            {{48, 100, -35}, {101, 101, 294}, {102, 122, 69}, },
            {{48, 102, -166}, {103, 103, 295}, {104, 122, 69}, },
            {{48, 115, -27}, {116, 116, 296}, {117, 122, 69}, },
            {{48, 98, -101}, {99, 99, 297}, {100, 122, 69}, },
            {{48, 98, -101}, {99, 99, 298}, {100, 122, 69}, },
            {{48, 109, -83}, {110, 110, 299}, {111, 122, 69}, },
            {{48, 122, -26}, },
            {{48, 98, -101}, {99, 99, 300}, {100, 122, 69}, },
            {{48, 115, -27}, {116, 116, 301}, {117, 122, 69}, },
            {{48, 122, -26}, },
            {{48, 103, -45}, {104, 104, 302}, {105, 122, 69}, },
            {{48, 113, -72}, {114, 114, 303}, {115, 122, 69}, },
            {{48, 114, -75}, {115, 115, 304}, {116, 122, 69}, },
            {{48, 104, -102}, {105, 105, 305}, {106, 122, 69}, },
            {{48, 104, -102}, {105, 105, 306}, {106, 122, 69}, },
            {{48, 122, -26}, },
            {{9, 127, -191}, },
            {{48, 122, -26}, },
            {{48, 98, -101}, {99, 99, 307}, {100, 122, 69}, },
            {{48, 122, -26}, },
            {{48, 109, -83}, {110, 110, 308}, {111, 122, 69}, },
            {{48, 116, -85}, {117, 117, 309}, {118, 122, 69}, },
            {{48, 115, -27}, {116, 116, 310}, {117, 122, 69}, },
            {{48, 122, -26}, },
            {{48, 114, -75}, {115, 115, 311}, {116, 122, 69}, },
            {{48, 95, -26}, {97, 120, 69}, {121, 121, 312}, {122, 122, 69}, },
            {{48, 100, -35}, {101, 101, 313}, {102, 122, 69}, },
            {{48, 122, -26}, },
            {{48, 98, -101}, {99, 99, 314}, {100, 122, 69}, },
            {{48, 95, -26}, {97, 97, 315}, {98, 122, 69}, },
            {{48, 122, -26}, },
            {{48, 100, -35}, {101, 101, 316}, {102, 122, 69}, },
            {{48, 100, -35}, {101, 101, 317}, {102, 122, 69}, },
            {{48, 115, -27}, {116, 116, 318}, {117, 122, 69}, },
            {{48, 122, -26}, },
            {{48, 122, -26}, },
            {{48, 122, -26}, },
            {{48, 101, -40}, {102, 102, 319}, {103, 122, 69}, },
            {{48, 122, -26}, },
            {{48, 110, -33}, {111, 111, 320}, {112, 122, 69}, },
            {{48, 122, -26}, },
            {{48, 100, -35}, {101, 101, 321}, {102, 122, 69}, },
            {{48, 107, -36}, {108, 108, 322}, {109, 122, 69}, },
            {{48, 115, -27}, {116, 116, 323}, {117, 122, 69}, },
            {{48, 122, -26}, },
            {{48, 100, -35}, {101, 101, 324}, {102, 122, 69}, },
            {{48, 122, -26}, },
            {{48, 122, -26}, },
            {{48, 122, -26}, },
            {{48, 109, -83}, {110, 110, 325}, {111, 122, 69}, },
            {{48, 100, -35}, {101, 101, 326}, {102, 122, 69}, },
            {{48, 98, -101}, {99, 99, 327}, {100, 122, 69}, },
            {{48, 122, -26}, },
            {{48, 122, -26}, },
            {{48, 100, -35}, {101, 101, 328}, {102, 122, 69}, },
            {{48, 111, -95}, {112, 112, 329}, {113, 122, 69}, },
            {{48, 109, -83}, {110, 110, 330}, {111, 122, 69}, },
            {{48, 109, -83}, {110, 110, 331}, {111, 122, 69}, },
            {{48, 100, -35}, {101, 101, 332}, {102, 122, 69}, },
            {{48, 122, -26}, },
            {{48, 122, -26}, },
            {{48, 115, -27}, {116, 116, 333}, {117, 122, 69}, },
            {{48, 110, -33}, {111, 111, 334}, {112, 122, 69}, },
            {{48, 100, -35}, {101, 101, 335}, {102, 122, 69}, },
            {{48, 99, -186}, {100, 100, 336}, {101, 122, 69}, },
            {{48, 122, -26}, },
            {{48, 104, -102}, {105, 105, 337}, {106, 122, 69}, },
            {{48, 115, -27}, {116, 116, 338}, {117, 122, 69}, },
            {{48, 122, -26}, },
            {{48, 114, -75}, {115, 115, 339}, {116, 122, 69}, },
            {{48, 101, -40}, {102, 102, 340}, {103, 122, 69}, },
            {{48, 122, -26}, },
            {{48, 122, -26}, },
            {{48, 95, -26}, {97, 121, 69}, {122, 122, 341}, },
            {{48, 122, -26}, },
            {{48, 122, -26}, },
            {{48, 122, -26}, },
            {{48, 100, -35}, {101, 101, 342}, {102, 122, 69}, },
            {{48, 99, -186}, {100, 100, 343}, {101, 122, 69}, },
            {{48, 122, -26}, },
        }
    };*/

    private static int[][] accept;
/*  {
        // INITIAL
        {-1, 2, 1, 1, 2, 31, -1, 52, -1, -1, 35, 36, 50, 46, 44, 48, 45, 51, 60, 43, 42, 53, 59, 55, 32, 32, 39, 40, 30, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 37, -1, 38, 1, 58, -1, 33, -1, 28, -1, -1, 47, 49, -1, 3, -1, 54, 57, 56, 32, 32, 32, 32, 32, -1, 41, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 13, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 29, -1, -1, -1, -1, -1, -1, -1, -1, -1, 34, -1, 34, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 3, 3, 3, 61, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 21, 32, 32, 32, 7, 32, 32, 23, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 0, 32, 32, 32, 34, -1, -1, -1, -1, 4, 3, 32, 32, 32, 32, 32, 0, 18, 32, 6, 32, 32, 32, 32, 32, 14, 24, 32, 32, 32, 32, 0, 32, 32, 32, 32, 0, 32, 27, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 0, 32, 32, 25, 10, 32, 32, -1, -1, -1, -1, -1, 32, 32, 32, 32, 19, 0, 11, 12, 32, 32, 32, 32, 26, 0, 0, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 0, 32, 32, 0, 32, 32, 0, 32, 32, 15, -1, 9, 32, 22, 32, 32, 32, 8, 32, 32, 32, 0, 32, 32, 0, 32, 32, 32, 0, 16, 0, 32, 17, 32, 0, 32, 32, 32, 5, 32, 20, 0, 0, 32, 32, 32, 0, 0, 32, 32, 32, 32, 32, 0, 0, 32, 32, 32, 32, 0, 32, 32, 0, 32, 32, 0, 0, 32, 0, 0, 0, 32, 32, 0, },

    };*/

    public static class State
    {
        public final static State INITIAL = new State(0);

        private int id;

        private State(int id)
        {
            this.id = id;
        }

        public int id()
        {
            return id;
        }
    }
}
