/* This file was generated by SableCC (http://www.sablecc.org/). */

package minijava.parser;

import minijava.lexer.*;
import minijava.node.*;
import minijava.analysis.*;
import java.util.*;

import java.io.DataInputStream;
import java.io.BufferedInputStream;
import java.io.IOException;

public class Parser
{
    public final Analysis ignoredTokens = new AnalysisAdapter();

    protected Node node;

    private final Lexer lexer;
    private final ListIterator stack = new LinkedList().listIterator();
    private int last_shift;
    private int last_pos;
    private int last_line;
    private Token last_token;
    private final TokenIndex converter = new TokenIndex();
    private final int[] action = new int[2];

    private final static int SHIFT = 0;
    private final static int REDUCE = 1;
    private final static int ACCEPT = 2;
    private final static int ERROR = 3;

    protected void filter() throws ParserException, LexerException, IOException
    {
    }

    public Parser(Lexer lexer)
    {
        this.lexer = lexer;

        if(actionTable == null)
        {
            try
            {
                DataInputStream s = new DataInputStream(
                    new BufferedInputStream(
                    Parser.class.getResourceAsStream("parser.dat")));

                // read actionTable
                int length = s.readInt();
                actionTable = new int[length][][];
                for(int i = 0; i < actionTable.length; i++)
                {
                    length = s.readInt();
                    actionTable[i] = new int[length][3];
                    for(int j = 0; j < actionTable[i].length; j++)
                    {
                        for(int k = 0; k < 3; k++)
                        {
                            actionTable[i][j][k] = s.readInt();
                        }
                    }
                }

                // read gotoTable
                length = s.readInt();
                gotoTable = new int[length][][];
                for(int i = 0; i < gotoTable.length; i++)
                {
                    length = s.readInt();
                    gotoTable[i] = new int[length][2];
                    for(int j = 0; j < gotoTable[i].length; j++)
                    {
                        for(int k = 0; k < 2; k++)
                        {
                            gotoTable[i][j][k] = s.readInt();
                        }
                    }
                }

                // read errorMessages
                length = s.readInt();
                errorMessages = new String[length];
                for(int i = 0; i < errorMessages.length; i++)
                {
                    length = s.readInt();
                    StringBuffer buffer = new StringBuffer();

                    for(int j = 0; j < length; j++)
                    {
                        buffer.append(s.readChar());
                    }
                    errorMessages[i] = buffer.toString();
                }

                // read errors
                length = s.readInt();
                errors = new int[length];
                for(int i = 0; i < errors.length; i++)
                {
                    errors[i] = s.readInt();
                }

                s.close();
            }
            catch(Exception e)
            {
                throw new RuntimeException("The file \"parser.dat\" is either missing or corrupted.");
            }
        }
    }

    private int goTo(int index)
    {
        int state = state();
        int low = 1;
        int high = gotoTable[index].length - 1;
        int value = gotoTable[index][0][1];

        while(low <= high)
        {
            int middle = (low + high) / 2;

            if(state < gotoTable[index][middle][0])
            {
                high = middle - 1;
            }
            else if(state > gotoTable[index][middle][0])
            {
                low = middle + 1;
            }
            else
            {
                value = gotoTable[index][middle][1];
                break;
            }
        }

        return value;
    }

    private void push(int state, Node node, boolean filter) throws ParserException, LexerException, IOException
    {
        this.node = node;

        if(filter)
        {
            filter();
        }

        if(!stack.hasNext())
        {
            stack.add(new State(state, this.node));
            return;
        }

        State s = (State) stack.next();
        s.state = state;
        s.node = this.node;
    }

    private int state()
    {
        State s = (State) stack.previous();
        stack.next();
        return s.state;
    }

    private Node pop()
    {
        return (Node) ((State) stack.previous()).node;
    }

    private int index(Switchable token)
    {
        converter.index = -1;
        token.apply(converter);
        return converter.index;
    }

    public Start parse() throws ParserException, LexerException, IOException
    {
        push(0, null, false);

        List ign = null;
        while(true)
        {
            while(index(lexer.peek()) == -1)
            {
                if(ign == null)
                {
                    ign = new TypedLinkedList(NodeCast.instance);
                }

                ign.add(lexer.next());
            }

            if(ign != null)
            {
                ignoredTokens.setIn(lexer.peek(), ign);
                ign = null;
            }

            last_pos = lexer.peek().getPos();
            last_line = lexer.peek().getLine();
            last_token = lexer.peek();

            int index = index(lexer.peek());
            action[0] = actionTable[state()][0][1];
            action[1] = actionTable[state()][0][2];

            int low = 1;
            int high = actionTable[state()].length - 1;

            while(low <= high)
            {
                int middle = (low + high) / 2;

                if(index < actionTable[state()][middle][0])
                {
                    high = middle - 1;
                }
                else if(index > actionTable[state()][middle][0])
                {
                    low = middle + 1;
                }
                else
                {
                    action[0] = actionTable[state()][middle][1];
                    action[1] = actionTable[state()][middle][2];
                    break;
                }
            }

            switch(action[0])
            {
                case SHIFT:
                    push(action[1], lexer.next(), true);
                    last_shift = action[1];
                    break;
                case REDUCE:
                    switch(action[1])
                    {
                    case 0: { Node node = new0(); push(goTo(0), node, true); } break;
                    case 1: { Node node = new1(); push(goTo(0), node, true); } break;
                    case 2: { Node node = new2(); push(goTo(1), node, true); } break;
                    case 3: { Node node = new3(); push(goTo(1), node, true); } break;
                    case 4: { Node node = new4(); push(goTo(2), node, true); } break;
                    case 5: { Node node = new5(); push(goTo(2), node, true); } break;
                    case 6: { Node node = new6(); push(goTo(2), node, true); } break;
                    case 7: { Node node = new7(); push(goTo(2), node, true); } break;
                    case 8: { Node node = new8(); push(goTo(2), node, true); } break;
                    case 9: { Node node = new9(); push(goTo(2), node, true); } break;
                    case 10: { Node node = new10(); push(goTo(2), node, true); } break;
                    case 11: { Node node = new11(); push(goTo(2), node, true); } break;
                    case 12: { Node node = new12(); push(goTo(2), node, true); } break;
                    case 13: { Node node = new13(); push(goTo(2), node, true); } break;
                    case 14: { Node node = new14(); push(goTo(2), node, true); } break;
                    case 15: { Node node = new15(); push(goTo(2), node, true); } break;
                    case 16: { Node node = new16(); push(goTo(2), node, true); } break;
                    case 17: { Node node = new17(); push(goTo(2), node, true); } break;
                    case 18: { Node node = new18(); push(goTo(3), node, true); } break;
                    case 19: { Node node = new19(); push(goTo(4), node, true); } break;
                    case 20: { Node node = new20(); push(goTo(4), node, true); } break;
                    case 21: { Node node = new21(); push(goTo(5), node, true); } break;
                    case 22: { Node node = new22(); push(goTo(5), node, true); } break;
                    case 23: { Node node = new23(); push(goTo(6), node, true); } break;
                    case 24: { Node node = new24(); push(goTo(6), node, true); } break;
                    case 25: { Node node = new25(); push(goTo(7), node, true); } break;
                    case 26: { Node node = new26(); push(goTo(8), node, true); } break;
                    case 27: { Node node = new27(); push(goTo(8), node, true); } break;
                    case 28: { Node node = new28(); push(goTo(9), node, true); } break;
                    case 29: { Node node = new29(); push(goTo(9), node, true); } break;
                    case 30: { Node node = new30(); push(goTo(9), node, true); } break;
                    case 31: { Node node = new31(); push(goTo(10), node, true); } break;
                    case 32: { Node node = new32(); push(goTo(11), node, true); } break;
                    case 33: { Node node = new33(); push(goTo(11), node, true); } break;
                    case 34: { Node node = new34(); push(goTo(12), node, true); } break;
                    case 35: { Node node = new35(); push(goTo(12), node, true); } break;
                    case 36: { Node node = new36(); push(goTo(13), node, true); } break;
                    case 37: { Node node = new37(); push(goTo(13), node, true); } break;
                    case 38: { Node node = new38(); push(goTo(60), node, false); } break;
                    case 39: { Node node = new39(); push(goTo(60), node, false); } break;
                    case 40: { Node node = new40(); push(goTo(14), node, true); } break;
                    case 41: { Node node = new41(); push(goTo(14), node, true); } break;
                    case 42: { Node node = new42(); push(goTo(15), node, true); } break;
                    case 43: { Node node = new43(); push(goTo(15), node, true); } break;
                    case 44: { Node node = new44(); push(goTo(15), node, true); } break;
                    case 45: { Node node = new45(); push(goTo(61), node, false); } break;
                    case 46: { Node node = new46(); push(goTo(61), node, false); } break;
                    case 47: { Node node = new47(); push(goTo(15), node, true); } break;
                    case 48: { Node node = new48(); push(goTo(16), node, true); } break;
                    case 49: { Node node = new49(); push(goTo(16), node, true); } break;
                    case 50: { Node node = new50(); push(goTo(16), node, true); } break;
                    case 51: { Node node = new51(); push(goTo(62), node, false); } break;
                    case 52: { Node node = new52(); push(goTo(62), node, false); } break;
                    case 53: { Node node = new53(); push(goTo(16), node, true); } break;
                    case 54: { Node node = new54(); push(goTo(16), node, true); } break;
                    case 55: { Node node = new55(); push(goTo(16), node, true); } break;
                    case 56: { Node node = new56(); push(goTo(16), node, true); } break;
                    case 57: { Node node = new57(); push(goTo(16), node, true); } break;
                    case 58: { Node node = new58(); push(goTo(16), node, true); } break;
                    case 59: { Node node = new59(); push(goTo(16), node, true); } break;
                    case 60: { Node node = new60(); push(goTo(16), node, true); } break;
                    case 61: { Node node = new61(); push(goTo(16), node, true); } break;
                    case 62: { Node node = new62(); push(goTo(16), node, true); } break;
                    case 63: { Node node = new63(); push(goTo(16), node, true); } break;
                    case 64: { Node node = new64(); push(goTo(17), node, true); } break;
                    case 65: { Node node = new65(); push(goTo(18), node, true); } break;
                    case 66: { Node node = new66(); push(goTo(18), node, true); } break;
                    case 67: { Node node = new67(); push(goTo(63), node, false); } break;
                    case 68: { Node node = new68(); push(goTo(63), node, false); } break;
                    case 69: { Node node = new69(); push(goTo(19), node, true); } break;
                    case 70: { Node node = new70(); push(goTo(19), node, true); } break;
                    case 71: { Node node = new71(); push(goTo(64), node, false); } break;
                    case 72: { Node node = new72(); push(goTo(64), node, false); } break;
                    case 73: { Node node = new73(); push(goTo(20), node, true); } break;
                    case 74: { Node node = new74(); push(goTo(21), node, true); } break;
                    case 75: { Node node = new75(); push(goTo(21), node, true); } break;
                    case 76: { Node node = new76(); push(goTo(22), node, true); } break;
                    case 77: { Node node = new77(); push(goTo(23), node, true); } break;
                    case 78: { Node node = new78(); push(goTo(24), node, true); } break;
                    case 79: { Node node = new79(); push(goTo(24), node, true); } break;
                    case 80: { Node node = new80(); push(goTo(24), node, true); } break;
                    case 81: { Node node = new81(); push(goTo(25), node, true); } break;
                    case 82: { Node node = new82(); push(goTo(26), node, true); } break;
                    case 83: { Node node = new83(); push(goTo(26), node, true); } break;
                    case 84: { Node node = new84(); push(goTo(65), node, false); } break;
                    case 85: { Node node = new85(); push(goTo(65), node, false); } break;
                    case 86: { Node node = new86(); push(goTo(26), node, true); } break;
                    case 87: { Node node = new87(); push(goTo(26), node, true); } break;
                    case 88: { Node node = new88(); push(goTo(66), node, false); } break;
                    case 89: { Node node = new89(); push(goTo(66), node, false); } break;
                    case 90: { Node node = new90(); push(goTo(27), node, true); } break;
                    case 91: { Node node = new91(); push(goTo(27), node, true); } break;
                    case 92: { Node node = new92(); push(goTo(28), node, true); } break;
                    case 93: { Node node = new93(); push(goTo(29), node, true); } break;
                    case 94: { Node node = new94(); push(goTo(30), node, true); } break;
                    case 95: { Node node = new95(); push(goTo(31), node, true); } break;
                    case 96: { Node node = new96(); push(goTo(31), node, true); } break;
                    case 97: { Node node = new97(); push(goTo(32), node, true); } break;
                    case 98: { Node node = new98(); push(goTo(32), node, true); } break;
                    case 99: { Node node = new99(); push(goTo(33), node, true); } break;
                    case 100: { Node node = new100(); push(goTo(33), node, true); } break;
                    case 101: { Node node = new101(); push(goTo(33), node, true); } break;
                    case 102: { Node node = new102(); push(goTo(33), node, true); } break;
                    case 103: { Node node = new103(); push(goTo(33), node, true); } break;
                    case 104: { Node node = new104(); push(goTo(33), node, true); } break;
                    case 105: { Node node = new105(); push(goTo(34), node, true); } break;
                    case 106: { Node node = new106(); push(goTo(34), node, true); } break;
                    case 107: { Node node = new107(); push(goTo(35), node, true); } break;
                    case 108: { Node node = new108(); push(goTo(36), node, true); } break;
                    case 109: { Node node = new109(); push(goTo(36), node, true); } break;
                    case 110: { Node node = new110(); push(goTo(36), node, true); } break;
                    case 111: { Node node = new111(); push(goTo(67), node, false); } break;
                    case 112: { Node node = new112(); push(goTo(67), node, false); } break;
                    case 113: { Node node = new113(); push(goTo(36), node, true); } break;
                    case 114: { Node node = new114(); push(goTo(37), node, true); } break;
                    case 115: { Node node = new115(); push(goTo(37), node, true); } break;
                    case 116: { Node node = new116(); push(goTo(38), node, true); } break;
                    case 117: { Node node = new117(); push(goTo(38), node, true); } break;
                    case 118: { Node node = new118(); push(goTo(39), node, true); } break;
                    case 119: { Node node = new119(); push(goTo(68), node, false); } break;
                    case 120: { Node node = new120(); push(goTo(68), node, false); } break;
                    case 121: { Node node = new121(); push(goTo(39), node, true); } break;
                    case 122: { Node node = new122(); push(goTo(40), node, true); } break;
                    case 123: { Node node = new123(); push(goTo(40), node, true); } break;
                    case 124: { Node node = new124(); push(goTo(40), node, true); } break;
                    case 125: { Node node = new125(); push(goTo(41), node, true); } break;
                    case 126: { Node node = new126(); push(goTo(41), node, true); } break;
                    case 127: { Node node = new127(); push(goTo(41), node, true); } break;
                    case 128: { Node node = new128(); push(goTo(41), node, true); } break;
                    case 129: { Node node = new129(); push(goTo(42), node, true); } break;
                    case 130: { Node node = new130(); push(goTo(42), node, true); } break;
                    case 131: { Node node = new131(); push(goTo(42), node, true); } break;
                    case 132: { Node node = new132(); push(goTo(42), node, true); } break;
                    case 133: { Node node = new133(); push(goTo(43), node, true); } break;
                    case 134: { Node node = new134(); push(goTo(43), node, true); } break;
                    case 135: { Node node = new135(); push(goTo(43), node, true); } break;
                    case 136: { Node node = new136(); push(goTo(43), node, true); } break;
                    case 137: { Node node = new137(); push(goTo(44), node, true); } break;
                    case 138: { Node node = new138(); push(goTo(45), node, true); } break;
                    case 139: { Node node = new139(); push(goTo(46), node, true); } break;
                    case 140: { Node node = new140(); push(goTo(47), node, true); } break;
                    case 141: { Node node = new141(); push(goTo(48), node, true); } break;
                    case 142: { Node node = new142(); push(goTo(49), node, true); } break;
                    case 143: { Node node = new143(); push(goTo(49), node, true); } break;
                    case 144: { Node node = new144(); push(goTo(49), node, true); } break;
                    case 145: { Node node = new145(); push(goTo(49), node, true); } break;
                    case 146: { Node node = new146(); push(goTo(49), node, true); } break;
                    case 147: { Node node = new147(); push(goTo(49), node, true); } break;
                    case 148: { Node node = new148(); push(goTo(49), node, true); } break;
                    case 149: { Node node = new149(); push(goTo(49), node, true); } break;
                    case 150: { Node node = new150(); push(goTo(50), node, true); } break;
                    case 151: { Node node = new151(); push(goTo(50), node, true); } break;
                    case 152: { Node node = new152(); push(goTo(51), node, true); } break;
                    case 153: { Node node = new153(); push(goTo(51), node, true); } break;
                    case 154: { Node node = new154(); push(goTo(51), node, true); } break;
                    case 155: { Node node = new155(); push(goTo(52), node, true); } break;
                    case 156: { Node node = new156(); push(goTo(52), node, true); } break;
                    case 157: { Node node = new157(); push(goTo(53), node, true); } break;
                    case 158: { Node node = new158(); push(goTo(53), node, true); } break;
                    case 159: { Node node = new159(); push(goTo(53), node, true); } break;
                    case 160: { Node node = new160(); push(goTo(54), node, true); } break;
                    case 161: { Node node = new161(); push(goTo(54), node, true); } break;
                    case 162: { Node node = new162(); push(goTo(54), node, true); } break;
                    case 163: { Node node = new163(); push(goTo(54), node, true); } break;
                    case 164: { Node node = new164(); push(goTo(54), node, true); } break;
                    case 165: { Node node = new165(); push(goTo(55), node, true); } break;
                    case 166: { Node node = new166(); push(goTo(55), node, true); } break;
                    case 167: { Node node = new167(); push(goTo(56), node, true); } break;
                    case 168: { Node node = new168(); push(goTo(56), node, true); } break;
                    case 169: { Node node = new169(); push(goTo(57), node, true); } break;
                    case 170: { Node node = new170(); push(goTo(58), node, true); } break;
                    case 171: { Node node = new171(); push(goTo(59), node, true); } break;
                    }
                    break;
                case ACCEPT:
                    {
                        EOF node2 = (EOF) lexer.next();
                        PDeclarations node1 = (PDeclarations) pop();
                        Start node = new Start(node1, node2);
                        return node;
                    }
                case ERROR:
                    throw new ParserException(last_token,
                        "[" + last_line + "," + last_pos + "] " +
                        errorMessages[errors[action[1]]]);
            }
        }
    }

    Node new0()
    {
        PDeclarations node2 = (PDeclarations) pop();
        PDeclaration node1 = (PDeclaration) pop();
        AListDeclarations node = new AListDeclarations(node1, node2);
        return node;
    }

    Node new1()
    {
        AEmptyDeclarations node = new AEmptyDeclarations();
        return node;
    }

    Node new2()
    {
        PStatements node2 = (PStatements) pop();
        PStatement node1 = (PStatement) pop();
        AListStatements node = new AListStatements(node1, node2);
        return node;
    }

    Node new3()
    {
        AEmptyStatements node = new AEmptyStatements();
        return node;
    }

    Node new4()
    {
        TSemicolon node2 = (TSemicolon) pop();
        PInnerDeclaration node1 = (PInnerDeclaration) pop();
        AInnerDecStatement node = new AInnerDecStatement(node1, node2);
        return node;
    }

    Node new5()
    {
        TSemicolon node2 = (TSemicolon) pop();
        PFunctionApplication node1 = (PFunctionApplication) pop();
        AFunctioncallStatement node = new AFunctioncallStatement(node1, node2);
        return node;
    }

    Node new6()
    {
        TSemicolon node2 = (TSemicolon) pop();
        PAssignment node1 = (PAssignment) pop();
        AAssignmentStatement node = new AAssignmentStatement(node1, node2);
        return node;
    }

    Node new7()
    {
        PIfStat node1 = (PIfStat) pop();
        AIfStatement node = new AIfStatement(node1);
        return node;
    }

    Node new8()
    {
        PBlock node5 = (PBlock) pop();
        TRParenthese node4 = (TRParenthese) pop();
        PBoolExpression node3 = (PBoolExpression) pop();
        TLParenthese node2 = (TLParenthese) pop();
        TWhile node1 = (TWhile) pop();
        AWhileStatement node = new AWhileStatement(node1, node2, node3, node4, node5);
        return node;
    }

    Node new9()
    {
        TSemicolon node3 = (TSemicolon) pop();
        PExpression node2 = null;
        TReturn node1 = (TReturn) pop();
        AReturnStatement node = new AReturnStatement(node1, node2, node3);
        return node;
    }

    Node new10()
    {
        TSemicolon node3 = (TSemicolon) pop();
        PExpression node2 = (PExpression) pop();
        TReturn node1 = (TReturn) pop();
        AReturnStatement node = new AReturnStatement(node1, node2, node3);
        return node;
    }

    Node new11()
    {
        PSwitchBlock node5 = (PSwitchBlock) pop();
        TRParenthese node4 = (TRParenthese) pop();
        PBoolExpression node3 = (PBoolExpression) pop();
        TLParenthese node2 = (TLParenthese) pop();
        TSwitch node1 = (TSwitch) pop();
        ASwitchStatement node = new ASwitchStatement(node1, node2, node3, node4, node5);
        return node;
    }

    Node new12()
    {
        PBlock node3 = (PBlock) pop();
        PForControl node2 = (PForControl) pop();
        TFor node1 = (TFor) pop();
        AForStatement node = new AForStatement(node1, node2, node3);
        return node;
    }

    Node new13()
    {
        TSemicolon node2 = (TSemicolon) pop();
        TBreak node1 = (TBreak) pop();
        ABreakStatement node = new ABreakStatement(node1, node2);
        return node;
    }

    Node new14()
    {
        PBlock node1 = (PBlock) pop();
        ABlockStatement node = new ABlockStatement(node1);
        return node;
    }

    Node new15()
    {
        TSemicolon node2 = (TSemicolon) pop();
        PForUnaryExp node1 = (PForUnaryExp) pop();
        AForUnaryStatement node = new AForUnaryStatement(node1, node2);
        return node;
    }

    Node new16()
    {
        TSemicolon node4 = (TSemicolon) pop();
        PColonString node3 = null;
        PBoolExpression node2 = (PBoolExpression) pop();
        TAssert node1 = (TAssert) pop();
        AAssertStatement node = new AAssertStatement(node1, node2, node3, node4);
        return node;
    }

    Node new17()
    {
        TSemicolon node4 = (TSemicolon) pop();
        PColonString node3 = (PColonString) pop();
        PBoolExpression node2 = (PBoolExpression) pop();
        TAssert node1 = (TAssert) pop();
        AAssertStatement node = new AAssertStatement(node1, node2, node3, node4);
        return node;
    }

    Node new18()
    {
        PElseFollow node2 = (PElseFollow) pop();
        TElse node1 = (TElse) pop();
        AElsePart node = new AElsePart(node1, node2);
        return node;
    }

    Node new19()
    {
        PBlock node1 = (PBlock) pop();
        ABlockElseFollow node = new ABlockElseFollow(node1);
        return node;
    }

    Node new20()
    {
        PIfStat node1 = (PIfStat) pop();
        AIfElseFollow node = new AIfElseFollow(node1);
        return node;
    }

    Node new21()
    {
        PElsePart node6 = null;
        PBlock node5 = (PBlock) pop();
        TRParenthese node4 = (TRParenthese) pop();
        PBoolExpression node3 = (PBoolExpression) pop();
        TLParenthese node2 = (TLParenthese) pop();
        TIf node1 = (TIf) pop();
        AIfStat node = new AIfStat(node1, node2, node3, node4, node5, node6);
        return node;
    }

    Node new22()
    {
        PElsePart node6 = (PElsePart) pop();
        PBlock node5 = (PBlock) pop();
        TRParenthese node4 = (TRParenthese) pop();
        PBoolExpression node3 = (PBoolExpression) pop();
        TLParenthese node2 = (TLParenthese) pop();
        TIf node1 = (TIf) pop();
        AIfStat node = new AIfStat(node1, node2, node3, node4, node5, node6);
        return node;
    }

    Node new23()
    {
        TRParenthese node7 = (TRParenthese) pop();
        PForRightStat node6 = null;
        TSemicolon node5 = (TSemicolon) pop();
        PBoolExpression node4 = (PBoolExpression) pop();
        TSemicolon node3 = (TSemicolon) pop();
        PForLeftStat node2 = (PForLeftStat) pop();
        TLParenthese node1 = (TLParenthese) pop();
        AJavaForControl node = new AJavaForControl(node1, node2, node3, node4, node5, node6, node7);
        return node;
    }

    Node new24()
    {
        TRParenthese node7 = (TRParenthese) pop();
        PForRightStat node6 = (PForRightStat) pop();
        TSemicolon node5 = (TSemicolon) pop();
        PBoolExpression node4 = (PBoolExpression) pop();
        TSemicolon node3 = (TSemicolon) pop();
        PForLeftStat node2 = (PForLeftStat) pop();
        TLParenthese node1 = (TLParenthese) pop();
        AJavaForControl node = new AJavaForControl(node1, node2, node3, node4, node5, node6, node7);
        return node;
    }

    Node new25()
    {
        PExpression node3 = (PExpression) pop();
        TAssign node2 = (TAssign) pop();
        PFieldAccess node1 = (PFieldAccess) pop();
        AAssignment node = new AAssignment(node1, node2, node3);
        return node;
    }

    Node new26()
    {
        PInnerDeclaration node1 = (PInnerDeclaration) pop();
        AInnerDecForLeftStat node = new AInnerDecForLeftStat(node1);
        return node;
    }

    Node new27()
    {
        PAssignment node1 = (PAssignment) pop();
        AAssignmentForLeftStat node = new AAssignmentForLeftStat(node1);
        return node;
    }

    Node new28()
    {
        PForUnaryExp node1 = (PForUnaryExp) pop();
        AUnaryForRightStat node = new AUnaryForRightStat(node1);
        return node;
    }

    Node new29()
    {
        PAssignment node1 = (PAssignment) pop();
        AAssignmentForRightStat node = new AAssignmentForRightStat(node1);
        return node;
    }

    Node new30()
    {
        PFunctionApplication node1 = (PFunctionApplication) pop();
        AFunctioncallForRightStat node = new AFunctioncallForRightStat(node1);
        return node;
    }

    Node new31()
    {
        TRBrace node3 = (TRBrace) pop();
        PStatements node2 = (PStatements) pop();
        TLBrace node1 = (TLBrace) pop();
        ABlock node = new ABlock(node1, node2, node3);
        return node;
    }

    Node new32()
    {
        TRParenthese node4 = (TRParenthese) pop();
        PActualParamList node3 = null;
        TLParenthese node2 = (TLParenthese) pop();
        PName node1 = (PName) pop();
        AFunctionApplication node = new AFunctionApplication(node1, node2, node3, node4);
        return node;
    }

    Node new33()
    {
        TRParenthese node4 = (TRParenthese) pop();
        PActualParamList node3 = (PActualParamList) pop();
        TLParenthese node2 = (TLParenthese) pop();
        PName node1 = (PName) pop();
        AFunctionApplication node = new AFunctionApplication(node1, node2, node3, node4);
        return node;
    }

    Node new34()
    {
        PExpression node3 = (PExpression) pop();
        TComma node2 = (TComma) pop();
        PActualParamList node1 = (PActualParamList) pop();
        AListActualParamList node = new AListActualParamList(node1, node2, node3);
        return node;
    }

    Node new35()
    {
        PExpression node1 = (PExpression) pop();
        AExpActualParamList node = new AExpActualParamList(node1);
        return node;
    }

    Node new36()
    {
        TRBrace node3 = (TRBrace) pop();
        XPPossibleCase node2 = null;
        TLBrace node1 = (TLBrace) pop();
        ASwitchBlock node = new ASwitchBlock(node1, node2, node3);
        return node;
    }

    Node new37()
    {
        TRBrace node3 = (TRBrace) pop();
        XPPossibleCase node2 = (XPPossibleCase) pop();
        TLBrace node1 = (TLBrace) pop();
        ASwitchBlock node = new ASwitchBlock(node1, node2, node3);
        return node;
    }

    Node new38()
    {
        PPossibleCase node2 = (PPossibleCase) pop();
        XPPossibleCase node1 = (XPPossibleCase) pop();
        X1PPossibleCase node = new X1PPossibleCase(node1, node2);
        return node;
    }

    Node new39()
    {
        PPossibleCase node1 = (PPossibleCase) pop();
        X2PPossibleCase node = new X2PPossibleCase(node1);
        return node;
    }

    Node new40()
    {
        PBlock node4 = (PBlock) pop();
        TColon node3 = (TColon) pop();
        PBoolExpression node2 = (PBoolExpression) pop();
        TCase node1 = (TCase) pop();
        ACasePossibleCase node = new ACasePossibleCase(node1, node2, node3, node4);
        return node;
    }

    Node new41()
    {
        PBlock node3 = (PBlock) pop();
        TColon node2 = (TColon) pop();
        TDefault node1 = (TDefault) pop();
        ADefaultPossibleCase node = new ADefaultPossibleCase(node1, node2, node3);
        return node;
    }

    Node new42()
    {
        PInitialiser node3 = null;
        TIdentifier node2 = (TIdentifier) pop();
        PType node1 = (PType) pop();
        AVarDecInnerDeclaration node = new AVarDecInnerDeclaration(node1, node2, node3);
        return node;
    }

    Node new43()
    {
        PInitialiser node3 = (PInitialiser) pop();
        TIdentifier node2 = (TIdentifier) pop();
        PType node1 = (PType) pop();
        AVarDecInnerDeclaration node = new AVarDecInnerDeclaration(node1, node2, node3);
        return node;
    }

    Node new44()
    {
        PArrayInitialiser node4 = null;
        TIdentifier node3 = (TIdentifier) pop();
        XTBracketPair node2 = (XTBracketPair) pop();
        PType node1 = (PType) pop();
        AArrayDecInnerDeclaration node = new AArrayDecInnerDeclaration(node1, node2, node3, node4);
        return node;
    }

    Node new45()
    {
        TBracketPair node2 = (TBracketPair) pop();
        XTBracketPair node1 = (XTBracketPair) pop();
        X1TBracketPair node = new X1TBracketPair(node1, node2);
        return node;
    }

    Node new46()
    {
        TBracketPair node1 = (TBracketPair) pop();
        X2TBracketPair node = new X2TBracketPair(node1);
        return node;
    }

    Node new47()
    {
        PArrayInitialiser node4 = (PArrayInitialiser) pop();
        TIdentifier node3 = (TIdentifier) pop();
        XTBracketPair node2 = (XTBracketPair) pop();
        PType node1 = (PType) pop();
        AArrayDecInnerDeclaration node = new AArrayDecInnerDeclaration(node1, node2, node3, node4);
        return node;
    }

    Node new48()
    {
        TRBrace node6 = (TRBrace) pop();
        XPClassInnerDeclaration node5 = null;
        TLBrace node4 = (TLBrace) pop();
        PTypeParam node3 = null;
        TIdentifier node2 = (TIdentifier) pop();
        TKlass node1 = (TKlass) pop();
        AClassDecDeclaration node = new AClassDecDeclaration(node1, node2, node3, node4, node5, node6);
        return node;
    }

    Node new49()
    {
        TRBrace node6 = (TRBrace) pop();
        XPClassInnerDeclaration node5 = null;
        TLBrace node4 = (TLBrace) pop();
        PTypeParam node3 = (PTypeParam) pop();
        TIdentifier node2 = (TIdentifier) pop();
        TKlass node1 = (TKlass) pop();
        AClassDecDeclaration node = new AClassDecDeclaration(node1, node2, node3, node4, node5, node6);
        return node;
    }

    Node new50()
    {
        TRBrace node6 = (TRBrace) pop();
        XPClassInnerDeclaration node5 = (XPClassInnerDeclaration) pop();
        TLBrace node4 = (TLBrace) pop();
        PTypeParam node3 = null;
        TIdentifier node2 = (TIdentifier) pop();
        TKlass node1 = (TKlass) pop();
        AClassDecDeclaration node = new AClassDecDeclaration(node1, node2, node3, node4, node5, node6);
        return node;
    }

    Node new51()
    {
        PClassInnerDeclaration node2 = (PClassInnerDeclaration) pop();
        XPClassInnerDeclaration node1 = (XPClassInnerDeclaration) pop();
        X1PClassInnerDeclaration node = new X1PClassInnerDeclaration(node1, node2);
        return node;
    }

    Node new52()
    {
        PClassInnerDeclaration node1 = (PClassInnerDeclaration) pop();
        X2PClassInnerDeclaration node = new X2PClassInnerDeclaration(node1);
        return node;
    }

    Node new53()
    {
        TRBrace node6 = (TRBrace) pop();
        XPClassInnerDeclaration node5 = (XPClassInnerDeclaration) pop();
        TLBrace node4 = (TLBrace) pop();
        PTypeParam node3 = (PTypeParam) pop();
        TIdentifier node2 = (TIdentifier) pop();
        TKlass node1 = (TKlass) pop();
        AClassDecDeclaration node = new AClassDecDeclaration(node1, node2, node3, node4, node5, node6);
        return node;
    }

    Node new54()
    {
        TRBrace node6 = (TRBrace) pop();
        TSemicolon node5 = (TSemicolon) pop();
        PEnumList node4 = (PEnumList) pop();
        TLBrace node3 = (TLBrace) pop();
        TIdentifier node2 = (TIdentifier) pop();
        TEnum node1 = (TEnum) pop();
        AEnumDecDeclaration node = new AEnumDecDeclaration(node1, node2, node3, node4, node5, node6);
        return node;
    }

    Node new55()
    {
        PBlock node8 = (PBlock) pop();
        TRParenthese node7 = (TRParenthese) pop();
        PFormalParamList node6 = null;
        TLParenthese node5 = (TLParenthese) pop();
        TIdentifier node4 = (TIdentifier) pop();
        XTBracketPair node3 = null;
        PType node2 = (PType) pop();
        PTypeParam node1 = null;
        AFuncDecDeclaration node = new AFuncDecDeclaration(node1, node2, node3, node4, node5, node6, node7, node8);
        return node;
    }

    Node new56()
    {
        PBlock node8 = (PBlock) pop();
        TRParenthese node7 = (TRParenthese) pop();
        PFormalParamList node6 = null;
        TLParenthese node5 = (TLParenthese) pop();
        TIdentifier node4 = (TIdentifier) pop();
        XTBracketPair node3 = null;
        PType node2 = (PType) pop();
        PTypeParam node1 = (PTypeParam) pop();
        AFuncDecDeclaration node = new AFuncDecDeclaration(node1, node2, node3, node4, node5, node6, node7, node8);
        return node;
    }

    Node new57()
    {
        PBlock node8 = (PBlock) pop();
        TRParenthese node7 = (TRParenthese) pop();
        PFormalParamList node6 = null;
        TLParenthese node5 = (TLParenthese) pop();
        TIdentifier node4 = (TIdentifier) pop();
        XTBracketPair node3 = (XTBracketPair) pop();
        PType node2 = (PType) pop();
        PTypeParam node1 = null;
        AFuncDecDeclaration node = new AFuncDecDeclaration(node1, node2, node3, node4, node5, node6, node7, node8);
        return node;
    }

    Node new58()
    {
        PBlock node8 = (PBlock) pop();
        TRParenthese node7 = (TRParenthese) pop();
        PFormalParamList node6 = null;
        TLParenthese node5 = (TLParenthese) pop();
        TIdentifier node4 = (TIdentifier) pop();
        XTBracketPair node3 = (XTBracketPair) pop();
        PType node2 = (PType) pop();
        PTypeParam node1 = (PTypeParam) pop();
        AFuncDecDeclaration node = new AFuncDecDeclaration(node1, node2, node3, node4, node5, node6, node7, node8);
        return node;
    }

    Node new59()
    {
        PBlock node8 = (PBlock) pop();
        TRParenthese node7 = (TRParenthese) pop();
        PFormalParamList node6 = (PFormalParamList) pop();
        TLParenthese node5 = (TLParenthese) pop();
        TIdentifier node4 = (TIdentifier) pop();
        XTBracketPair node3 = null;
        PType node2 = (PType) pop();
        PTypeParam node1 = null;
        AFuncDecDeclaration node = new AFuncDecDeclaration(node1, node2, node3, node4, node5, node6, node7, node8);
        return node;
    }

    Node new60()
    {
        PBlock node8 = (PBlock) pop();
        TRParenthese node7 = (TRParenthese) pop();
        PFormalParamList node6 = (PFormalParamList) pop();
        TLParenthese node5 = (TLParenthese) pop();
        TIdentifier node4 = (TIdentifier) pop();
        XTBracketPair node3 = null;
        PType node2 = (PType) pop();
        PTypeParam node1 = (PTypeParam) pop();
        AFuncDecDeclaration node = new AFuncDecDeclaration(node1, node2, node3, node4, node5, node6, node7, node8);
        return node;
    }

    Node new61()
    {
        PBlock node8 = (PBlock) pop();
        TRParenthese node7 = (TRParenthese) pop();
        PFormalParamList node6 = (PFormalParamList) pop();
        TLParenthese node5 = (TLParenthese) pop();
        TIdentifier node4 = (TIdentifier) pop();
        XTBracketPair node3 = (XTBracketPair) pop();
        PType node2 = (PType) pop();
        PTypeParam node1 = null;
        AFuncDecDeclaration node = new AFuncDecDeclaration(node1, node2, node3, node4, node5, node6, node7, node8);
        return node;
    }

    Node new62()
    {
        PBlock node8 = (PBlock) pop();
        TRParenthese node7 = (TRParenthese) pop();
        PFormalParamList node6 = (PFormalParamList) pop();
        TLParenthese node5 = (TLParenthese) pop();
        TIdentifier node4 = (TIdentifier) pop();
        XTBracketPair node3 = (XTBracketPair) pop();
        PType node2 = (PType) pop();
        PTypeParam node1 = (PTypeParam) pop();
        AFuncDecDeclaration node = new AFuncDecDeclaration(node1, node2, node3, node4, node5, node6, node7, node8);
        return node;
    }

    Node new63()
    {
        TSemicolon node5 = (TSemicolon) pop();
        PInitialiser node4 = (PInitialiser) pop();
        TIdentifier node3 = (TIdentifier) pop();
        PType node2 = (PType) pop();
        TConst node1 = (TConst) pop();
        AConstDecDeclaration node = new AConstDecDeclaration(node1, node2, node3, node4, node5);
        return node;
    }

    Node new64()
    {
        TSemicolon node2 = (TSemicolon) pop();
        PInnerDeclaration node1 = (PInnerDeclaration) pop();
        AClassInnerDeclaration node = new AClassInnerDeclaration(node1, node2);
        return node;
    }

    Node new65()
    {
        XPCommaTypeName node2 = null;
        PTypeName node1 = (PTypeName) pop();
        AFormalParamList node = new AFormalParamList(node1, node2);
        return node;
    }

    Node new66()
    {
        XPCommaTypeName node2 = (XPCommaTypeName) pop();
        PTypeName node1 = (PTypeName) pop();
        AFormalParamList node = new AFormalParamList(node1, node2);
        return node;
    }

    Node new67()
    {
        PCommaTypeName node2 = (PCommaTypeName) pop();
        XPCommaTypeName node1 = (XPCommaTypeName) pop();
        X1PCommaTypeName node = new X1PCommaTypeName(node1, node2);
        return node;
    }

    Node new68()
    {
        PCommaTypeName node1 = (PCommaTypeName) pop();
        X2PCommaTypeName node = new X2PCommaTypeName(node1);
        return node;
    }

    Node new69()
    {
        XPCommaEnumList node2 = null;
        TIdentifier node1 = (TIdentifier) pop();
        AEnumList node = new AEnumList(node1, node2);
        return node;
    }

    Node new70()
    {
        XPCommaEnumList node2 = (XPCommaEnumList) pop();
        TIdentifier node1 = (TIdentifier) pop();
        AEnumList node = new AEnumList(node1, node2);
        return node;
    }

    Node new71()
    {
        PCommaEnumList node2 = (PCommaEnumList) pop();
        XPCommaEnumList node1 = (XPCommaEnumList) pop();
        X1PCommaEnumList node = new X1PCommaEnumList(node1, node2);
        return node;
    }

    Node new72()
    {
        PCommaEnumList node1 = (PCommaEnumList) pop();
        X2PCommaEnumList node = new X2PCommaEnumList(node1);
        return node;
    }

    Node new73()
    {
        TIdentifier node2 = (TIdentifier) pop();
        TComma node1 = (TComma) pop();
        ACommaEnumList node = new ACommaEnumList(node1, node2);
        return node;
    }

    Node new74()
    {
        TIdentifier node3 = (TIdentifier) pop();
        XTBracketPair node2 = null;
        PType node1 = (PType) pop();
        ATypeName node = new ATypeName(node1, node2, node3);
        return node;
    }

    Node new75()
    {
        TIdentifier node3 = (TIdentifier) pop();
        XTBracketPair node2 = (XTBracketPair) pop();
        PType node1 = (PType) pop();
        ATypeName node = new ATypeName(node1, node2, node3);
        return node;
    }

    Node new76()
    {
        PTypeName node2 = (PTypeName) pop();
        TComma node1 = (TComma) pop();
        ACommaTypeName node = new ACommaTypeName(node1, node2);
        return node;
    }

    Node new77()
    {
        PBoolExpression node2 = (PBoolExpression) pop();
        TAssign node1 = (TAssign) pop();
        AInitialiser node = new AInitialiser(node1, node2);
        return node;
    }

    Node new78()
    {
        PArrayInit node2 = (PArrayInit) pop();
        TAssign node1 = (TAssign) pop();
        AStaticArrayInitialiser node = new AStaticArrayInitialiser(node1, node2);
        return node;
    }

    Node new79()
    {
        PArrayAllocate node2 = (PArrayAllocate) pop();
        TAssign node1 = (TAssign) pop();
        ADynamicArrayInitialiser node = new ADynamicArrayInitialiser(node1, node2);
        return node;
    }

    Node new80()
    {
        PInitialiser node1 = (PInitialiser) pop();
        ANormalArrayInitialiser node = new ANormalArrayInitialiser(node1);
        return node;
    }

    Node new81()
    {
        TRBrace node3 = (TRBrace) pop();
        PInitList node2 = (PInitList) pop();
        TLBrace node1 = (TLBrace) pop();
        AArrayInit node = new AArrayInit(node1, node2, node3);
        return node;
    }

    Node new82()
    {
        XPCommaExp node2 = null;
        PExpression node1 = (PExpression) pop();
        AScalarInitList node = new AScalarInitList(node1, node2);
        return node;
    }

    Node new83()
    {
        XPCommaExp node2 = (XPCommaExp) pop();
        PExpression node1 = (PExpression) pop();
        AScalarInitList node = new AScalarInitList(node1, node2);
        return node;
    }

    Node new84()
    {
        PCommaExp node2 = (PCommaExp) pop();
        XPCommaExp node1 = (XPCommaExp) pop();
        X1PCommaExp node = new X1PCommaExp(node1, node2);
        return node;
    }

    Node new85()
    {
        PCommaExp node1 = (PCommaExp) pop();
        X2PCommaExp node = new X2PCommaExp(node1);
        return node;
    }

    Node new86()
    {
        XPCommaArrayInit node2 = null;
        PArrayInit node1 = (PArrayInit) pop();
        AArrayInitList node = new AArrayInitList(node1, node2);
        return node;
    }

    Node new87()
    {
        XPCommaArrayInit node2 = (XPCommaArrayInit) pop();
        PArrayInit node1 = (PArrayInit) pop();
        AArrayInitList node = new AArrayInitList(node1, node2);
        return node;
    }

    Node new88()
    {
        PCommaArrayInit node2 = (PCommaArrayInit) pop();
        XPCommaArrayInit node1 = (XPCommaArrayInit) pop();
        X1PCommaArrayInit node = new X1PCommaArrayInit(node1, node2);
        return node;
    }

    Node new89()
    {
        PCommaArrayInit node1 = (PCommaArrayInit) pop();
        X2PCommaArrayInit node = new X2PCommaArrayInit(node1);
        return node;
    }

    Node new90()
    {
        PExpression node2 = (PExpression) pop();
        TComma node1 = (TComma) pop();
        AScalarCommaInitList node = new AScalarCommaInitList(node1, node2);
        return node;
    }

    Node new91()
    {
        PArrayInit node2 = (PArrayInit) pop();
        TComma node1 = (TComma) pop();
        AArrayCommaInitList node = new AArrayCommaInitList(node1, node2);
        return node;
    }

    Node new92()
    {
        PExpression node2 = (PExpression) pop();
        TComma node1 = (TComma) pop();
        ACommaExp node = new ACommaExp(node1, node2);
        return node;
    }

    Node new93()
    {
        PArrayInit node2 = (PArrayInit) pop();
        TComma node1 = (TComma) pop();
        ACommaArrayInit node = new ACommaArrayInit(node1, node2);
        return node;
    }

    Node new94()
    {
        PExpression node2 = (PExpression) pop();
        TColon node1 = (TColon) pop();
        AColonString node = new AColonString(node1, node2);
        return node;
    }

    Node new95()
    {
        TTrue node1 = (TTrue) pop();
        ATrueBooleanliteral node = new ATrueBooleanliteral(node1);
        return node;
    }

    Node new96()
    {
        TFalse node1 = (TFalse) pop();
        AFalseBooleanliteral node = new AFalseBooleanliteral(node1);
        return node;
    }

    Node new97()
    {
        PBasicType node1 = (PBasicType) pop();
        ABasicTypeType node = new ABasicTypeType(node1);
        return node;
    }

    Node new98()
    {
        PReferenceType node1 = (PReferenceType) pop();
        AReferenceTypeType node = new AReferenceTypeType(node1);
        return node;
    }

    Node new99()
    {
        TChar node1 = (TChar) pop();
        ACharBasicType node = new ACharBasicType(node1);
        return node;
    }

    Node new100()
    {
        TInt node1 = (TInt) pop();
        AIntBasicType node = new AIntBasicType(node1);
        return node;
    }

    Node new101()
    {
        TDouble node1 = (TDouble) pop();
        ADoubleBasicType node = new ADoubleBasicType(node1);
        return node;
    }

    Node new102()
    {
        TString node1 = (TString) pop();
        AStringBasicType node = new AStringBasicType(node1);
        return node;
    }

    Node new103()
    {
        TBoolean node1 = (TBoolean) pop();
        ABooleanBasicType node = new ABooleanBasicType(node1);
        return node;
    }

    Node new104()
    {
        TVoid node1 = (TVoid) pop();
        AVoidBasicType node = new AVoidBasicType(node1);
        return node;
    }

    Node new105()
    {
        PTypeParam node2 = null;
        TIdentifier node1 = (TIdentifier) pop();
        AClassTypeReferenceType node = new AClassTypeReferenceType(node1, node2);
        return node;
    }

    Node new106()
    {
        PTypeParam node2 = (PTypeParam) pop();
        TIdentifier node1 = (TIdentifier) pop();
        AClassTypeReferenceType node = new AClassTypeReferenceType(node1, node2);
        return node;
    }

    Node new107()
    {
        TGreater node3 = (TGreater) pop();
        PTypeParamList node2 = (PTypeParamList) pop();
        TLess node1 = (TLess) pop();
        ATypeParam node = new ATypeParam(node1, node2, node3);
        return node;
    }

    Node new108()
    {
        XPCommaType node3 = null;
        XTBracketPair node2 = null;
        PType node1 = (PType) pop();
        ATypeParamList node = new ATypeParamList(node1, node2, node3);
        return node;
    }

    Node new109()
    {
        XPCommaType node3 = null;
        XTBracketPair node2 = (XTBracketPair) pop();
        PType node1 = (PType) pop();
        ATypeParamList node = new ATypeParamList(node1, node2, node3);
        return node;
    }

    Node new110()
    {
        XPCommaType node3 = (XPCommaType) pop();
        XTBracketPair node2 = null;
        PType node1 = (PType) pop();
        ATypeParamList node = new ATypeParamList(node1, node2, node3);
        return node;
    }

    Node new111()
    {
        PCommaType node2 = (PCommaType) pop();
        XPCommaType node1 = (XPCommaType) pop();
        X1PCommaType node = new X1PCommaType(node1, node2);
        return node;
    }

    Node new112()
    {
        PCommaType node1 = (PCommaType) pop();
        X2PCommaType node = new X2PCommaType(node1);
        return node;
    }

    Node new113()
    {
        XPCommaType node3 = (XPCommaType) pop();
        XTBracketPair node2 = (XTBracketPair) pop();
        PType node1 = (PType) pop();
        ATypeParamList node = new ATypeParamList(node1, node2, node3);
        return node;
    }

    Node new114()
    {
        XTBracketPair node3 = null;
        PType node2 = (PType) pop();
        TComma node1 = (TComma) pop();
        ACommaType node = new ACommaType(node1, node2, node3);
        return node;
    }

    Node new115()
    {
        XTBracketPair node3 = (XTBracketPair) pop();
        PType node2 = (PType) pop();
        TComma node1 = (TComma) pop();
        ACommaType node = new ACommaType(node1, node2, node3);
        return node;
    }

    Node new116()
    {
        PBoolExpression node1 = (PBoolExpression) pop();
        ABoolexpExpression node = new ABoolexpExpression(node1);
        return node;
    }

    Node new117()
    {
        PArrayAllocate node1 = (PArrayAllocate) pop();
        AArrayIntExpression node = new AArrayIntExpression(node1);
        return node;
    }

    Node new118()
    {
        XTBracketPair node4 = null;
        XPArrayAccess node3 = (XPArrayAccess) pop();
        PType node2 = (PType) pop();
        TNew node1 = (TNew) pop();
        AArrayAllocate node = new AArrayAllocate(node1, node2, node3, node4);
        return node;
    }

    Node new119()
    {
        PArrayAccess node2 = (PArrayAccess) pop();
        XPArrayAccess node1 = (XPArrayAccess) pop();
        X1PArrayAccess node = new X1PArrayAccess(node1, node2);
        return node;
    }

    Node new120()
    {
        PArrayAccess node1 = (PArrayAccess) pop();
        X2PArrayAccess node = new X2PArrayAccess(node1);
        return node;
    }

    Node new121()
    {
        XTBracketPair node4 = (XTBracketPair) pop();
        XPArrayAccess node3 = (XPArrayAccess) pop();
        PType node2 = (PType) pop();
        TNew node1 = (TNew) pop();
        AArrayAllocate node = new AArrayAllocate(node1, node2, node3, node4);
        return node;
    }

    Node new122()
    {
        PTerm node1 = (PTerm) pop();
        ATermMathExpression node = new ATermMathExpression(node1);
        return node;
    }

    Node new123()
    {
        PTerm node3 = (PTerm) pop();
        TPlus node2 = (TPlus) pop();
        PMathExpression node1 = (PMathExpression) pop();
        APlusMathExpression node = new APlusMathExpression(node1, node2, node3);
        return node;
    }

    Node new124()
    {
        PTerm node3 = (PTerm) pop();
        TMinus node2 = (TMinus) pop();
        PMathExpression node1 = (PMathExpression) pop();
        AMinusMathExpression node = new AMinusMathExpression(node1, node2, node3);
        return node;
    }

    Node new125()
    {
        PUnaryExp node1 = (PUnaryExp) pop();
        AUnaryTerm node = new AUnaryTerm(node1);
        return node;
    }

    Node new126()
    {
        PUnaryExp node3 = (PUnaryExp) pop();
        TTimes node2 = (TTimes) pop();
        PTerm node1 = (PTerm) pop();
        AMultTerm node = new AMultTerm(node1, node2, node3);
        return node;
    }

    Node new127()
    {
        PUnaryExp node3 = (PUnaryExp) pop();
        TDivide node2 = (TDivide) pop();
        PTerm node1 = (PTerm) pop();
        ADivTerm node = new ADivTerm(node1, node2, node3);
        return node;
    }

    Node new128()
    {
        PUnaryExp node3 = (PUnaryExp) pop();
        TMod node2 = (TMod) pop();
        PTerm node1 = (PTerm) pop();
        AModTerm node = new AModTerm(node1, node2, node3);
        return node;
    }

    Node new129()
    {
        PUnaryExp node2 = (PUnaryExp) pop();
        TMinus node1 = (TMinus) pop();
        AMinusUnaryExp node = new AMinusUnaryExp(node1, node2);
        return node;
    }

    Node new130()
    {
        PUnaryExp node2 = (PUnaryExp) pop();
        TPlus node1 = (TPlus) pop();
        APlusUnaryExp node = new APlusUnaryExp(node1, node2);
        return node;
    }

    Node new131()
    {
        PUnaryExp node2 = (PUnaryExp) pop();
        TNot node1 = (TNot) pop();
        ANegateUnaryExp node = new ANegateUnaryExp(node1, node2);
        return node;
    }

    Node new132()
    {
        PPostfixExp node1 = (PPostfixExp) pop();
        APostfixExpUnaryExp node = new APostfixExpUnaryExp(node1);
        return node;
    }

    Node new133()
    {
        PPreincr node1 = (PPreincr) pop();
        APreincrForUnaryExp node = new APreincrForUnaryExp(node1);
        return node;
    }

    Node new134()
    {
        PPredecr node1 = (PPredecr) pop();
        APredecrForUnaryExp node = new APredecrForUnaryExp(node1);
        return node;
    }

    Node new135()
    {
        PPostincr node1 = (PPostincr) pop();
        APostincrForUnaryExp node = new APostincrForUnaryExp(node1);
        return node;
    }

    Node new136()
    {
        PPostdecr node1 = (PPostdecr) pop();
        APostdecrForUnaryExp node = new APostdecrForUnaryExp(node1);
        return node;
    }

    Node new137()
    {
        PFactor node1 = (PFactor) pop();
        AFactorPostfixExp node = new AFactorPostfixExp(node1);
        return node;
    }

    Node new138()
    {
        TMinusminus node2 = (TMinusminus) pop();
        PFieldAccess node1 = (PFieldAccess) pop();
        APostdecr node = new APostdecr(node1, node2);
        return node;
    }

    Node new139()
    {
        TPlusplus node2 = (TPlusplus) pop();
        PFieldAccess node1 = (PFieldAccess) pop();
        APostincr node = new APostincr(node1, node2);
        return node;
    }

    Node new140()
    {
        PFieldAccess node2 = (PFieldAccess) pop();
        TMinusminus node1 = (TMinusminus) pop();
        APredecr node = new APredecr(node1, node2);
        return node;
    }

    Node new141()
    {
        PFieldAccess node2 = (PFieldAccess) pop();
        TPlusplus node1 = (TPlusplus) pop();
        APreincr node = new APreincr(node1, node2);
        return node;
    }

    Node new142()
    {
        TNull node1 = (TNull) pop();
        ANullFactor node = new ANullFactor(node1);
        return node;
    }

    Node new143()
    {
        PFieldAccess node1 = (PFieldAccess) pop();
        AFieldaccessFactor node = new AFieldaccessFactor(node1);
        return node;
    }

    Node new144()
    {
        PFunctionApplication node1 = (PFunctionApplication) pop();
        AFunctionFactor node = new AFunctionFactor(node1);
        return node;
    }

    Node new145()
    {
        PNumber node1 = (PNumber) pop();
        ANumberFactor node = new ANumberFactor(node1);
        return node;
    }

    Node new146()
    {
        TStringliteral node1 = (TStringliteral) pop();
        AStringliteralFactor node = new AStringliteralFactor(node1);
        return node;
    }

    Node new147()
    {
        TCharliteral node1 = (TCharliteral) pop();
        ACharliteralFactor node = new ACharliteralFactor(node1);
        return node;
    }

    Node new148()
    {
        PBooleanliteral node1 = (PBooleanliteral) pop();
        ABoolliteralFactor node = new ABoolliteralFactor(node1);
        return node;
    }

    Node new149()
    {
        TRParenthese node3 = (TRParenthese) pop();
        PBoolExpression node2 = (PBoolExpression) pop();
        TLParenthese node1 = (TLParenthese) pop();
        AExpressionFactor node = new AExpressionFactor(node1, node2, node3);
        return node;
    }

    Node new150()
    {
        TIntnumber node1 = (TIntnumber) pop();
        AINumber node = new AINumber(node1);
        return node;
    }

    Node new151()
    {
        TDpnumber node1 = (TDpnumber) pop();
        ADNumber node = new ADNumber(node1);
        return node;
    }

    Node new152()
    {
        PBoolTerm node1 = (PBoolTerm) pop();
        ATermBoolExpression node = new ATermBoolExpression(node1);
        return node;
    }

    Node new153()
    {
        PBoolTerm node3 = (PBoolTerm) pop();
        TOr node2 = (TOr) pop();
        PBoolExpression node1 = (PBoolExpression) pop();
        AOrBoolExpression node = new AOrBoolExpression(node1, node2, node3);
        return node;
    }

    Node new154()
    {
        PBoolTerm node3 = (PBoolTerm) pop();
        TXor node2 = (TXor) pop();
        PBoolExpression node1 = (PBoolExpression) pop();
        AXorBoolExpression node = new AXorBoolExpression(node1, node2, node3);
        return node;
    }

    Node new155()
    {
        PEquality node1 = (PEquality) pop();
        AEqualityBoolTerm node = new AEqualityBoolTerm(node1);
        return node;
    }

    Node new156()
    {
        PEquality node3 = (PEquality) pop();
        TAnd node2 = (TAnd) pop();
        PBoolTerm node1 = (PBoolTerm) pop();
        AAndBoolTerm node = new AAndBoolTerm(node1, node2, node3);
        return node;
    }

    Node new157()
    {
        PRelational node1 = (PRelational) pop();
        ARelationalEquality node = new ARelationalEquality(node1);
        return node;
    }

    Node new158()
    {
        PRelational node3 = (PRelational) pop();
        TEqual node2 = (TEqual) pop();
        PEquality node1 = (PEquality) pop();
        AEqEquality node = new AEqEquality(node1, node2, node3);
        return node;
    }

    Node new159()
    {
        PRelational node3 = (PRelational) pop();
        TNotequal node2 = (TNotequal) pop();
        PEquality node1 = (PEquality) pop();
        ANeqEquality node = new ANeqEquality(node1, node2, node3);
        return node;
    }

    Node new160()
    {
        PMathExpression node1 = (PMathExpression) pop();
        AMathRelational node = new AMathRelational(node1);
        return node;
    }

    Node new161()
    {
        PMathExpression node3 = (PMathExpression) pop();
        TLess node2 = (TLess) pop();
        PRelational node1 = (PRelational) pop();
        ALtRelational node = new ALtRelational(node1, node2, node3);
        return node;
    }

    Node new162()
    {
        PMathExpression node3 = (PMathExpression) pop();
        TGreater node2 = (TGreater) pop();
        PRelational node1 = (PRelational) pop();
        AGtRelational node = new AGtRelational(node1, node2, node3);
        return node;
    }

    Node new163()
    {
        PMathExpression node3 = (PMathExpression) pop();
        TLessequal node2 = (TLessequal) pop();
        PRelational node1 = (PRelational) pop();
        ALteqRelational node = new ALteqRelational(node1, node2, node3);
        return node;
    }

    Node new164()
    {
        PMathExpression node3 = (PMathExpression) pop();
        TGreaterequal node2 = (TGreaterequal) pop();
        PRelational node1 = (PRelational) pop();
        AGteqRelational node = new AGteqRelational(node1, node2, node3);
        return node;
    }

    Node new165()
    {
        XPArrayAccess node2 = (XPArrayAccess) pop();
        PName node1 = (PName) pop();
        AArrayFieldAccess node = new AArrayFieldAccess(node1, node2);
        return node;
    }

    Node new166()
    {
        PName node1 = (PName) pop();
        AScalarFieldAccess node = new AScalarFieldAccess(node1);
        return node;
    }

    Node new167()
    {
        PSimpleName node1 = (PSimpleName) pop();
        ASimpleNameName node = new ASimpleNameName(node1);
        return node;
    }

    Node new168()
    {
        PQualifiedName node1 = (PQualifiedName) pop();
        AQualifiedNameName node = new AQualifiedNameName(node1);
        return node;
    }

    Node new169()
    {
        TIdentifier node1 = (TIdentifier) pop();
        ASimpleName node = new ASimpleName(node1);
        return node;
    }

    Node new170()
    {
        TIdentifier node3 = (TIdentifier) pop();
        TDot node2 = (TDot) pop();
        PFieldAccess node1 = (PFieldAccess) pop();
        AQualifiedName node = new AQualifiedName(node1, node2, node3);
        return node;
    }

    Node new171()
    {
        TRBracket node3 = (TRBracket) pop();
        PMathExpression node2 = (PMathExpression) pop();
        TLBracket node1 = (TLBracket) pop();
        AArrayAccess node = new AArrayAccess(node1, node2, node3);
        return node;
    }

    private static int[][][] actionTable;
/*      {
			{{-1, REDUCE, 1}, {1, SHIFT, 1}, {2, SHIFT, 2}, {3, SHIFT, 3}, {4, SHIFT, 4}, {5, SHIFT, 5}, {6, SHIFT, 6}, {7, SHIFT, 7}, {8, SHIFT, 8}, {20, SHIFT, 9}, {28, SHIFT, 10}, {49, SHIFT, 11}, },
			{{-1, REDUCE, 103}, },
			{{-1, REDUCE, 99}, },
			{{-1, REDUCE, 100}, },
			{{-1, REDUCE, 101}, },
			{{-1, REDUCE, 102}, },
			{{-1, REDUCE, 104}, },
			{{-1, ERROR, 7}, {28, SHIFT, 18}, },
			{{-1, ERROR, 8}, {1, SHIFT, 1}, {2, SHIFT, 2}, {3, SHIFT, 3}, {4, SHIFT, 4}, {5, SHIFT, 5}, {6, SHIFT, 6}, {28, SHIFT, 10}, },
			{{-1, ERROR, 9}, {28, SHIFT, 20}, },
			{{-1, REDUCE, 105}, {49, SHIFT, 11}, },
			{{-1, ERROR, 11}, {1, SHIFT, 1}, {2, SHIFT, 2}, {3, SHIFT, 3}, {4, SHIFT, 4}, {5, SHIFT, 5}, {6, SHIFT, 6}, {28, SHIFT, 10}, },
			{{-1, ERROR, 12}, {58, ACCEPT, -1}, },
			{{-1, REDUCE, 1}, {1, SHIFT, 1}, {2, SHIFT, 2}, {3, SHIFT, 3}, {4, SHIFT, 4}, {5, SHIFT, 5}, {6, SHIFT, 6}, {7, SHIFT, 7}, {8, SHIFT, 8}, {20, SHIFT, 9}, {28, SHIFT, 10}, {49, SHIFT, 11}, },
			{{-1, ERROR, 14}, {28, SHIFT, 25}, {37, SHIFT, 26}, },
			{{-1, REDUCE, 97}, },
			{{-1, REDUCE, 98}, },
			{{-1, ERROR, 17}, {1, SHIFT, 1}, {2, SHIFT, 2}, {3, SHIFT, 3}, {4, SHIFT, 4}, {5, SHIFT, 5}, {6, SHIFT, 6}, {28, SHIFT, 10}, },
			{{-1, ERROR, 18}, {33, SHIFT, 29}, {49, SHIFT, 11}, },
			{{-1, ERROR, 19}, {28, SHIFT, 31}, },
			{{-1, ERROR, 20}, {33, SHIFT, 32}, },
			{{-1, REDUCE, 106}, },
			{{-1, REDUCE, 108}, {37, SHIFT, 26}, {40, SHIFT, 33}, },
			{{-1, ERROR, 23}, {51, SHIFT, 37}, },
			{{-1, REDUCE, 0}, },
			{{-1, ERROR, 25}, {31, SHIFT, 38}, },
			{{-1, REDUCE, 46}, },
			{{-1, ERROR, 27}, {28, SHIFT, 39}, {37, SHIFT, 40}, },
			{{-1, ERROR, 28}, {28, SHIFT, 41}, {37, SHIFT, 26}, },
			{{-1, ERROR, 29}, {1, SHIFT, 1}, {2, SHIFT, 2}, {3, SHIFT, 3}, {4, SHIFT, 4}, {5, SHIFT, 5}, {6, SHIFT, 6}, {28, SHIFT, 10}, {34, SHIFT, 43}, },
			{{-1, ERROR, 30}, {33, SHIFT, 48}, },
			{{-1, ERROR, 31}, {55, SHIFT, 49}, },
			{{-1, ERROR, 32}, {28, SHIFT, 51}, },
			{{-1, ERROR, 33}, {1, SHIFT, 1}, {2, SHIFT, 2}, {3, SHIFT, 3}, {4, SHIFT, 4}, {5, SHIFT, 5}, {6, SHIFT, 6}, {28, SHIFT, 10}, },
			{{-1, REDUCE, 112}, },
			{{-1, REDUCE, 109}, {37, SHIFT, 40}, {40, SHIFT, 33}, },
			{{-1, REDUCE, 110}, {40, SHIFT, 33}, },
			{{-1, REDUCE, 107}, },
			{{-1, ERROR, 38}, {1, SHIFT, 1}, {2, SHIFT, 2}, {3, SHIFT, 3}, {4, SHIFT, 4}, {5, SHIFT, 5}, {6, SHIFT, 6}, {28, SHIFT, 10}, {32, SHIFT, 56}, },
			{{-1, ERROR, 39}, {31, SHIFT, 60}, },
			{{-1, REDUCE, 45}, },
			{{-1, ERROR, 41}, {31, SHIFT, 61}, },
			{{-1, ERROR, 42}, {28, SHIFT, 62}, {37, SHIFT, 40}, },
			{{-1, REDUCE, 48}, },
			{{-1, ERROR, 44}, {38, SHIFT, 63}, },
			{{-1, REDUCE, 52}, },
			{{-1, ERROR, 46}, {28, SHIFT, 64}, {37, SHIFT, 26}, },
			{{-1, ERROR, 47}, {1, SHIFT, 1}, {2, SHIFT, 2}, {3, SHIFT, 3}, {4, SHIFT, 4}, {5, SHIFT, 5}, {6, SHIFT, 6}, {28, SHIFT, 10}, {34, SHIFT, 66}, },
			{{-1, ERROR, 48}, {1, SHIFT, 1}, {2, SHIFT, 2}, {3, SHIFT, 3}, {4, SHIFT, 4}, {5, SHIFT, 5}, {6, SHIFT, 6}, {28, SHIFT, 10}, {34, SHIFT, 68}, },
			{{-1, ERROR, 49}, {21, SHIFT, 70}, {22, SHIFT, 71}, {23, SHIFT, 72}, {27, SHIFT, 73}, {28, SHIFT, 74}, {29, SHIFT, 75}, {30, SHIFT, 76}, {31, SHIFT, 77}, {42, SHIFT, 78}, {44, SHIFT, 79}, {56, SHIFT, 80}, {57, SHIFT, 81}, },
			{{-1, ERROR, 50}, {38, SHIFT, 98}, },
			{{-1, REDUCE, 69}, {40, SHIFT, 99}, },
			{{-1, ERROR, 52}, {38, SHIFT, 102}, },
			{{-1, REDUCE, 114}, {37, SHIFT, 26}, },
			{{-1, REDUCE, 113}, {40, SHIFT, 33}, },
			{{-1, REDUCE, 111}, },
			{{-1, ERROR, 56}, {33, SHIFT, 104}, },
			{{-1, ERROR, 57}, {32, SHIFT, 106}, },
			{{-1, REDUCE, 65}, {40, SHIFT, 107}, },
			{{-1, ERROR, 59}, {28, SHIFT, 110}, {37, SHIFT, 26}, },
			{{-1, ERROR, 60}, {1, SHIFT, 1}, {2, SHIFT, 2}, {3, SHIFT, 3}, {4, SHIFT, 4}, {5, SHIFT, 5}, {6, SHIFT, 6}, {28, SHIFT, 10}, {32, SHIFT, 112}, },
			{{-1, ERROR, 61}, {1, SHIFT, 1}, {2, SHIFT, 2}, {3, SHIFT, 3}, {4, SHIFT, 4}, {5, SHIFT, 5}, {6, SHIFT, 6}, {28, SHIFT, 10}, {32, SHIFT, 114}, },
			{{-1, ERROR, 62}, {31, SHIFT, 116}, },
			{{-1, REDUCE, 64}, },
			{{-1, REDUCE, 42}, {55, SHIFT, 49}, },
			{{-1, ERROR, 65}, {28, SHIFT, 118}, {37, SHIFT, 40}, },
			{{-1, REDUCE, 50}, },
			{{-1, REDUCE, 51}, },
			{{-1, REDUCE, 49}, },
			{{-1, ERROR, 69}, {1, SHIFT, 1}, {2, SHIFT, 2}, {3, SHIFT, 3}, {4, SHIFT, 4}, {5, SHIFT, 5}, {6, SHIFT, 6}, {28, SHIFT, 10}, {34, SHIFT, 119}, },
			{{-1, REDUCE, 95}, },
			{{-1, REDUCE, 96}, },
			{{-1, REDUCE, 142}, },
			{{-1, ERROR, 73}, {21, SHIFT, 70}, {22, SHIFT, 71}, {23, SHIFT, 72}, {27, SHIFT, 73}, {28, SHIFT, 74}, {29, SHIFT, 75}, {30, SHIFT, 76}, {31, SHIFT, 77}, {42, SHIFT, 78}, {44, SHIFT, 79}, {56, SHIFT, 80}, {57, SHIFT, 81}, },
			{{-1, REDUCE, 169}, },
			{{-1, REDUCE, 146}, },
			{{-1, REDUCE, 147}, },
			{{-1, ERROR, 77}, {21, SHIFT, 70}, {22, SHIFT, 71}, {23, SHIFT, 72}, {27, SHIFT, 73}, {28, SHIFT, 74}, {29, SHIFT, 75}, {30, SHIFT, 76}, {31, SHIFT, 77}, {42, SHIFT, 78}, {44, SHIFT, 79}, {56, SHIFT, 80}, {57, SHIFT, 81}, },
			{{-1, ERROR, 78}, {21, SHIFT, 70}, {22, SHIFT, 71}, {23, SHIFT, 72}, {27, SHIFT, 73}, {28, SHIFT, 74}, {29, SHIFT, 75}, {30, SHIFT, 76}, {31, SHIFT, 77}, {42, SHIFT, 78}, {44, SHIFT, 79}, {56, SHIFT, 80}, {57, SHIFT, 81}, },
			{{-1, ERROR, 79}, {21, SHIFT, 70}, {22, SHIFT, 71}, {23, SHIFT, 72}, {27, SHIFT, 73}, {28, SHIFT, 74}, {29, SHIFT, 75}, {30, SHIFT, 76}, {31, SHIFT, 77}, {42, SHIFT, 78}, {44, SHIFT, 79}, {56, SHIFT, 80}, {57, SHIFT, 81}, },
			{{-1, REDUCE, 150}, },
			{{-1, REDUCE, 151}, },
			{{-1, REDUCE, 144}, },
			{{-1, REDUCE, 148}, },
			{{-1, REDUCE, 160}, {42, SHIFT, 124}, {44, SHIFT, 125}, },
			{{-1, REDUCE, 122}, {46, SHIFT, 126}, {47, SHIFT, 127}, {48, SHIFT, 128}, },
			{{-1, REDUCE, 125}, },
			{{-1, REDUCE, 132}, },
			{{-1, REDUCE, 137}, },
			{{-1, REDUCE, 145}, },
			{{-1, REDUCE, 77}, {25, SHIFT, 129}, {26, SHIFT, 130}, },
			{{-1, REDUCE, 152}, {24, SHIFT, 131}, },
			{{-1, REDUCE, 155}, {53, SHIFT, 132}, {54, SHIFT, 133}, },
			{{-1, REDUCE, 157}, {49, SHIFT, 134}, {50, SHIFT, 135}, {51, SHIFT, 136}, {52, SHIFT, 137}, },
			{{-1, REDUCE, 143}, {41, SHIFT, 138}, },
			{{-1, REDUCE, 166}, {31, SHIFT, 139}, {35, SHIFT, 140}, },
			{{-1, REDUCE, 167}, },
			{{-1, REDUCE, 168}, },
			{{-1, REDUCE, 63}, },
			{{-1, ERROR, 99}, {28, SHIFT, 143}, },
			{{-1, REDUCE, 72}, },
			{{-1, REDUCE, 70}, {40, SHIFT, 99}, },
			{{-1, ERROR, 102}, {34, SHIFT, 145}, },
			{{-1, REDUCE, 115}, {37, SHIFT, 40}, },
			{{-1, REDUCE, 3}, {1, SHIFT, 1}, {2, SHIFT, 2}, {3, SHIFT, 3}, {4, SHIFT, 4}, {5, SHIFT, 5}, {6, SHIFT, 6}, {9, SHIFT, 146}, {11, SHIFT, 147}, {12, SHIFT, 148}, {13, SHIFT, 149}, {15, SHIFT, 150}, {17, SHIFT, 151}, {18, SHIFT, 152}, {28, SHIFT, 153}, {33, SHIFT, 104}, {43, SHIFT, 154}, {45, SHIFT, 155}, },
			{{-1, REDUCE, 55}, },
			{{-1, ERROR, 106}, {33, SHIFT, 104}, },
			{{-1, ERROR, 107}, {1, SHIFT, 1}, {2, SHIFT, 2}, {3, SHIFT, 3}, {4, SHIFT, 4}, {5, SHIFT, 5}, {6, SHIFT, 6}, {28, SHIFT, 10}, },
			{{-1, REDUCE, 68}, },
			{{-1, REDUCE, 66}, {40, SHIFT, 107}, },
			{{-1, REDUCE, 74}, },
			{{-1, ERROR, 111}, {28, SHIFT, 172}, {37, SHIFT, 40}, },
			{{-1, ERROR, 112}, {33, SHIFT, 104}, },
			{{-1, ERROR, 113}, {32, SHIFT, 174}, },
			{{-1, ERROR, 114}, {33, SHIFT, 104}, },
			{{-1, ERROR, 115}, {32, SHIFT, 176}, },
			{{-1, ERROR, 116}, {1, SHIFT, 1}, {2, SHIFT, 2}, {3, SHIFT, 3}, {4, SHIFT, 4}, {5, SHIFT, 5}, {6, SHIFT, 6}, {28, SHIFT, 10}, {32, SHIFT, 177}, },
			{{-1, REDUCE, 43}, },
			{{-1, REDUCE, 44}, {55, SHIFT, 179}, },
			{{-1, REDUCE, 53}, },
			{{-1, REDUCE, 131}, },
			{{-1, ERROR, 121}, {25, SHIFT, 129}, {26, SHIFT, 130}, {32, SHIFT, 182}, },
			{{-1, REDUCE, 130}, },
			{{-1, REDUCE, 129}, },
			{{-1, ERROR, 124}, {21, SHIFT, 70}, {22, SHIFT, 71}, {23, SHIFT, 72}, {27, SHIFT, 73}, {28, SHIFT, 74}, {29, SHIFT, 75}, {30, SHIFT, 76}, {31, SHIFT, 77}, {42, SHIFT, 78}, {44, SHIFT, 79}, {56, SHIFT, 80}, {57, SHIFT, 81}, },
			{{-1, ERROR, 125}, {21, SHIFT, 70}, {22, SHIFT, 71}, {23, SHIFT, 72}, {27, SHIFT, 73}, {28, SHIFT, 74}, {29, SHIFT, 75}, {30, SHIFT, 76}, {31, SHIFT, 77}, {42, SHIFT, 78}, {44, SHIFT, 79}, {56, SHIFT, 80}, {57, SHIFT, 81}, },
			{{-1, ERROR, 126}, {21, SHIFT, 70}, {22, SHIFT, 71}, {23, SHIFT, 72}, {27, SHIFT, 73}, {28, SHIFT, 74}, {29, SHIFT, 75}, {30, SHIFT, 76}, {31, SHIFT, 77}, {42, SHIFT, 78}, {44, SHIFT, 79}, {56, SHIFT, 80}, {57, SHIFT, 81}, },
			{{-1, ERROR, 127}, {21, SHIFT, 70}, {22, SHIFT, 71}, {23, SHIFT, 72}, {27, SHIFT, 73}, {28, SHIFT, 74}, {29, SHIFT, 75}, {30, SHIFT, 76}, {31, SHIFT, 77}, {42, SHIFT, 78}, {44, SHIFT, 79}, {56, SHIFT, 80}, {57, SHIFT, 81}, },
			{{-1, ERROR, 128}, {21, SHIFT, 70}, {22, SHIFT, 71}, {23, SHIFT, 72}, {27, SHIFT, 73}, {28, SHIFT, 74}, {29, SHIFT, 75}, {30, SHIFT, 76}, {31, SHIFT, 77}, {42, SHIFT, 78}, {44, SHIFT, 79}, {56, SHIFT, 80}, {57, SHIFT, 81}, },
			{{-1, ERROR, 129}, {21, SHIFT, 70}, {22, SHIFT, 71}, {23, SHIFT, 72}, {27, SHIFT, 73}, {28, SHIFT, 74}, {29, SHIFT, 75}, {30, SHIFT, 76}, {31, SHIFT, 77}, {42, SHIFT, 78}, {44, SHIFT, 79}, {56, SHIFT, 80}, {57, SHIFT, 81}, },
			{{-1, ERROR, 130}, {21, SHIFT, 70}, {22, SHIFT, 71}, {23, SHIFT, 72}, {27, SHIFT, 73}, {28, SHIFT, 74}, {29, SHIFT, 75}, {30, SHIFT, 76}, {31, SHIFT, 77}, {42, SHIFT, 78}, {44, SHIFT, 79}, {56, SHIFT, 80}, {57, SHIFT, 81}, },
			{{-1, ERROR, 131}, {21, SHIFT, 70}, {22, SHIFT, 71}, {23, SHIFT, 72}, {27, SHIFT, 73}, {28, SHIFT, 74}, {29, SHIFT, 75}, {30, SHIFT, 76}, {31, SHIFT, 77}, {42, SHIFT, 78}, {44, SHIFT, 79}, {56, SHIFT, 80}, {57, SHIFT, 81}, },
			{{-1, ERROR, 132}, {21, SHIFT, 70}, {22, SHIFT, 71}, {23, SHIFT, 72}, {27, SHIFT, 73}, {28, SHIFT, 74}, {29, SHIFT, 75}, {30, SHIFT, 76}, {31, SHIFT, 77}, {42, SHIFT, 78}, {44, SHIFT, 79}, {56, SHIFT, 80}, {57, SHIFT, 81}, },
			{{-1, ERROR, 133}, {21, SHIFT, 70}, {22, SHIFT, 71}, {23, SHIFT, 72}, {27, SHIFT, 73}, {28, SHIFT, 74}, {29, SHIFT, 75}, {30, SHIFT, 76}, {31, SHIFT, 77}, {42, SHIFT, 78}, {44, SHIFT, 79}, {56, SHIFT, 80}, {57, SHIFT, 81}, },
			{{-1, ERROR, 134}, {21, SHIFT, 70}, {22, SHIFT, 71}, {23, SHIFT, 72}, {27, SHIFT, 73}, {28, SHIFT, 74}, {29, SHIFT, 75}, {30, SHIFT, 76}, {31, SHIFT, 77}, {42, SHIFT, 78}, {44, SHIFT, 79}, {56, SHIFT, 80}, {57, SHIFT, 81}, },
			{{-1, ERROR, 135}, {21, SHIFT, 70}, {22, SHIFT, 71}, {23, SHIFT, 72}, {27, SHIFT, 73}, {28, SHIFT, 74}, {29, SHIFT, 75}, {30, SHIFT, 76}, {31, SHIFT, 77}, {42, SHIFT, 78}, {44, SHIFT, 79}, {56, SHIFT, 80}, {57, SHIFT, 81}, },
			{{-1, ERROR, 136}, {21, SHIFT, 70}, {22, SHIFT, 71}, {23, SHIFT, 72}, {27, SHIFT, 73}, {28, SHIFT, 74}, {29, SHIFT, 75}, {30, SHIFT, 76}, {31, SHIFT, 77}, {42, SHIFT, 78}, {44, SHIFT, 79}, {56, SHIFT, 80}, {57, SHIFT, 81}, },
			{{-1, ERROR, 137}, {21, SHIFT, 70}, {22, SHIFT, 71}, {23, SHIFT, 72}, {27, SHIFT, 73}, {28, SHIFT, 74}, {29, SHIFT, 75}, {30, SHIFT, 76}, {31, SHIFT, 77}, {42, SHIFT, 78}, {44, SHIFT, 79}, {56, SHIFT, 80}, {57, SHIFT, 81}, },
			{{-1, ERROR, 138}, {28, SHIFT, 197}, },
			{{-1, ERROR, 139}, {19, SHIFT, 198}, {21, SHIFT, 70}, {22, SHIFT, 71}, {23, SHIFT, 72}, {27, SHIFT, 73}, {28, SHIFT, 74}, {29, SHIFT, 75}, {30, SHIFT, 76}, {31, SHIFT, 77}, {32, SHIFT, 199}, {42, SHIFT, 78}, {44, SHIFT, 79}, {56, SHIFT, 80}, {57, SHIFT, 81}, },
			{{-1, ERROR, 140}, {21, SHIFT, 70}, {22, SHIFT, 71}, {23, SHIFT, 72}, {27, SHIFT, 73}, {28, SHIFT, 74}, {29, SHIFT, 75}, {30, SHIFT, 76}, {31, SHIFT, 77}, {42, SHIFT, 78}, {44, SHIFT, 79}, {56, SHIFT, 80}, {57, SHIFT, 81}, },
			{{-1, REDUCE, 120}, },
			{{-1, REDUCE, 165}, {35, SHIFT, 140}, },
			{{-1, REDUCE, 73}, },
			{{-1, REDUCE, 71}, },
			{{-1, REDUCE, 54}, },
			{{-1, ERROR, 146}, {31, SHIFT, 206}, },
			{{-1, ERROR, 147}, {31, SHIFT, 207}, },
			{{-1, ERROR, 148}, {19, SHIFT, 198}, {21, SHIFT, 70}, {22, SHIFT, 71}, {23, SHIFT, 72}, {27, SHIFT, 73}, {28, SHIFT, 74}, {29, SHIFT, 75}, {30, SHIFT, 76}, {31, SHIFT, 77}, {38, SHIFT, 208}, {42, SHIFT, 78}, {44, SHIFT, 79}, {56, SHIFT, 80}, {57, SHIFT, 81}, },
			{{-1, ERROR, 149}, {31, SHIFT, 210}, },
			{{-1, ERROR, 150}, {38, SHIFT, 211}, },
			{{-1, ERROR, 151}, {31, SHIFT, 212}, },
			{{-1, ERROR, 152}, {21, SHIFT, 70}, {22, SHIFT, 71}, {23, SHIFT, 72}, {27, SHIFT, 73}, {28, SHIFT, 74}, {29, SHIFT, 75}, {30, SHIFT, 76}, {31, SHIFT, 77}, {42, SHIFT, 78}, {44, SHIFT, 79}, {56, SHIFT, 80}, {57, SHIFT, 81}, },
			{{-1, REDUCE, 169}, {28, REDUCE, 105}, {37, REDUCE, 105}, {49, SHIFT, 11}, },
			{{-1, ERROR, 154}, {28, SHIFT, 74}, },
			{{-1, ERROR, 155}, {28, SHIFT, 74}, },
			{{-1, ERROR, 156}, {34, SHIFT, 218}, },
			{{-1, REDUCE, 3}, {1, SHIFT, 1}, {2, SHIFT, 2}, {3, SHIFT, 3}, {4, SHIFT, 4}, {5, SHIFT, 5}, {6, SHIFT, 6}, {9, SHIFT, 146}, {11, SHIFT, 147}, {12, SHIFT, 148}, {13, SHIFT, 149}, {15, SHIFT, 150}, {17, SHIFT, 151}, {18, SHIFT, 152}, {28, SHIFT, 153}, {33, SHIFT, 104}, {43, SHIFT, 154}, {45, SHIFT, 155}, },
			{{-1, REDUCE, 7}, },
			{{-1, ERROR, 159}, {38, SHIFT, 220}, },
			{{-1, REDUCE, 14}, },
			{{-1, ERROR, 161}, {38, SHIFT, 221}, },
			{{-1, ERROR, 162}, {38, SHIFT, 222}, },
			{{-1, ERROR, 163}, {38, SHIFT, 223}, },
			{{-1, REDUCE, 136}, },
			{{-1, REDUCE, 135}, },
			{{-1, REDUCE, 134}, },
			{{-1, REDUCE, 133}, },
			{{-1, ERROR, 168}, {41, SHIFT, 138}, {43, SHIFT, 224}, {45, SHIFT, 225}, {55, SHIFT, 226}, },
			{{-1, REDUCE, 59}, },
			{{-1, REDUCE, 76}, },
			{{-1, REDUCE, 67}, },
			{{-1, REDUCE, 75}, },
			{{-1, REDUCE, 57}, },
			{{-1, ERROR, 174}, {33, SHIFT, 104}, },
			{{-1, REDUCE, 56}, },
			{{-1, ERROR, 176}, {33, SHIFT, 104}, },
			{{-1, ERROR, 177}, {33, SHIFT, 104}, },
			{{-1, ERROR, 178}, {32, SHIFT, 230}, },
			{{-1, ERROR, 179}, {19, SHIFT, 198}, {21, SHIFT, 70}, {22, SHIFT, 71}, {23, SHIFT, 72}, {27, SHIFT, 73}, {28, SHIFT, 74}, {29, SHIFT, 75}, {30, SHIFT, 76}, {31, SHIFT, 77}, {33, SHIFT, 231}, {42, SHIFT, 78}, {44, SHIFT, 79}, {56, SHIFT, 80}, {57, SHIFT, 81}, },
			{{-1, REDUCE, 80}, },
			{{-1, REDUCE, 47}, },
			{{-1, REDUCE, 149}, },
			{{-1, REDUCE, 123}, {46, SHIFT, 126}, {47, SHIFT, 127}, {48, SHIFT, 128}, },
			{{-1, REDUCE, 124}, {46, SHIFT, 126}, {47, SHIFT, 127}, {48, SHIFT, 128}, },
			{{-1, REDUCE, 126}, },
			{{-1, REDUCE, 127}, },
			{{-1, REDUCE, 128}, },
			{{-1, REDUCE, 153}, {24, SHIFT, 131}, },
			{{-1, REDUCE, 154}, {24, SHIFT, 131}, },
			{{-1, REDUCE, 156}, {53, SHIFT, 132}, {54, SHIFT, 133}, },
			{{-1, REDUCE, 158}, {49, SHIFT, 134}, {50, SHIFT, 135}, {51, SHIFT, 136}, {52, SHIFT, 137}, },
			{{-1, REDUCE, 159}, {49, SHIFT, 134}, {50, SHIFT, 135}, {51, SHIFT, 136}, {52, SHIFT, 137}, },
			{{-1, REDUCE, 161}, {42, SHIFT, 124}, {44, SHIFT, 125}, },
			{{-1, REDUCE, 163}, {42, SHIFT, 124}, {44, SHIFT, 125}, },
			{{-1, REDUCE, 162}, {42, SHIFT, 124}, {44, SHIFT, 125}, },
			{{-1, REDUCE, 164}, {42, SHIFT, 124}, {44, SHIFT, 125}, },
			{{-1, REDUCE, 170}, },
			{{-1, ERROR, 198}, {1, SHIFT, 1}, {2, SHIFT, 2}, {3, SHIFT, 3}, {4, SHIFT, 4}, {5, SHIFT, 5}, {6, SHIFT, 6}, {28, SHIFT, 10}, },
			{{-1, REDUCE, 32}, },
			{{-1, ERROR, 200}, {32, SHIFT, 235}, {40, SHIFT, 236}, },
			{{-1, REDUCE, 35}, },
			{{-1, REDUCE, 117}, },
			{{-1, REDUCE, 116}, {25, SHIFT, 129}, {26, SHIFT, 130}, },
			{{-1, ERROR, 204}, {36, SHIFT, 237}, {42, SHIFT, 124}, {44, SHIFT, 125}, },
			{{-1, REDUCE, 119}, },
			{{-1, ERROR, 206}, {21, SHIFT, 70}, {22, SHIFT, 71}, {23, SHIFT, 72}, {27, SHIFT, 73}, {28, SHIFT, 74}, {29, SHIFT, 75}, {30, SHIFT, 76}, {31, SHIFT, 77}, {42, SHIFT, 78}, {44, SHIFT, 79}, {56, SHIFT, 80}, {57, SHIFT, 81}, },
			{{-1, ERROR, 207}, {21, SHIFT, 70}, {22, SHIFT, 71}, {23, SHIFT, 72}, {27, SHIFT, 73}, {28, SHIFT, 74}, {29, SHIFT, 75}, {30, SHIFT, 76}, {31, SHIFT, 77}, {42, SHIFT, 78}, {44, SHIFT, 79}, {56, SHIFT, 80}, {57, SHIFT, 81}, },
			{{-1, REDUCE, 9}, },
			{{-1, ERROR, 209}, {38, SHIFT, 240}, },
			{{-1, ERROR, 210}, {21, SHIFT, 70}, {22, SHIFT, 71}, {23, SHIFT, 72}, {27, SHIFT, 73}, {28, SHIFT, 74}, {29, SHIFT, 75}, {30, SHIFT, 76}, {31, SHIFT, 77}, {42, SHIFT, 78}, {44, SHIFT, 79}, {56, SHIFT, 80}, {57, SHIFT, 81}, },
			{{-1, REDUCE, 13}, },
			{{-1, ERROR, 212}, {1, SHIFT, 1}, {2, SHIFT, 2}, {3, SHIFT, 3}, {4, SHIFT, 4}, {5, SHIFT, 5}, {6, SHIFT, 6}, {28, SHIFT, 153}, },
			{{-1, ERROR, 213}, {33, SHIFT, 104}, },
			{{-1, ERROR, 214}, {25, SHIFT, 129}, {26, SHIFT, 130}, {38, SHIFT, 247}, {39, SHIFT, 248}, },
			{{-1, REDUCE, 141}, {41, SHIFT, 138}, },
			{{-1, REDUCE, 166}, {35, SHIFT, 140}, },
			{{-1, REDUCE, 140}, {41, SHIFT, 138}, },
			{{-1, REDUCE, 31}, },
			{{-1, REDUCE, 2}, },
			{{-1, REDUCE, 6}, },
			{{-1, REDUCE, 5}, },
			{{-1, REDUCE, 4}, },
			{{-1, REDUCE, 15}, },
			{{-1, REDUCE, 139}, },
			{{-1, REDUCE, 138}, },
			{{-1, ERROR, 226}, {19, SHIFT, 198}, {21, SHIFT, 70}, {22, SHIFT, 71}, {23, SHIFT, 72}, {27, SHIFT, 73}, {28, SHIFT, 74}, {29, SHIFT, 75}, {30, SHIFT, 76}, {31, SHIFT, 77}, {42, SHIFT, 78}, {44, SHIFT, 79}, {56, SHIFT, 80}, {57, SHIFT, 81}, },
			{{-1, REDUCE, 61}, },
			{{-1, REDUCE, 60}, },
			{{-1, REDUCE, 58}, },
			{{-1, ERROR, 230}, {33, SHIFT, 104}, },
			{{-1, ERROR, 231}, {19, SHIFT, 198}, {21, SHIFT, 70}, {22, SHIFT, 71}, {23, SHIFT, 72}, {27, SHIFT, 73}, {28, SHIFT, 74}, {29, SHIFT, 75}, {30, SHIFT, 76}, {31, SHIFT, 77}, {33, SHIFT, 231}, {42, SHIFT, 78}, {44, SHIFT, 79}, {56, SHIFT, 80}, {57, SHIFT, 81}, },
			{{-1, REDUCE, 78}, },
			{{-1, REDUCE, 79}, },
			{{-1, ERROR, 234}, {35, SHIFT, 140}, },
			{{-1, REDUCE, 33}, },
			{{-1, ERROR, 236}, {19, SHIFT, 198}, {21, SHIFT, 70}, {22, SHIFT, 71}, {23, SHIFT, 72}, {27, SHIFT, 73}, {28, SHIFT, 74}, {29, SHIFT, 75}, {30, SHIFT, 76}, {31, SHIFT, 77}, {42, SHIFT, 78}, {44, SHIFT, 79}, {56, SHIFT, 80}, {57, SHIFT, 81}, },
			{{-1, REDUCE, 171}, },
			{{-1, ERROR, 238}, {25, SHIFT, 129}, {26, SHIFT, 130}, {32, SHIFT, 257}, },
			{{-1, ERROR, 239}, {25, SHIFT, 129}, {26, SHIFT, 130}, {32, SHIFT, 258}, },
			{{-1, REDUCE, 10}, },
			{{-1, ERROR, 241}, {25, SHIFT, 129}, {26, SHIFT, 130}, {32, SHIFT, 259}, },
			{{-1, REDUCE, 27}, },
			{{-1, ERROR, 243}, {38, SHIFT, 260}, },
			{{-1, REDUCE, 26}, },
			{{-1, ERROR, 245}, {41, SHIFT, 138}, {55, SHIFT, 226}, },
			{{-1, REDUCE, 12}, },
			{{-1, REDUCE, 16}, },
			{{-1, ERROR, 248}, {19, SHIFT, 198}, {21, SHIFT, 70}, {22, SHIFT, 71}, {23, SHIFT, 72}, {27, SHIFT, 73}, {28, SHIFT, 74}, {29, SHIFT, 75}, {30, SHIFT, 76}, {31, SHIFT, 77}, {42, SHIFT, 78}, {44, SHIFT, 79}, {56, SHIFT, 80}, {57, SHIFT, 81}, },
			{{-1, ERROR, 249}, {38, SHIFT, 262}, },
			{{-1, REDUCE, 25}, },
			{{-1, REDUCE, 62}, },
			{{-1, REDUCE, 86}, {40, SHIFT, 263}, },
			{{-1, ERROR, 253}, {34, SHIFT, 266}, },
			{{-1, REDUCE, 82}, {40, SHIFT, 267}, },
			{{-1, REDUCE, 118}, {35, SHIFT, 140}, {37, SHIFT, 26}, },
			{{-1, REDUCE, 34}, },
			{{-1, ERROR, 257}, {33, SHIFT, 104}, },
			{{-1, ERROR, 258}, {33, SHIFT, 104}, },
			{{-1, ERROR, 259}, {33, SHIFT, 273}, },
			{{-1, ERROR, 260}, {21, SHIFT, 70}, {22, SHIFT, 71}, {23, SHIFT, 72}, {27, SHIFT, 73}, {28, SHIFT, 74}, {29, SHIFT, 75}, {30, SHIFT, 76}, {31, SHIFT, 77}, {42, SHIFT, 78}, {44, SHIFT, 79}, {56, SHIFT, 80}, {57, SHIFT, 81}, },
			{{-1, REDUCE, 94}, },
			{{-1, REDUCE, 17}, },
			{{-1, ERROR, 263}, {33, SHIFT, 231}, },
			{{-1, REDUCE, 89}, },
			{{-1, REDUCE, 87}, {40, SHIFT, 263}, },
			{{-1, REDUCE, 81}, },
			{{-1, ERROR, 267}, {19, SHIFT, 198}, {21, SHIFT, 70}, {22, SHIFT, 71}, {23, SHIFT, 72}, {27, SHIFT, 73}, {28, SHIFT, 74}, {29, SHIFT, 75}, {30, SHIFT, 76}, {31, SHIFT, 77}, {42, SHIFT, 78}, {44, SHIFT, 79}, {56, SHIFT, 80}, {57, SHIFT, 81}, },
			{{-1, REDUCE, 85}, },
			{{-1, REDUCE, 83}, {40, SHIFT, 267}, },
			{{-1, REDUCE, 121}, {37, SHIFT, 40}, },
			{{-1, REDUCE, 21}, {10, SHIFT, 280}, },
			{{-1, REDUCE, 8}, },
			{{-1, ERROR, 273}, {14, SHIFT, 282}, {16, SHIFT, 283}, {34, SHIFT, 284}, },
			{{-1, REDUCE, 11}, },
			{{-1, ERROR, 275}, {25, SHIFT, 129}, {26, SHIFT, 130}, {38, SHIFT, 287}, },
			{{-1, REDUCE, 93}, },
			{{-1, REDUCE, 88}, },
			{{-1, REDUCE, 92}, },
			{{-1, REDUCE, 84}, },
			{{-1, ERROR, 280}, {9, SHIFT, 146}, {33, SHIFT, 104}, },
			{{-1, REDUCE, 22}, },
			{{-1, ERROR, 282}, {21, SHIFT, 70}, {22, SHIFT, 71}, {23, SHIFT, 72}, {27, SHIFT, 73}, {28, SHIFT, 74}, {29, SHIFT, 75}, {30, SHIFT, 76}, {31, SHIFT, 77}, {42, SHIFT, 78}, {44, SHIFT, 79}, {56, SHIFT, 80}, {57, SHIFT, 81}, },
			{{-1, ERROR, 283}, {39, SHIFT, 292}, },
			{{-1, REDUCE, 36}, },
			{{-1, REDUCE, 39}, },
			{{-1, ERROR, 286}, {14, SHIFT, 282}, {16, SHIFT, 283}, {34, SHIFT, 293}, },
			{{-1, ERROR, 287}, {28, SHIFT, 74}, {32, SHIFT, 295}, {43, SHIFT, 154}, {45, SHIFT, 155}, },
			{{-1, REDUCE, 18}, },
			{{-1, REDUCE, 20}, },
			{{-1, REDUCE, 19}, },
			{{-1, ERROR, 291}, {25, SHIFT, 129}, {26, SHIFT, 130}, {39, SHIFT, 300}, },
			{{-1, ERROR, 292}, {33, SHIFT, 104}, },
			{{-1, REDUCE, 37}, },
			{{-1, REDUCE, 38}, },
			{{-1, REDUCE, 23}, },
			{{-1, REDUCE, 29}, },
			{{-1, ERROR, 297}, {32, SHIFT, 302}, },
			{{-1, REDUCE, 30}, },
			{{-1, REDUCE, 28}, },
			{{-1, ERROR, 300}, {33, SHIFT, 104}, },
			{{-1, REDUCE, 41}, },
			{{-1, REDUCE, 24}, },
			{{-1, REDUCE, 40}, },
        };*/
    private static int[][][] gotoTable;
/*      {
			{{-1, 12}, {13, 24}, },
			{{-1, 156}, {157, 219}, },
			{{-1, 157}, },
			{{-1, 281}, },
			{{-1, 288}, },
			{{-1, 158}, {280, 289}, },
			{{-1, 213}, },
			{{-1, 159}, {212, 242}, {287, 296}, },
			{{-1, 243}, },
			{{-1, 297}, },
			{{-1, 160}, {56, 105}, {106, 169}, {112, 173}, {114, 175}, {174, 227}, {176, 228}, {177, 229}, {213, 246}, {230, 251}, {257, 271}, {258, 272}, {280, 290}, {292, 301}, {300, 303}, },
			{{-1, 82}, {104, 161}, {157, 161}, {287, 298}, },
			{{-1, 200}, },
			{{-1, 274}, },
			{{-1, 285}, {286, 294}, },
			{{-1, 44}, {104, 162}, {157, 162}, {212, 244}, },
			{{-1, 13}, },
			{{-1, 45}, {47, 67}, {69, 67}, },
			{{-1, 57}, {60, 113}, {61, 115}, {116, 178}, },
			{{-1, 52}, },
			{{-1, 100}, {101, 144}, },
			{{-1, 58}, {107, 170}, },
			{{-1, 108}, {109, 171}, },
			{{-1, 50}, {64, 117}, {118, 180}, },
			{{-1, 181}, },
			{{-1, 232}, {231, 252}, {263, 276}, },
			{{-1, 253}, },
			{{-1, -1}, },
			{{-1, 268}, {269, 279}, },
			{{-1, 264}, {265, 277}, },
			{{-1, 249}, },
			{{-1, 83}, },
			{{-1, 46}, {0, 14}, {8, 19}, {11, 22}, {13, 14}, {17, 28}, {33, 53}, {38, 59}, {60, 59}, {61, 59}, {107, 59}, {116, 59}, {198, 234}, },
			{{-1, 15}, },
			{{-1, 16}, },
			{{-1, 17}, {10, 21}, {18, 30}, {153, 21}, },
			{{-1, 23}, },
			{{-1, 34}, {36, 55}, {54, 55}, },
			{{-1, 201}, {148, 209}, {226, 250}, {231, 254}, {236, 256}, {248, 261}, {267, 278}, },
			{{-1, 202}, {179, 233}, },
			{{-1, 84}, {134, 193}, {135, 194}, {136, 195}, {137, 196}, {140, 204}, },
			{{-1, 85}, {124, 183}, {125, 184}, },
			{{-1, 86}, {73, 120}, {78, 122}, {79, 123}, {126, 185}, {127, 186}, {128, 187}, },
			{{-1, 163}, {287, 299}, },
			{{-1, 87}, },
			{{-1, 164}, },
			{{-1, 165}, },
			{{-1, 166}, },
			{{-1, 167}, },
			{{-1, 88}, },
			{{-1, 89}, },
			{{-1, 203}, {49, 90}, {77, 121}, {152, 214}, {179, 90}, {206, 238}, {207, 239}, {210, 241}, {260, 275}, {282, 291}, },
			{{-1, 91}, {129, 188}, {130, 189}, },
			{{-1, 92}, {131, 190}, },
			{{-1, 93}, {132, 191}, {133, 192}, },
			{{-1, 94}, {104, 168}, {154, 215}, {155, 217}, {157, 168}, {212, 245}, {287, 168}, },
			{{-1, 95}, {154, 216}, {155, 216}, {212, 216}, },
			{{-1, 96}, },
			{{-1, 97}, },
			{{-1, 141}, {142, 205}, {255, 205}, },
			{{-1, 286}, },
			{{-1, 27}, {22, 35}, {28, 42}, {46, 65}, {53, 103}, {59, 111}, {255, 270}, },
			{{-1, 47}, {48, 69}, },
			{{-1, 109}, },
			{{-1, 101}, },
			{{-1, 269}, },
			{{-1, 265}, },
			{{-1, 36}, {35, 54}, },
			{{-1, 142}, {234, 255}, },
        };*/
    private static String[] errorMessages;
/*      {
			"expecting: 'boolean', 'char', 'int', 'double', 'String', 'void', 'class', 'const', 'enum', identifier, '<', EOF",
			"expecting: identifier, '[', bracket pair, ',', '>'",
			"expecting: identifier",
			"expecting: 'boolean', 'char', 'int', 'double', 'String', 'void', identifier",
			"expecting: identifier, '[', bracket pair, ',', '<', '>'",
			"expecting: EOF",
			"expecting: identifier, bracket pair",
			"expecting: '{', '<'",
			"expecting: '{'",
			"expecting: bracket pair, ',', '>'",
			"expecting: '>'",
			"expecting: '('",
			"expecting: identifier, ')', '}', bracket pair, ';', ',', '>'",
			"expecting: 'boolean', 'char', 'int', 'double', 'String', 'void', identifier, '}'",
			"expecting: '='",
			"expecting: ',', '>'",
			"expecting: 'boolean', 'char', 'int', 'double', 'String', 'void', identifier, '{', '[', bracket pair, ',', '>'",
			"expecting: 'boolean', 'char', 'int', 'double', 'String', 'void', identifier, ')'",
			"expecting: ';'",
			"expecting: 'true', 'false', 'null', '!', identifier, stringliteral, charliteral, '(', '+', '-', intnumber, dpnumber",
			"expecting: ';', ','",
			"expecting: ')'",
			"expecting: ')', ','",
			"expecting: ';', '='",
			"expecting: '&&', '||', '^', ')', '}', ']', ';', ':', ',', '+', '-', '*', '/', '%', '<', '<=', '>', '>=', '==', '!='",
			"expecting: '&&', '||', '^', '(', ')', '}', '[', ']', ';', ':', ',', dot, '+', '++', '-', '--', '*', '/', '%', '<', '<=', '>', '>=', '==', '!=', '='",
			"expecting: '&&', '||', '^', ')', '}', ';', ':', ',', '+', '-', '<', '<=', '>', '>=', '==', '!='",
			"expecting: '||', '^', ';'",
			"expecting: '&&', '||', '^', ')', '}', ';', ':', ','",
			"expecting: '&&', '||', '^', ')', '}', ';', ':', ',', '==', '!='",
			"expecting: '&&', '||', '^', ')', '}', ';', ':', ',', '<', '<=', '>', '>=', '==', '!='",
			"expecting: '&&', '||', '^', ')', '}', ']', ';', ':', ',', dot, '+', '-', '*', '/', '%', '<', '<=', '>', '>=', '==', '!='",
			"expecting: '}'",
			"expecting: 'boolean', 'char', 'int', 'double', 'String', 'void', 'if', 'while', 'return', 'switch', 'break', 'for', 'assert', identifier, '{', '}', '++', '--'",
			"expecting: '||', '^', ')'",
			"expecting: 'new', 'true', 'false', 'null', '!', identifier, stringliteral, charliteral, '(', ')', '+', '-', intnumber, dpnumber",
			"expecting: '&&', '||', '^', ')', '}', '[', ']', bracket pair, ';', ':', ',', dot, '+', '++', '-', '--', '*', '/', '%', '<', '<=', '>', '>=', '==', '!=', '='",
			"expecting: '&&', '||', '^', ')', '}', '[', ']', ';', ':', ',', dot, '+', '++', '-', '--', '*', '/', '%', '<', '<=', '>', '>=', '==', '!=', '='",
			"expecting: 'new', 'true', 'false', 'null', '!', identifier, stringliteral, charliteral, '(', ';', '+', '-', intnumber, dpnumber",
			"expecting: identifier, '(', '[', bracket pair, dot, '++', '--', '<', '='",
			"expecting: ')', ';'",
			"expecting: dot, '++', '--', '='",
			"expecting: 'new', 'true', 'false', 'null', '!', identifier, stringliteral, charliteral, '(', '{', '+', '-', intnumber, dpnumber",
			"expecting: ')', '}', ';', ','",
			"expecting: '||', '^', ')', '}', ';', ','",
			"expecting: ']', '+', '-'",
			"expecting: '||', '^', ';', ':'",
			"expecting: ')', ';', dot",
			"expecting: ')', '[', ';', dot, '='",
			"expecting: 'boolean', 'char', 'int', 'double', 'String', 'void', 'class', 'const', 'if', 'else', 'while', 'return', 'switch', 'case', 'break', 'default', 'for', 'assert', 'enum', identifier, '{', '}', '++', '--', '<', EOF",
			"expecting: 'new', 'true', 'false', 'null', '!', identifier, stringliteral, charliteral, '(', '+', '-', intnumber, dpnumber",
			"expecting: '['",
			"expecting: dot, '='",
			"expecting: '}', ','",
			"expecting: ')', '}', '[', bracket pair, ';', ','",
			"expecting: '}', ';', ','",
			"expecting: ')', '}', bracket pair, ';', ','",
			"expecting: 'boolean', 'char', 'int', 'double', 'String', 'void', 'if', 'else', 'while', 'return', 'switch', 'break', 'for', 'assert', identifier, '{', '}', '++', '--'",
			"expecting: 'case', 'default', '}'",
			"expecting: 'if', '{'",
			"expecting: ':'",
			"expecting: identifier, ')', '++', '--'",
			"expecting: '||', '^', ':'",
        };*/
    private static int[] errors;
/*      {
			0, 1, 1, 1, 1, 1, 1, 2, 3, 2, 4, 3, 5, 0, 6, 1, 1, 3, 7, 2, 8, 1, 9, 10, 5, 11, 12, 6, 6, 13, 8, 14, 2, 3, 15, 9, 15, 16, 17, 11, 12, 11, 6, 0, 18, 13, 6, 13, 13, 19, 18, 20, 18, 9, 15, 15, 8, 21, 22, 6, 17, 17, 11, 13, 23, 6, 0, 13, 0, 13, 24, 24, 24, 19, 25, 24, 24, 19, 19, 19, 24, 24, 24, 24, 26, 24, 24, 24, 24, 24, 27, 28, 29, 30, 31, 25, 25, 25, 0, 2, 20, 20, 32, 9, 33, 0, 8, 3, 22, 22, 22, 6, 8, 21, 8, 21, 17, 18, 23, 0, 24, 34, 24, 24, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 2, 35, 19, 36, 37, 20, 20, 0, 11, 11, 38, 11, 18, 11, 19, 39, 2, 2, 32, 33, 33, 18, 33, 18, 18, 18, 40, 40, 40, 40, 41, 0, 22, 22, 22, 0, 8, 0, 8, 8, 21, 42, 18, 18, 24, 24, 24, 24, 24, 24, 28, 28, 29, 30, 30, 26, 26, 26, 26, 25, 3, 24, 22, 22, 43, 44, 45, 36, 19, 19, 33, 18, 19, 33, 3, 8, 46, 47, 48, 47, 49, 32, 33, 33, 33, 33, 40, 40, 50, 0, 0, 0, 8, 42, 18, 18, 51, 24, 50, 36, 34, 34, 33, 34, 18, 18, 18, 52, 33, 33, 50, 18, 40, 0, 53, 32, 53, 54, 22, 8, 8, 8, 19, 18, 33, 8, 53, 53, 55, 50, 53, 53, 56, 57, 33, 58, 33, 27, 53, 53, 53, 53, 59, 33, 19, 60, 33, 58, 58, 61, 33, 33, 33, 62, 8, 33, 58, 8, 21, 21, 21, 21, 8, 58, 8, 58, 
        };*/
}
