/* *******************************************************************************
 *   kenya                                                             *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/
/*
 * Created on 26-Aug-2004
 */
package org.wellquite.kenya.stackMachine;

import org.wellquite.kenya.stackMachine.scope.ClosureScope;
import org.wellquite.kenya.stackMachine.scope.IClosureScope;
import org.wellquite.kenya.stackMachine.types.interfaces.IAtomicClosure;

/**
 * @author Matthew Sackman (ms02)
 * @version 1
 */
public class ClosureMiscHelper {

    public static void executeClosureInScope(IClosureScope oldScope,
            IAtomicClosure closure, StackMachine sm) {
        IClosureScope newScope = new ClosureScope();
        try {
            if (oldScope != null) {
                newScope.setPreviousScope(oldScope);
                oldScope.setNextScope(newScope);
                oldScope.switchToNextScope(sm);
            }
            closure.setClosureScope(newScope);
            newScope.setClosure(closure);
            closure.execute(sm);
        } catch (RuntimeException re) { // we can recover gracefullyish but
            IClosureScope firstScope = newScope; // keep throwing the error
            while (firstScope.getPreviousScope() != null) { // upwards
                firstScope = firstScope.getPreviousScope();
            }
            firstScope.setReturn(true);
            throw re;
        } finally {
            closure.unsetClosureScope(newScope);
            newScope.switchToPreviousScope(sm);            
        }
    }

}