/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on Aug 9, 2004
 *
 */
package org.wellquite.kenya.stackMachine.misc;

import java.util.List;

/**
 * @author Matthew Sackman
 * @version 1
 */
public class JobRunner implements Runnable {

    private final Object lock;

    private final List outStandingJobs;

    private boolean idle = true;

    private boolean running = false;

    private AbstractJob myJob = null;

    public JobRunner(Object lock, List jobsList) {
        this.lock = lock;
        outStandingJobs = jobsList;
    }

    private void setRunning(boolean value) {
        synchronized (lock) {
            synchronized (this) {
                running = value;
                lock.notifyAll();
            }
        }
    }

    public synchronized boolean isRunning() {
        return running;
    }

    private synchronized void setIdle(boolean value) {
        idle = value;
        if (idle) Thread.currentThread().setName("Idle Thread");
    }

    public synchronized boolean isIdle() {
        return idle;
    }

    public void run() {
        setIdle(true);
        setRunning(true);

        while (JobDispatch.isThreadRunning(this)) {
            synchronized (lock) {

                while (outStandingJobs.size() == 0
                        && JobDispatch.isThreadRunning(this)) {
                    try {
                        lock.wait();
                    } catch (InterruptedException e) {
                    }
                }

                if (outStandingJobs.size() != 0) {
                    setIdle(false);
                    myJob = (AbstractJob) outStandingJobs.remove(0);
                    Thread.currentThread().setName("Thread running: " + myJob);
                }
            }

            if (myJob != null) {
                try {
                    myJob.execute();
                } catch (RuntimeException e) {
                    setRunning(false);
                    setIdle(true);
                    JobDispatch.threadExiting(this);
                    throw e;
                }
                myJob.finished();
                myJob = null;
            }
            setIdle(true);
        }

        setRunning(false);
        setIdle(true);
        JobDispatch.threadExiting(this);
    }

}