/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on Jul 7, 2004
 *
 */
package org.wellquite.kenya.stackMachine.ops;

import org.wellquite.kenya.stackMachine.StackMachine;
import org.wellquite.kenya.stackMachine.types.AbstractAtomicClosure;
import org.wellquite.kenya.stackMachine.types.StringTypeFactory;
import org.wellquite.kenya.stackMachine.types.interfaces.IArrayType;
import org.wellquite.kenya.stackMachine.types.interfaces.IAtomicClosure;
import org.wellquite.kenya.stackMachine.types.interfaces.IBooleanType;
import org.wellquite.kenya.stackMachine.types.interfaces.ICharType;
import org.wellquite.kenya.stackMachine.types.interfaces.IClassInstanceType;
import org.wellquite.kenya.stackMachine.types.interfaces.IClassStaticType;
import org.wellquite.kenya.stackMachine.types.interfaces.IEnumType;
import org.wellquite.kenya.stackMachine.types.interfaces.INullType;
import org.wellquite.kenya.stackMachine.types.interfaces.INumericType;
import org.wellquite.kenya.stackMachine.types.interfaces.IStringType;
import org.wellquite.kenya.stackMachine.types.interfaces.IType;

/**
 * This class contains static factory methods that manipulate IStringType
 * instances on the stack. Unless otherwise stated, all methods remove from the
 * stack any arguements they require.
 * 
 * @author Matthew Sackman (ms02)
 * @version 1
 */
public class StringOpsFactory {

    private StringOpsFactory() {
    }

    private static final IAtomicClosure concat = new AbstractAtomicClosure() {

        public void execute(StackMachine sm) {
            String string0 = "";
            IType arg0 = sm.pop();

            if (arg0 instanceof IClassInstanceType) {
                string0 = ((IClassInstanceType) arg0).valueToString();
            } else if (arg0 instanceof IClassStaticType) {
                string0 = ((IClassStaticType) arg0).valueToString();
            } else if (arg0 instanceof IStringType) {
                string0 = ((IStringType) arg0).valueToString();
            } else if (arg0 instanceof IArrayType) {
                string0 = ((IArrayType) arg0).valueToString();
            } else if (arg0 instanceof IBooleanType) {
                string0 = ((IBooleanType) arg0).valueToString();
            } else if (arg0 instanceof ICharType) {
                string0 = ((ICharType) arg0).valueToString();
            } else if (arg0 instanceof INumericType) {
                string0 = ((INumericType) arg0).valueToString();
            } else if (arg0 instanceof IEnumType){
                string0 = ((IEnumType) arg0).valueToString();
            } else if (arg0 instanceof INullType){
                string0 = ((INullType) arg0).valueToString();
            } else {
                throw new RuntimeException(
                        "Unable to convert type to string: unrecognized type for '"
                                + arg0 + "', class: " + arg0.getClass());
            }

            String string1 = "";
            IType arg1 = sm.pop();
            if (arg1 instanceof IClassInstanceType) {
                string1 = ((IClassInstanceType) arg1).valueToString();
            } else if (arg1 instanceof IClassStaticType) {
                string1 = ((IClassStaticType) arg1).valueToString();
            } else if (arg1 instanceof IStringType) {
                string1 = ((IStringType) arg1).valueToString();
            } else if (arg1 instanceof IArrayType) {
                string1 = ((IArrayType) arg1).valueToString();
            } else if (arg1 instanceof IBooleanType) {
                string1 = ((IBooleanType) arg1).valueToString();
            } else if (arg1 instanceof ICharType) {
                string1 = ((ICharType) arg1).valueToString();
            } else if (arg1 instanceof INumericType) {
                string1 = ((INumericType) arg1).valueToString();
            } else if (arg1 instanceof IEnumType){
                string1 = ((IEnumType) arg1).valueToString();
            } else if (arg1 instanceof INullType){
                string1 = ((INullType) arg1).valueToString();
            } else {
                throw new RuntimeException(
                        "Unable to convert type to string: unrecognized type for '"
                                + arg1 + "', class: " + arg1.getClass());
            }

            sm.push(StringTypeFactory.createStringType(string0 + string1));
        }
        
        public String toString() {
            return "concat";
        }
    };

    /**
     * The returned closure takes the top two items on the stack. Obtains string
     * representations of the two items, concatenates the strings and places the
     * result in an IStringType instance on the top of the stack.
     * <p>
     * If arg0 is the top of the stack and arg1 is the next item then the result
     * is arg0.toString() + arg1.toString().
     * 
     * @return
     */
    public static IAtomicClosure concat() {
        return concat;
    }
    
}