/* *******************************************************************************
 *   kenya                                                             *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/
/*
 * Created on 26-Aug-2004
 */
package org.wellquite.kenya.stackMachine.scope;

import org.wellquite.kenya.stackMachine.StackMachine;
import org.wellquite.kenya.stackMachine.types.interfaces.IAtomicClosure;


/**
 * @author Matthew Sackman (ms02)
 * @version 1
 */
public interface IClosureScope {

    /**
     * The previous scope before the method in this scope was invoked.
     * 
     * @return The previous scope.
     */
    IClosureScope getPreviousScope();

    /**
     * Set the previous scope. This allows a fully linked chain to be
     * established, providing a return path as methods complete.
     * 
     * @param previousScope
     */
    void setPreviousScope(IClosureScope previousScope);

    /**
     * Return to the previous scope. This will be called when a method
     * completes.
     */
    void switchToPreviousScope(StackMachine sm);

    void switchToNextScope(StackMachine sm);
    
    void setReturn(boolean value);
    
    boolean getReturn();
    
    void setNextScope(IClosureScope nextScope);
    
    IClosureScope getNextScope();
    
    void setClosure(IAtomicClosure closure);
    
    IAtomicClosure getClosure();
}
