/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on 05-Jul-2004
 */
package org.wellquite.kenya.stackMachine.types;

import org.wellquite.kenya.stackMachine.types.interfaces.INullType;
import org.wellquite.kenya.stackMachine.types.interfaces.IStringType;

/**
 * Basic implementation of IStringType. Calling setValue when a value is already
 * set will throw an error.
 * 
 * @author Matthew Sackman (ms02)
 * @version 1
 */
public class StringType implements IStringType {
    
    private static final String nullName = "null";

    private String value = null;

    private boolean assigned = false;

    public StringType() {
    }

    public StringType(String value) {
        this.value = value;
        assigned = true;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.wellquite.kenya.stackMachine.types.interfaces.INumericType#getValue()
     */
    public synchronized String getValue() {
        return new String(value);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.wellquite.kenya.stackMachine.types.interfaces.INumericType#setValue(java.lang.Number)
     */
    public synchronized void setValue(String value) {
        if (assigned && this.value != null)
            modificationError(this);
        else {
            this.value = new String(value);
            assigned = true;
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    public synchronized String toString() {
        return "StringType: " + value;
    }

    private static void modificationError(StringType variable) {
        throw new RuntimeException("Attempt made to modify String variable: "
                + variable);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.wellquite.kenya.stackMachine.types.interfaces.IType#isAssigned()
     */
    public synchronized boolean valueSet() {
        return assigned && value != null;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.wellquite.kenya.stackMachine.types.interfaces.INonPrimitiveType#getValueClass()
     */
    public String getValueClassName() {
        return String.class.getName();
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.wellquite.kenya.stackMachine.types.interfaces.IType#valueToString()
     */
    public String valueToString() {
        if (getValue() == null)
            return nullName;
        else
            return value.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof IStringType)
            return ((IStringType) obj).getValue().equals(getValue());
        else if (obj instanceof INullType)
        	throw new NullPointerException();
        else
            return false;
    }

    public int hashCode() {
        if (getValue() == null)
            return nullName.hashCode();
        else
            return getValue().hashCode();
    }

	/* (non-Javadoc)
	 * @see org.wellquite.kenya.stackMachine.types.interfaces.IType#getTypeName()
	 */
	public String getTypeName() {
		return TYPE_NAME;
	}
	
	/* (non-Javadoc)
	 * @see org.wellquite.kenya.stackMachine.types.interfaces.IType#clone()
	 */
	public Object clone() throws CloneNotSupportedException {
		StringType t = (StringType)super.clone();
		return t;
	}
	
}