/* *******************************************************************************
 *   kenya                                                             *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/
/*
 * Created on 17-Aug-2004
 */
package org.wellquite.kenya.stackMachine.types.interfaces;

import org.wellquite.kenya.stackMachine.types.AbstractAtomicClosure;

/**
 * This allows you to more easily write switch statements for the StackMachine.
 * Each instance represents a case statement with associated code.
 * 
 * @author Matthew Sackman (ms02)
 * @version 1
 */
public interface ISwitchCaseClosure {

    /**
     * Sets the condition closure. This closure is responsible for figuring out
     * whether to run this switch case block or not. It is not provided with
     * anything on the stack and must leave an IBooleanType instance on the
     * stack when finished. If that IBooleanType instance is true then the body
     * is run, otherwise it will only be run if the previous case did not break
     * and was run or this case is default.
     * 
     * @param condition
     */
    void setConditionClosure(AbstractAtomicClosure condition);

    AbstractAtomicClosure getConditionClosure();

    /**
     * Sets the body closure. This closure is run if the condition closure is
     * true or the body was otherwise chosen to be run (right time of day, moon
     * in the sky etc).
     * 
     * @param body
     */
    void setBodyClosure(AbstractAtomicClosure body);

    AbstractAtomicClosure getBodyClosure();

    /**
     * Sets whether this case is the default case. If it is the default case
     * then the closure will be run regardless of the condition or the previous
     * case.
     * 
     * @param value
     */
    void setDefault(boolean value);

    boolean isDefault();

    /**
     * Sets whether there is a break at the end of this case. You should not use
     * the returnFromClosure() methods in the body of the case unless you are
     * returning from an outer closure.
     * 
     * @param value
     */
    void setBreakAfter(boolean value);

    boolean breakAfter();
}